<?php
class Directory_Coupon extends MY_Model
{
    const DB_TABLE = 'directory_coupons';
    const DB_TABLE_PK = 'coupon_id';

    function LoadBySiteID($id)
    {
        $query = $this->db->query("SELECT c.*, com.company
                                  FROM directory_coupons AS c
                                  INNER JOIN directory_companies AS com ON c.company_id=com.company_id
                                  WHERE com.published='1' AND c.site_id=? AND (valid_from IS NULL OR valid_from <= '" . date("Y-m-d") . "') AND
                                  (valid_to IS NULL OR valid_to >= '" . date("Y-m-d") . "')
                                  ORDER BY `valid_from`, coupon",
                                  array($id));

        return $query->result();
    }

    function LoadByCompanyID($id)
    {
        $query = $this->db->query("SELECT c.*, com.company
                                  FROM directory_coupons AS c
                                  INNER JOIN directory_companies AS com ON c.company_id=com.company_id
                                  WHERE com.published='1' AND c.company_id=? AND (valid_from IS NULL OR valid_from <= '" . date("Y-m-d") . "') AND
                                  (valid_to IS NULL OR valid_to >= '" . date("Y-m-d") . "')
                                  ORDER BY `valid_from`, coupon",
                                  array($id));

        return $query->result();
    }
}
