<?php
class Event_Form extends MY_Model
{
	const DB_TABLE = 'events_forms';
    const DB_TABLE_PK = 'form_id';

    function LoadActive()
	{
		$query = $this->db->query("SELECT * FROM events_forms
		                          WHERE registration_start <= '" . date("Y-m-d") . "' AND registration_end >= '" . date("Y-m-d") . "'
		                          ORDER BY title");

		return $query->result();
	}

	function LoadBySiteID($site_id)
	{
		$query = $this->db->query("SELECT f.* FROM events_forms AS f
		                          INNER JOIN events AS e USING(event_id)
		                          WHERE e.site_id=? AND f.registration_start <= '" . date("Y-m-d") . "' AND f.registration_end >= '" . date("Y-m-d") . "'
		                          ORDER BY f.title",
		                          array($site_id));

		return $query->result();
	}

	function LoadByEventID($event_id, $parent_id)
	{
		$query = $this->db->query("SELECT * FROM events_forms
		                          WHERE (event_id=? OR event_id=?) AND registration_start <= '" . date("Y-m-d") . "' AND registration_end >= '" . date("Y-m-d") . "'
		                          ORDER BY title",
		                          array($event_id, $parent_id));

		return $query->result();
	}

	function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}
}
