<?php
class ModulePageLink extends MY_Model
{
	const DB_TABLE = 'modules_pages';
    const DB_TABLE_PK = 'module_page_id';

	function LoadByModulePageIDs($module_instance_id, $page_id)
	{
	  	$query = $this->db->query("SELECT * FROM modules_pages WHERE module_instance_id=? AND page_id=?", array($module_instance_id, $page_id));

	  	if($query->num_rows() > 0)
	  	{
	  		foreach($query->result() as $row)
	  		{
	  			//load the first item
		  		return $this->populate($row);
	  		}
	  	}
	  	else
	  	{
	  		return false;
	  	}
	}

	public function add_link($module_instance_id, $page_id)
    {
	    $result = $this->db->query("SELECT module_page_id FROM modules_pages WHERE module_instance_id=? AND page_id=?", array($module_instance_id, $page_id));

	    if($result->num_rows() > 0)
	    {
		    //a link already exists
		    return true;
	    }
	    else
	    {
		    $this->db->query("INSERT INTO modules_pages SET module_instance_id=?, page_id=?", array($module_instance_id, $page_id));

		    return ($this->db->affected_rows() > 0);
	    }

	    return false;
    }

    public function delete_all($page_id)
    {
    	$this->db->query("DELETE FROM modules_pages WHERE page_id=?", array($page_id));
    }

    public function delete_others($page_id, $ids)
    {
    	$this->db->query("DELETE FROM modules_pages WHERE page_id=? AND module_instance_id NOT IN ($ids)", array($page_id));
    }
}
