<?php
class Creditcard extends Shop_Abstract_Payment_Gateway
{
	/**
	 Demo URLS
	• https://demo.myvirtualmerchant.com/VirtualMerchantDemo/process.do for
	name/value pairs formatted single request.
	• https://demo.myvirtualmerchant.com/VirtualMerchantDemo/processBatch.do
	for name/value pairs formatted batch request.
	• https://demo.myvirtualmerchant.com/VirtualMerchantDemo/processxml.do for
	XML formatted single request.

	Production URLS
	Once integration testing has been completed and you are ready to begin processing production
	transactions, you must ensure that your integrated solution is pointed to the production environment and
	pass your unique production credentials posting to the following URLS:
	• https://www.myvirtualmerchant.com/VirtualMerchant/process.do
	name/value pairs formatted single request.
	for
	• https://www.myvirtualmerchant.com/VirtualMerchant/processBatch.do for
	name/value pairs formatted batch request.
	• https://www.myvirtualmerchant.com/VirtualMerchant/processxml.do for XML
	formatted single request.
	 */

	private $config = array();

	public function init()
	{
		$CI =& get_instance();
		$query = $CI->db->query("SELECT * FROM shop_payment_gateways WHERE filename='creditcard' LIMIT 1");

		foreach($query->result() as $row)
		{
			$configs = explode("\n", $row->configuration);
			$this->config = array();

			foreach($configs as $config)
			{
				if($config)
				{
					$line = explode("=", $config, 2);
					$this->config[$line[0]] = $line[1];
				}
			}
		}
	}

    public function process($order, $payment_vars, &$messages)
    {
    	if(isset($this->config["demo"]) && $this->config["demo"])
    	{
    		$order->order_total = "10";
    	}

    	mt_srand();
    	$sid = mt_rand(100000000000, 999999999999);	//12 digit random number

    	$request = "ssl_merchant_id=" . 			$this->config["merchant_id"] . "&";
    	$request .= "ssl_user_id=" . 				$this->config["user_id"] . "&";
    	$request .= "ssl_pin=" . 					$this->config["pin"] . "&";
    	$request .= "SID=$sid&";
    	$request .= "ssl_transaction_type=ccsale&";
    	$request .= "ssl_show_form=false&";
    	$request .= "ssl_result_format=ASCII&";
    	$request .= "ssl_test_mode=" . ((isset($this->config["demo"]) && $this->config["demo"]) ? 1 : 0) . "&";
    	$request .= "CardName=" . 					$payment_vars["payment_cc_name"] . "&";
		$request .= "email=" . 						$order->customer_email . "&";
		$request .= "ssl_city=" . 					$order->customer_city . "&";
		$request .= "ssl_state=" . 					$order->customer_province . "&";
		$request .= "ssl_country=" . 				$order->customer_country . "&";
		$request .= "ssl_first_name=" . 			$order->customer_name . "&";
		$request .= "ssl_last_name=" . 				$order->customer_name . "&";
		$request .= "ssl_card_number=" . 			$payment_vars["payment_cc_num"] . "&";
		$request .= "ssl_exp_date=" . 				$payment_vars["payment_cc_exp_month"] . $payment_vars["payment_cc_exp_year"] . "&";
		$request .= "ssl_amount=" . 				$order->order_total . "&";
		$request .= "ssl_card_present=N&";
		$request .= "ssl_avs_zip=" . 				$order->customer_postalcode . "&";
		$request .= "ssl_avs_address=" . 			$order->customer_address . "&";
		$request .= "ssl_cvv2cvc2=" . 				$payment_vars["payment_cc_cvv"] . "&";
		$request .= "ssl_cvv2cvc2_indicator=1&";	//CVV present
		$request .= "ssl_invoice_number=" . 		$order->order_id . "&";
		$request .= "ssl_partial_auth_indicator=1";
		//$request .= "ssl_transaction_currency=" . 	$ssl_transaction_currency;		//must have this enabled on account
		//$request .= "ssl_error_url=''&";
		//$request .= "ssl_receipt_apprvl_get_url=''&";
		//
    	return $this->send_request($request, $order, $messages);
    }

    private function send_request($request, &$order, &$messages)
    {
		$curl = curl_init();

		curl_setopt($curl, CURLOPT_URL, $this->config["url"]);
		//curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=UTF-8'));
		curl_setopt($curl, CURLOPT_TIMEOUT, 5);
		curl_setopt($curl, CURLOPT_MAXREDIRS, 3);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_USERAGENT, "Nerivon.com");
		curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
		curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
		$result = curl_exec($curl);
		$status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		$response = $this->parse_response($result, $messages);

		if($this->process_response($response, $messages))
		{
			$order->paid = 1;
			$order->save();

			return $response["ssl_txn_id"];
		}
		else
		{
			return false;
		}
    }

    private function parse_response($response, &$messages)
    {
    	$response_array = array();
    	$lines = explode("\n", $response);

    	for($i=0; $i<count($lines); $i++)
    	{
    		$parts = explode("=", $lines[$i]);
    		$response_array[$parts[0]] = $parts[1];
    	}

		return $response_array;
	}

	private function process_response($response, &$messages)
	{
    	$approved = (isset($response['ssl_result']) && $response['ssl_result'] == 0);

    	if($approved)
    	{
    		//$messages[] = "Transaction Approved";
    		//$messages[] = "Name on Card: " . $response["CardName"];
    		//$messages[] = "Card #: " . $response["ssl_card_number"];
    		//$messages[] = "Expires: " . $response["ssl_exp_date"];
    		//$messages[] = "Amount: $" . $response["ssl_amount"];
    		$messages[] = "Transaction #: " . $response["ssl_txn_id"];
    		$messages[] = "Authorization Code: " . $response["ssl_approval_code"];
    	}
    	else if(!$approved)
    	{
    		//$messages[] = "Transaction Declined";
    		//$messages[] = "Amount: $" . $response["ssl_amount"];
    		if(isset($response["ssl_txn_id"]))
			{
				$messages[] = "Transaction #: " . $response["ssl_txn_id"];
			}

    		if(isset($response["errorMessage"]))
    		{
	    		if($response["errorMessage"] < 4000)
				{
					$messages[] = "System error: " . $response["errorMessage"];
				}
				else if ($response["errorMessage"] > 4000)
				{
					$messages[] = "Authentication error: " . $response["errorMessage"];
				}
				else
				{
					$messages[] = "Syntax error: " . $response["errorMessage"];
				}
			}

			if(isset($response["ssl_result_message"]))
			{
				switch($response["ssl_result_message"])
				{
					case "DECLINE CVV2":
					{
						$messages[] = "CVV appears to be incorrect.";
						break;
					}
					case "AMT OVER SVC LMT":
					{
						$messages[] = "Credit limit exceeded.";
						break;
					}
					case "EXPIRED CARD":
					{
						$messages[] = "Credit card is expired.";
						break;
					}
					case "INVALID CARD":
					{
						$messages[] = "Credit card number is invalid.";
						break;
					}
					case "INCORRECT PIN":
					{
						$messages[] = "Invalid PIN.";
						break;
					}
					case "INVALID CAVV":
					{
						$messages[] = "Invalid Card Holder Authentication Verification Value.";
						break;
					}
					case "PLEASE RETRY":
					{
						$messages[] = "Please retry.";
						break;
					}
					default:
					{
						$messages[] = "Please double check the card information you entered or try again with another card.";
						break;
					}
				}
			}
		}

		/*
		 * This stuff is here, but not really needed or used at the moment.

		switch($response["ssl_avs_response"])
		{
			case "M":
			{
				$messages[] = "CVV2/CVC2 Match";
				break;
			}
			case "N":
			{
				$messages[] = "CVV2/CVC2 No match";
				break;
			}
			case "P":
			{
				$messages[] = "Not processed";
				break;
			}
			case "S":
			{
				$messages[] = "Issuer indicates that the CVV2/CVC2 data should be present on the card, but the merchant has indicated that the CVV2/CVC2 data is not resent on the card";
				break;
			}
			case "U":
			{
				$messages[] = "Issuer has not certified for CVV2/CVC2 or Issuer has not provided Visa with the CVV2/CVC2 encryption keys";
				break;
			}
		}

		switch($response["ssl_avs_response"])
		{
			case "A":
			{
				$messages[] = "Address matches - ZIP Code does not match";
				break;
			}
			case "B":
			{
				$messages[] = "Street address match, Postal code in wrong format (international issuer)";
				break;
			}
			case "C":
			{
				$messages[] = "Street address and postal code in wrong formats";
				break;
			}
			case "D":
			{
				$messages[] = "Street address and postal code match (international issuer)";
				break;
			}
			case "E":
			{
				$messages[] = "AVS Error";
				break;
			}
			case "F":
			{
				$messages[] = "Address does compare and five-digit ZIP code does compare (UK only)";
				break;
			}
			case "G":
			{
				$messages[] = "Service not supported by non-US issuer";
				break;
			}
			case "I":
			{
				$messages[] = "Address information not verified by international issuer.";
				break;
			}
			case "M":
			{
				$messages[] = "Street Address and Postal code match (international issuer)";
				break;
			}
			case "N":
			{
				$messages[] = "No Match on Address (Street) or ZIP";
				break;
			}
			case "O":
			{
				$messages[] = "No Response sent";
				break;
			}
			case "P":
			{
				$messages[] = "Postal codes match, Street address not verified due to incompatible formats";
				break;
			}
			case "R":
			{
				$messages[] = "Retry, System unavailable or Timed out";
				break;
			}
			case "S":
			{
				$messages[] = "Service not supported by issuer";
				break;
			}
			case "U":
			{
				$messages[] = "Address information is unavailable";
				break;
			}
			case "W":
			{
				$messages[] = "9-digit ZIP matches, Address (Street) does not match";
				break;
			}
			case "X":
			{
				$messages[] = "Exact AVS Match";
				break;
			}
			case "Y":
			{
				$messages[] = "Address (Street) and 5-digit ZIP match";
				break;
			}
			case "Z":
			{
				$messages[] = "5-digit ZIP matches, Address (Street) does not match";
				break;
			}
		}
		*/

		return $approved;
    }

    public function qualifies($gateway_data)
    {
    	return true;
    }
}
