<?php
class Shop_Cart extends MY_Model
{
    const DB_TABLE = 'shop_cart';
    const DB_TABLE_PK = 'cart_id';

    private $price_sql = "";

    public function __construct()
    {
        parent::__construct();

		// This SQL is intended to be joined to the products table (as `p`).
        // You need to replace {shopper_group_id} with the user's shopper group ID.
        // The purpose of this query is to automatically select the correct price for a product, given the user's shopper group.
        // ie: if shopper group specific prices are available they will override the default product price.
        $this->price_sql = " LEFT JOIN
                                (SELECT p.product_id,
                                 prices.price AS price_cad,
                                 prices.price * cur.exchange_rate AS price,
                                 cur.currency_code, prices.product_variant_id
                                FROM shop_products AS p
                                INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id='{shopper_group_id}'
                                INNER JOIN shop_currency AS cur ON cur.currency_code='" . (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD") . "')
                                AS `prices` ON c.product_id=prices.product_id AND c.product_variant_id=prices.product_variant_id ";
    }

    public function GetItemsBySessionID($session_id)
    {
		$query = $this->db->query("SELECT c.cart_id, c.product_id, c.product_variant_id, c.quantity, c.product_options,
		                          	p.product_name, v.product_variant_id, v.variant,
                                    IF(p.deposit_price > 0, p.deposit_price, prices.price) AS price, p.deposit_price,
                                    prices.currency_code, p.shipping_length, p.shipping_width, p.shipping_height,
                                    p.shipping_weight, p.shipping_tbd, p.shipping_na, p.datasource_id
                                    FROM shop_cart AS c
                                    INNER JOIN shop_products AS p ON c.product_id=p.product_id
                                    INNER JOIN shop_product_variant AS v ON c.product_variant_id=v.product_variant_id " .
                                    str_replace("{shopper_group_id}", Mainframe::user()->shopper_group_id, $this->price_sql) . "
                                    WHERE c.session_id=?",
                                    array($session_id));
        return $query->result();
    }

    public function EmptyBySessionID($session_id)
    {
		$query = $this->db->query("DELETE FROM shop_cart WHERE session_id=?", array($session_id));
    }

    public function AddItemByProductID($product_id, $quantity, $task="add")
    {
		$cart_items = $this->GetItemsBySessionID(session_id());

        switch($task)
        {
            case "add":
            {
                $added = false;
                $product_options = array();

                //add the product to the cart
                //check our existing cart to see if this product already exists
                foreach($cart_items as $item)
                {
                    //product ID and product options must match, otherwise we add a new item
                    if($item->product_id == $product_id && $item->product_options == serialize($product_options))
                    {
                        //if it does, update the quantity
                        $cart_item = new Shop_Cart();
                        $cart_item->load($item->cart_id);
                        $cart_item->quantity += $quantity;
                        $cart_item->save();

                        $added = true;
                        break;
                    }
                }
                if(!$added)
                {
                    $cart_item = new Shop_Cart();
                    $cart_item->session_id = session_id();
                    $cart_item->product_id = $product_id;
                    $cart_item->quantity = $quantity;
                    $cart_item->product_options = serialize($product_options);
                    $cart_item->save();
                }


                break;
            }
            case "update":
            {
                $cart_item = new Shop_Cart();
                $cart_item->load($cart_items->cart_id);

                if($quantity == 0 || $this->input->post("remove") == "1")
                {
                    $cart_item->delete();
                }
                else
                {
                    $cart_item->quantity = $quantity;
                    $cart_item->save();
                }

                break;
            }
        }
    }

    public function ContainsItem($item_id)
    {
		$cart_items = $this->GetItemsBySessionID(session_id());

        foreach($cart_items as $item)
        {
            if($item->product_id == $item_id)
            {
                return true;
            }
        }

        return false;
    }

}
