<?php
class Shop_Category extends MY_Model
{
	const DB_TABLE = 'shop_categories';
    const DB_TABLE_PK = 'category_id';

    public function __construct()
	{
		parent::__construct();

		$this->site_id 		= 1;
		$this->sort 		= 1;
		$this->published 	= 1;
	}

    private static $categories = null;	//cache the categories since we'll need them repeatedly

    function GetURL()
    {
    	if(!$this->category_id)
    	{
    		return "";
    	}

    	$this->load->model(array("shop/shop_category", "shop/shop_config", "page"));

    	$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);

    	if(is_null(self::$categories))
    	{
    		self::$categories = $this->shop_category->LoadForRouteBuilder(Mainframe::site()->site_id);
    	}

 		$shop_page = new Page();
 		$shop_page->load($shop_config["page_id"]);

 		$shop_part = "/" . $shop_page->url;
 		$category_parts = "";
 		$category_part = $this->url;

 		$cat_id = $this->parent_category_id;
 		$tries = 0;

		// foreach(self::$categories as $category)
		for($i=0; $i<count(self::$categories); $i++)
		{
			$category = self::$categories[$i];

			if($category->category_id == $cat_id)
			{
				$category_parts = $category->url . "/" . $category_parts;
				$cat_id = $category->parent_category_id;
				$i = 0;
			}

			//if we get to this point, the category was not found...we have a category who's parent was deleted and no longer has a route back to 0
			//return "";
		}

 		//because the first $category_parts iteration will be empty, we have an extra / at the end, so we don't need one before the current category part
 		$url = $shop_part . "/" . $category_parts . $category_part;

 		return $url;
    }

    function LoadWithImages($id, $published=true)
    {
    	$query = $this->db->query("SELECT c.*, c.not_authorized_page_id, IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename" . ($published ? ", category_path, category_path_string, r.url" : "") . "
								  FROM shop_categories AS c
								  LEFT JOIN shop_routes AS r ON c.category_id=r.category_id
		                          LEFT JOIN shop_images AS i ON c.category_image_id=i.image_id
		                          WHERE c.category_id=?" . ($published ? " AND c.published='1'" : "") . "
		                          ORDER BY c.sort, category_path_string, category_name",
		                          array($id));

    	if($query->num_rows() > 0)
	  	{
	  		foreach($query->result() as $row)
	  		{
	  			return $this->populate($row);
	  		}
	  	}
	  	else
	  	{
	  		return false;
	  	}
    }

    function LoadForRouteBuilder($site_id=1)
	{
		$query = $this->db->query("SELECT c.*
		                          FROM shop_categories AS c
		                          WHERE c.site_id=?",
		                          array($site_id));

		return $query->result();
	}

    function LoadBySiteID($id, $shopper_group_id=1, $published=true)
	{
		$query = $this->db->query("SELECT c.*, c.url AS seo_name, IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename" . ($published ? ", category_path, category_path_string, r.url AS url" : "") . "
		                          FROM shop_categories AS c
		                          LEFT JOIN shop_routes AS r ON c.category_id=r.category_id
		                          INNER JOIN shop_categories_shopper_groups AS sg ON c.category_id=sg.category_id AND sg.shopper_group_id=?
		                          LEFT JOIN shop_images AS i ON c.category_image_id=i.image_id
		                          WHERE " . ($published ? " c.published='1' AND " : "") . " c.site_id=? ORDER BY c.`sort`, category_path_string, category_name",
		                          array($shopper_group_id, $id));

		return $query->result();
	}

	function GetCategoriesForProductID($id)
	{
		$query = $this->db->query("SELECT c.* FROM shop_categories AS c INNER JOIN shop_categories_products AS cp ON c.category_id=cp.category_id AND cp.product_id=?
		                          UNION
		                          SELECT c.* FROM shop_categories AS c INNER JOIN shop_products AS p ON c.category_id=p.main_category_id AND p.product_id=?
		                          ", array($id, $id));
		return $query->result();
	}

    function LoadByProductID($id)
	{
		$query = $this->db->query("SELECT c.*, IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename, IF(cp.product_id IS NULL, 0, 1) AS checked, category_path, category_path_string, r.url
		                          FROM shop_categories AS c
		                          INNER JOIN shop_routes AS r ON c.category_id=r.category_id
		                          LEFT JOIN shop_images AS i ON c.category_image_id=i.image_id
		                          LEFT JOIN shop_categories_products AS cp ON c.category_id=cp.category_id AND cp.product_id=?
		                          WHERE c.published='1'
		                          ORDER BY c.`sort`, category_path_string",
		                          array($id));

		return $query->result();
	}

	function LoadByParentID($id, $shopper_group_id=1)
	{
		if($id > 0)
		{
			$bindings = array($shopper_group_id, $id);
		}
		else
		{
			$bindings = array($shopper_group_id);
		}

		$query = $this->db->query("SELECT c.*, IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename, category_path, category_path_string, r.url
		                          FROM shop_categories AS c
		                          INNER JOIN shop_routes AS r ON c.category_id=r.category_id
		                          INNER JOIN shop_categories_shopper_groups AS sg ON c.category_id=sg.category_id AND sg.shopper_group_id=?
		                          LEFT JOIN shop_images AS i ON c.category_image_id=i.image_id
		                          WHERE c.published='1' AND " . ($id > 0 ? "c.parent_category_id=?" : "c.parent_category_id IS NULL") . " ORDER BY `sort`, category_path_string",
		                          $bindings);

		return $query->result();
	}

	function LoadBySiteIDParentID($site_id, $parent_id, $shopper_group_id=1)
	{
		if($parent_id > 0)
		{
			$bindings = array($shopper_group_id, $site_id, $parent_id);
		}
		else
		{
			$bindings = array($shopper_group_id, $site_id);
		}

		$query = $this->db->query("SELECT c.*, IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename, category_path, category_path_string, r.url
		                          FROM shop_categories AS c
		                          INNER JOIN shop_routes AS r ON c.category_id=r.category_id
		                          INNER JOIN shop_categories_shopper_groups AS sg ON c.category_id=sg.category_id AND sg.shopper_group_id=?
		                          LEFT JOIN shop_images AS i ON c.category_image_id=i.image_id
		                          WHERE c.published='1' AND c.site_id=? AND " . ($parent_id > 0 ? "c.parent_category_id=?" : "c.parent_category_id IS NULL") . " ORDER BY `sort`, category_path_string",
		                          array($shopper_group_id, $site_id, $parent_id));

		return $query->result();
	}

	function LoadByDatasourceCategoryID($site_id, $category_id)
	{
		//in this case we DO NOT want to check if the category is published.  doing so would cause a new category to get inserted if the client disables a category.
		//In order to accommodate multiple datasources "sharing" a category, we use a regular expression.
		//The database field will either be a single code, or multiple codes separated by a pipe | which creates a perfect "or" regular expression.
		$query = $this->db->query("SELECT c.category_id
		                          FROM shop_categories AS c
		                          WHERE c.site_id=? AND ? REGEXP CONCAT('^(', datasource_category_id, ')$')
		                          ORDER BY `sort`, category_name",
		                          array($site_id, $category_id));

		if($query->num_rows() > 0)
	  	{
	  		foreach($query->result() as $row)
	  		{
	  			return $this->populate($row);
	  		}
	  	}
	  	else
	  	{
	  		return false;
	  	}
	}

	function GetParentIDs()
    {
    	if(!$this->category_id)
    	{
    		return "";
    	}
		Mainframe::init();
    	$this->load->model(array("shop/shop_category", "shop/shop_config"));

    	if(is_null(self::$categories))
    	{
    		self::$categories = $this->shop_category->LoadForRouteBuilder(Mainframe::site()->site_id);
    	}

 		$category_parts = $this->category_id;
 		$cat_id = $this->parent_category_id;
 		$tries = 0;

 		while($cat_id > 0)
 		{
 			for($i=0; $i<count(self::$categories); $i++)
			{
				$category = self::$categories[$i];

 				if($category->category_id == $cat_id)
 				{
 					$category_parts = $category->category_id . "," . $category_parts;
 					$cat_id = $category->parent_category_id;
 					$i = 0;
 				}

 				//if we get to this point, the category was not found...we have a category who's parent was deleted and no longer has a route back to 0
 				//return "";
 			}

 			$tries++;

 			if($tries >= 30)
 			{
 				return "";
 			}
 		}

 		return $category_parts;
    }

	function GetPath($string=false)
    {
    	if(!$this->category_id)
    	{
    		return "";
    	}

    	$this->load->model(array("shop/shop_category", "shop/shop_config"));

    	if(is_null(self::$categories))
    	{
    		self::$categories = $this->shop_category->LoadForRouteBuilder(Mainframe::site()->site_id);
    	}

 		$category_parts = ($string ? $this->category_name : $this->category_id);
 		$cat_id = $this->parent_category_id;
 		$tries = 0;

 		while($cat_id > 0)
 		{
 			for($i=0; $i<count(self::$categories); $i++)
			{
				$category = self::$categories[$i];

				if($category->category_id == $cat_id)
 				{
 					$category_parts = ($string ? $category->category_name . " > " : $category->category_id . "|") . $category_parts;
 					$cat_id = $category->parent_category_id;
 					$i = 0;
 				}

 				//if we get to this point, the category was not found...we have a category who's parent was deleted and no longer has a route back to 0
 				//return "";
 			}
 			$tries++;

 			if($tries >= 30)
 			{
 				return "";
 			}
 		}

 		return $category_parts;
    }

    function GetBreadcrumbs()
    {
    	if(!$this->category_id)
    	{
    		return "";
    	}

    	$this->load->model(array("shop/shop_category", "shop/shop_config"));

    	if(is_null(self::$categories))
    	{
    		self::$categories = $this->shop_category->LoadForRouteBuilder(Mainframe::site()->site_id);
    	}

 		$shop_part = "<li><a href='/'><i class='fas fa-home'></i> Home</a></li>";
 		$category_parts = "<li><a><i class='fas fa-info-circle'></i> " . $this->category_name . "</a></li>";
 		$cat_id = $this->parent_category_id;
 		$tries = 0;

 		while($cat_id > 0)
 		{
 			for($i=0; $i<count(self::$categories); $i++)
			{
				$category = self::$categories[$i];

 				if($category->category_id == $cat_id)
 				{
 					$c = new Shop_Category();
 					$c->LoadWithImages($cat_id);

 					$category_parts = "<li><a href='" . $c->url . "'><i class='fas fa-arrow-circle-left'></i> " . $category->category_name . "</a></li>" . $category_parts;
 					$cat_id = $category->parent_category_id;
 					$i = 0;
 				}

 				//if we get to this point, the category was not found...we have a category who's parent was deleted and no longer has a route back to 0
 				//return "";
 			}
 			$tries++;

 			if($tries >= 30)
 			{
 				return "";
 			}
 		}

 		return "<ul class='shop-breadcrumbs'>" . $shop_part . $category_parts . "</ul>";
    }

    public function LoadAll()
    {
    	$query = $this->db->query("SELECT * FROM shop_categories");

    	return $query->result();
    }

    public function LoadAllBare()
    {
    	$query = $this->db->query("SELECT category_id, site_id, published FROM shop_categories WHERE published='1'");

    	return $query->result();
    }

	public function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}
}
