<?php
class Shop_Category_Product extends MY_Model
{
	const DB_TABLE = 'shop_categories_products';
    const DB_TABLE_PK = 'shop_category_product_id';

    public function add_link($category_id, $product_id)
    {
    	$sql = "SELECT shop_category_product_id FROM shop_categories_products WHERE category_id=? AND product_id=?";
    	$result = $this->db->query($sql, array($category_id, $product_id));

    	if($result->num_rows() > 0)
    	{
    		//link already exists
    		return;
    	}
    	else
    	{
    		$sql = "INSERT INTO shop_categories_products SET category_id=?, product_id=?";
    		$this->db->query($sql, array($category_id, $product_id));
    	}
    }

    public function delete_link($category_id, $product_id)
    {
    	$sql = "DELETE FROM shop_categories_products WHERE category_id=? AND product_id=?";
    	$this->db->query($sql, array($category_id, $product_id));
    }
}
