<?php
class Shop_Category_Shopper_Group extends MY_Model
{
	const DB_TABLE = 'shop_categories_shopper_groups';
    const DB_TABLE_PK = 'shop_category_shopper_group_id';

    public function LoadBySiteIDWithLinks($site_id, $category_id)
    {
    	$query = $this->db->query("SELECT DISTINCT sg.*, IF(c.category_id IS NULL, 0, 1) AS `active`
    	                          FROM shop_shopper_groups AS sg
    	                          LEFT JOIN shop_categories_shopper_groups AS csg ON sg.shopper_group_id=csg.shopper_group_id AND csg.category_id=?
    	                          LEFT JOIN shop_categories AS c ON c.category_id=csg.category_id AND c.category_id=?
    	                          WHERE sg.site_id=?",
    	                          array($category_id, $category_id, $site_id));

    	return $query->result();
    }

    public function add_link($category_id, $shopper_group_id)
    {
    	$sql = "SELECT shop_category_shopper_group_id FROM shop_categories_shopper_groups WHERE category_id=? AND shopper_group_id=?";
    	$result = $this->db->query($sql, array($category_id, $shopper_group_id));

    	if($result->num_rows() > 0)
    	{
    		//link already exists
    		return;
    	}
    	else
    	{
    		$sql = "INSERT INTO shop_categories_shopper_groups SET category_id=?, shopper_group_id=?";
    		$this->db->query($sql, array($category_id, $shopper_group_id));
    	}
    }

    public function delete_link($category_id, $shopper_group_id)
    {
    	$sql = "DELETE FROM shop_categories_shopper_groups WHERE category_id=? AND shopper_group_id=?";
    	$this->db->query($sql, array($category_id, $shopper_group_id));
    }

    public function validate_user($category, $user)
    {
    	$sql = "SELECT * FROM shop_categories_shopper_groups WHERE category_id=? AND shopper_group_id=?";
    	$result = $this->db->query($sql, array($category->category_id, $user->shopper_group_id));

    	return ($result->num_rows() > 0);
    }
}
