<?php
class Shop_Config extends MY_Model
{
	const DB_TABLE = 'shop_config';
    const DB_TABLE_PK = 'config_id';

	public function __construct()
	{
		parent::__construct();

		$this->site_id = 1;
	}

    function LoadBySiteID($id)
	{
		$query = $this->db->query("SELECT * FROM shop_config WHERE site_id=? ORDER BY `sort`, `config_label`", array($id));

		return $query->result();
	}

	function LoadAssocBySiteID($id)
	{
		$query = $this->db->query("SELECT * FROM shop_config WHERE site_id=? ORDER BY `sort`, `config_label`", array($id));
		$config = array();

		foreach($query->result() as $row)
		{
			$config[$row->config_key] = $row->config_value;
		}

		return $config;
	}

	function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}
}
