<?php
class Shop_Image extends MY_Model
{
	const DB_TABLE = 'shop_images';
    const DB_TABLE_PK = 'image_id';

    public function __construct()
	{
		parent::__construct();

		$this->site_id = 1;
	}

    function LoadBySiteID($id)
	{
		$query = $this->db->query("SELECT * FROM shop_images AS i WHERE site_id=? ORDER BY sort, image_id", array($id));

		return $query->result();
	}

    function LoadByProductID($id)
	{
		$query = $this->db->query("SELECT * FROM shop_images AS i WHERE product_id=? ORDER BY sort, image_id", array($id));

		return $query->result();
	}

    function LoadByFilename($filename)
	{
		$query = $this->db->query("SELECT * FROM shop_images WHERE filename=?", array($filename));

		if($query->num_rows() > 0)
	  	{
	  		$image_id = false;

	  		foreach($query->result() as $row)
	  		{
	  			//return the first item
	  			$image_id = $row->image_id;
		  		$query->free_result();

		  		return $this->Load($image_id);
	  		}
	  	}

  		return false;
	}
}
