<?php
class Shop_Price extends MY_Model
{
	const DB_TABLE = 'shop_prices';
    const DB_TABLE_PK = 'price_id';

	public function __construct()
	{
		parent::__construct();

		$this->price = 0;
	}

    function LoadProductPrices($product_id)
	{
		$query = $this->db->query("SELECT p.*, IF(p.price IS NULL, 0, p.price) AS price, g.shopper_group_id, g.group_name,
		                          IF(v.variant, v.variant, 'Default Price') AS variant
		                          FROM shop_prices AS p
		                          RIGHT JOIN shop_shopper_groups AS g ON p.shopper_group_id=g.shopper_group_id AND p.product_id=?
		                          LEFT JOIN shop_product_variant AS v ON p.product_variant_id=v.product_variant_id AND p.product_id=?
		                          GROUP BY g.shopper_group_id, v.product_variant_id, p.price_id
		                          ORDER BY v.sort, g.group_name, v.variant", array($product_id, $product_id));

		return $query->result();
	}

    function LoadByProductID($product_id, $shopper_group_id=1)
	{
		$query = $this->db->query("SELECT p.*, v.variant
		                          FROM shop_prices AS p
		                          LEFT JOIN shop_product_variant AS v USING(product_id)
		                          WHERE p.product_id=? AND p.shopper_group_id=? AND price IS NOT NULL
		                          GROUP BY p.price_id
		                          ORDER BY v.sort, p.shopper_group_id, v.variant", array($product_id, $shopper_group_id));

		return $query->result();
	}

	public function add_price($product_id, $shopper_group_id, $price)
    {
	    $result = $this->db->query("SELECT price_id FROM shop_prices WHERE shopper_group_id=? AND product_id=?", array($shopper_group_id, $product_id));

	    if($result->num_rows() > 0)
	    {
	    	$row = $result->result();
	    	$row = $row[0];
		    $data = array("shopper_group_id" => $shopper_group_id, "product_id" => $product_id, "price" => $price);

		    $this->db->where("price_id", $row->price_id);
		    $result = $this->db->update("shop_prices", $data);

		    return ($this->db->affected_rows() > 0);
	    }
	    else
	    {
		    //no existing link, add one
		    $data = array("shopper_group_id" => $shopper_group_id, "product_id" => $product_id, "price" => $price);

		    $result = $this->db->insert("shop_prices", $data);

		    return ($this->db->affected_rows() > 0);
	    }

	    return false;
    }

    public function delete_price($product_id, $shopper_group_id)
    {
    	$this->db->where("shopper_group_id", $shopper_group_id);
    	$this->db->where("product_id", $product_id);
    	$this->db->delete("shop_prices");

		return ($this->db->affected_rows() > 0);
    }

    public function delete_all($product_id)
    {
    	$this->db->query("DELETE FROM shop_prices WHERE product_id=?",
    	                 array($product_id));
    }

    public function delete_others($product_id, $price_ids)
    {
    	$this->db->query("DELETE FROM shop_prices WHERE product_id=? AND price_id NOT IN ?",
    	                 array($product_id, $price_ids));
    }
}
