<?php
class Shop_Product extends MY_Model
{
	const DB_TABLE = 'shop_products';
    const DB_TABLE_PK = 'product_id';

   	private static $categories = null;	//cache the categories since we'll need them repeatedly
    private $query_cache = array();		//query cache for multiple calls for the same query

    // private $price_sql = "";

    public function __construct()
    {
    	parent::__construct();

    	$this->site_id 			= 1;
		$this->cost 			= 0;
		$this->price 			= 0;
		$this->price_lock 		= 0;
		$this->deposit_price 	= 0;
		$this->call_for_price 	= 0;
		$this->by_order_only 	= 0;
		$this->out_of_stock 	= 0;
		$this->shipping_length 	= 0;
		$this->shipping_width 	= 0;
		$this->shipping_height 	= 0;
		$this->shipping_weight 	= 0;
		$this->shipping_tbd 	= 0;
		$this->shipping_na 		= 0;
		$this->sort_priorty 	= 1;
		$this->published 		= 1;

    	// This SQL is intended to be joined to the products table (as `p`).
    	// You need to replace {shopper_group_id} with the user's shopper group ID.
    	// The purpose of this query is to automatically select the correct price for a product, given the user's shopper group.
    	// ie: if shopper group specific prices are available they will override the default product price.
    	// $this->price_sql = " LEFT JOIN
    	// 						(SELECT p.product_id,
    	// 						 IF(prices.price IS NOT NULL, prices.price, p.price) AS price_cad,
    	// 						 IF(prices.price IS NOT NULL, prices.price, p.price)*cur.exchange_rate AS price,
    	// 						 cur.currency_code
     //                            FROM shop_products AS p
     //                            LEFT JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id='{shopper_group_id}'
     //                            INNER JOIN shop_currency AS cur ON cur.currency_code='" . (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD") . "')
					// 			AS `prices` ON p.product_id=prices.product_id ";
    }

    function GetURL()
    {
    	if(!$this->product_id)
    	{
    		return "";
    	}

    	set_time_limit(30);

    	$this->load->model(array("shop/shop_category", "shop/shop_config"));

    	$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);

    	if(is_null(self::$categories))
    	{
    		self::$categories = $this->shop_category->LoadForRouteBuilder(Mainframe::site()->site_id);
    	}

 		$shop_page = new Page();
 		$shop_page->load($shop_config["page_id"]);

 		$shop_part = "/" . $shop_page->url;
 		$category_parts = "";
 		$product_part = $this->url;

 		$cat_id = $this->main_category_id;
 		$tries = 0;

 		for($i=0; $i<count(self::$categories); $i++)
		{
			$category = self::$categories[$i];

			if($category->category_id == $cat_id)
			{
				$category_parts = $category->url . "/" . $category_parts;
				$cat_id = $category->parent_category_id;
				$i = 0;
			}

			//if we get to this point, the category was not found...we have a category who's parent was deleted and no longer has a route back to 0
			//return "";
		}

 		//because the first $category_parts iteration will be empty, we have an extra / at the end, so we don't need one before the product part
 		$url = $shop_part . "/" . $category_parts . $product_part;

 		return $url;
    }

    function GetBreadcrumbs()
    {
    	if(!$this->product_id)
    	{
    		return "";
    	}

    	set_time_limit(30);

    	$this->load->model(array("shop/shop_category", "shop/shop_config"));

    	$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);

    	if(is_null(self::$categories))
    	{
    		self::$categories = $this->shop_category->LoadForRouteBuilder(Mainframe::site()->site_id);
    	}

 		$shop_page = new Page();
 		$shop_page->load($shop_config["page_id"]);

 		$shop_part = "<li><a href='/'><i class='fas fa-home'></i> Home</a></li>";
 		$category_parts = "";
 		$product_part = "<li><a><i class='fas fa-info-circle'></i> " . $this->product_name . "</a></li>";

 		$cat_id = $this->main_category_id;
 		$tries = 0;

 		while($cat_id > 0)
 		{
 			for($i=0; $i<count(self::$categories); $i++)
			{
				$category = self::$categories[$i];

				if($category->category_id == $cat_id)
 				{
 					$c = new Shop_Category();
 					$c->LoadWithImages($cat_id);

 					$category_parts = "<li><a href='" . $c->url . "'><i class='fas fa-arrow-circle-left'></i> " . $category->category_name . "</a></li>" . $category_parts;
 					$cat_id = $category->parent_category_id;
 					$i = 0;
 				}

 				//if we get to this point, the category was not found...we have a category who's parent was deleted and no longer has a route back to 0
 				//return "";
 			}
 			$tries++;

 			if($tries >= 30)
 			{
 				return "";
 			}
 		}

 		//because the first $category_parts iteration will be empty, we have an extra / at the end, so we don't need one before the product part
 		$url = "<ul class='shop-breadcrumbs'>" . $shop_part . $category_parts . $product_part . "</ul>";

 		return $url;
    }

    public function GetCategoryPath($string=false)
    {
    	$this->load->model("shop/shop_category");

    	$category = new Shop_Category();
		$category->Load($this->main_category_id);
		$category_path = $category->GetPath($string);

		return $category_path;
    }

    function LoadWithImages($id, $published=true)
    {
    	$query = $this->db->query("SELECT p.*,
    								prices.price AS price_cad,
    								prices.price * cur.exchange_rate AS price, cur.currency_code,
    								IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename" . ($published ? ", category_path, category_path_string, r.url" : "") . "
								  FROM shop_products AS p
								  INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id=? AND prices.price IS NOT NULL
                                  INNER JOIN shop_currency AS cur ON cur.currency_code=?" .
								  ($published ? "INNER JOIN shop_routes AS r ON p.product_id=r.product_id " : "") . "
		                          LEFT JOIN shop_images AS i ON p.product_image_id=i.image_id
		                          WHERE p.product_id=?" . ($published ? " AND p.published='1'" : ""),
		                          array(Mainframe::user()->shopper_group_id,
		                                (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD"),
		                                $id));

    	if(is_object($query))
        {
	    	$this->loaded = true;
			return $this->populate($query->row());
	    }
	    return false;
    }

    function LoadForAdmin($id)
    {
    	$query = $this->db->query("SELECT p.*, IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename
								  FROM shop_products AS p
								  LEFT JOIN shop_images AS i ON p.product_image_id=i.image_id
		                          WHERE p.product_id=?",
		                          array($id));

    	if(is_object($query))
        {
	    	$this->loaded = true;
			return $this->populate($query->row());
	    }
	    return false;
    }

    function LoadBySiteID($id)
	{
		$query = $this->db->query("SELECT p.*,
		                          	prices.price AS price_cad,
    								prices.price * cur.exchange_rate AS price, cur.currency_code,
    								category_path, category_path_string, r.url
    	                          FROM shop_products AS p
    	                          INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id=? AND prices.price IS NOT NULL
                                  INNER JOIN shop_currency AS cur ON cur.currency_code=?
								  INNER JOIN shop_routes AS r ON p.product_id=r.product_id
		                          WHERE p.site_id=?
    	                          ORDER BY IF(corner_tag IS NULL OR corner_tag = 0, 1000, corner_tag), p.sort_priority ASC, `product_name`",
    	                          array(Mainframe::user()->shopper_group_id,
    	                                (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD"),
    	                                $id));

		return $query->result();
	}

	function LoadByDatasourceProductID($site_id, $product_id)
	{
		//in this case we DO NOT want to check if the product is published.  doing so would cause a new product to get inserted if the client disables a product.
		$query = $this->db->query("SELECT product_id FROM shop_products AS p WHERE p.site_id=? AND datasource_product_id=? ORDER BY `product_name`",
		                          array($site_id, $product_id));

		if($query->num_rows() > 0)
	  	{
	  		$product_id = false;

	  		foreach($query->result() as $row)
	  		{
	  			//return the first item
	  			$product_id = $row->product_id;
		  		break;
	  		}

	  		$query->free_result();

	  		return $this->Load($product_id);
	  	}
	  	else
	  	{
	  		$query->free_result();
		  	return false;
	  	}
	}

	function LoadByDatasourceID($id, $offset=0, $limit=0)
	{
		$query = $this->db->query("SELECT *
								  FROM shop_products AS p
								  INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id=? AND prices.price IS NOT NULL
                                  INNER JOIN shop_currency AS cur ON cur.currency_code=?
								  WHERE p.datasource_id=? AND last_datasource_update <= ?
		                          ORDER BY sku, `product_name`" .
		                          ($limit > 0 ? " LIMIT $offset,$limit" : ""),
		                          array(Mainframe::user()->shopper_group_id,
		                                (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD"),
		                                $id,
		                                date("Y-m-d H:i:s", strtotime("-2 days"))));

		return $query->result();
	}

	function LoadFeedByCategoryID($id, $shopper_group_id=1)
	{
		$query = $this->db->query("SELECT p.*,
		                          	prices.price AS price_cad,
    								prices.price * cur.exchange_rate AS price, cur.currency_code,
    								IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename, mc.category_name AS main_category_name, mc.url AS main_category_url, category_path, category_path_string, r.url
								  FROM shop_products AS p
								  INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id=? AND prices.price IS NOT NULL
                                  INNER JOIN shop_currency AS cur ON cur.currency_code=?
								  INNER JOIN shop_routes AS r ON p.product_id=r.product_id
		                          INNER JOIN shop_categories AS mc ON p.main_category_id=mc.category_id
		                          INNER JOIN shop_categories_products AS pc ON p.product_id=pc.product_id
		                          INNER JOIN shop_categories AS c ON pc.category_id=c.category_id
		                          INNER JOIN shop_categories_shopper_groups AS sg ON c.category_id=sg.category_id AND sg.shopper_group_id=?
		                          LEFT JOIN shop_images AS i ON p.product_image_id=i.image_id
		                          WHERE p.published='1' AND c.published='1' AND
		                          (category_path LIKE '%|$id|%' OR category_path LIKE '%|$id' OR category_path LIKE '$id|%')
		                          GROUP BY p.product_id
		                          ORDER BY mc.sort, mc.category_name, IF(corner_tag IS NULL OR corner_tag = 0, 1000, corner_tag), p.sort_priority ASC, `product_name`",
		                          array($shopper_group_id, (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD"), $shopper_group_id));
		return $query->result();
	}

	function LoadByCategoryID($id, $shopper_group_id=1)
	{
		$query = $this->db->query("SELECT p.*,
		                          	prices.price AS price_cad,
    								prices.price * cur.exchange_rate AS price, cur.currency_code,
    								IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename, mc.category_name AS main_category_name, mc.url AS main_category_url, category_path, category_path_string, r.url
								  FROM shop_products AS p
								  INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id=? AND prices.price IS NOT NULL
                                  INNER JOIN shop_currency AS cur ON cur.currency_code=?
								  INNER JOIN shop_routes AS r ON p.product_id=r.product_id
		                          INNER JOIN shop_categories AS mc ON p.main_category_id=mc.category_id
		                          INNER JOIN shop_categories_products AS pc ON p.product_id=pc.product_id
		                          INNER JOIN shop_categories AS c ON pc.category_id=c.category_id
		                          INNER JOIN shop_categories_shopper_groups AS sg ON c.category_id=sg.category_id AND sg.shopper_group_id=?
		                          LEFT JOIN shop_images AS i ON p.product_image_id=i.image_id
		                          WHERE p.published='1' AND c.published='1' AND c.category_id=?
		                          GROUP BY p.product_id
		                          ORDER BY IF(corner_tag IS NULL OR corner_tag = 0, 1000, corner_tag), p.sort_priority ASC, `product_name`",
		                          array($shopper_group_id, (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD"),
		                                $shopper_group_id, $id));

		return $query->result();
	}

	function LoadProductsToUpdate($datasource_id, $limit)
	{
		$query = $this->db->query("SELECT *
								  FROM shop_products
		                          WHERE published='1' AND datasource_id=?
		                          ORDER BY `last_datasource_update` ASC
		                          LIMIT $limit",
		                          array($datasource_id));

		return $query->result();
	}

	function LoadByQuery($include_filters=true, $shopper_group_id=1)
	{
		if($this->input->get_post("q") != "")
		{
			$q = addslashes(str_replace(" ", "%", urldecode($this->input->get_post("q"))));
		}
		else
		{
			$q = addslashes(str_replace(" ", "%", urldecode($this->input->get_post("shop_q"))));
		}
		$price_range 	= $this->input->get_post("shop_filter_price");
		$category_id 	= $this->input->get_post("shop_filter_category_id");
		$value_joins 	= "";
		$value_where 	= "";
		$where 			= "";
		$having 		= "";

		$year 			= $this->input->get_post("shop_part_year");
		$make 			= $this->input->get_post("shop_part_make");
		$model 			= $this->input->get_post("shop_part_model");
		$style 			= $this->input->get_post("shop_part_style");
		$part_filters 	= ($year > 0);

		if($category_id && $include_filters)
		{
			// Only one category ID
			if(strpos($category_id, "|") === false)
			{
				$where .= ($where ? " OR " : "") . " $category_id REGEXP CONCAT('^(', r.category_path, ')$') ";
			}
			// More than 1 category ID, piped - does this ever happen?
			else
			{
				$category_ids = explode("|", $category_id);

				foreach($category_ids as $id)
				{
					$where 	.= ($where ? " OR " : "") . ($id > 0 ? " $id REGEXP CONCAT('^(', r.category_path, ')$') " : "");
				}
			}
		}

		if($price_range != "0" && $price_range != "")
		{
			$prices = explode("|", $price_range);
			$min_price = $prices[0];
			$max_price = $prices[1];
		}

		$layout_specific_values = $this->shop_product->LoadLayoutSpecificDataValues();
		$ids = array();

		//this will remove duplicate IDs which do nothing more than waste MySQL resources
		foreach($layout_specific_values as $value)
		{
			$ids[$value->layout_specific_data_id] = $value;
		}

		$count = 1;
		foreach($ids as $value)
		{
			// If a product attribute has been chosen to search for, we'll include a join to that table looking for a matching value.
			$data_value = $this->input->get_post("shop_filter_value_" . $value->layout_specific_data_id);

			if($data_value != "0" && $data_value != "" && $include_filters)
			{
				$value_joins .= " INNER JOIN shop_layout_specific_data_values AS v$count ON p.product_id=v$count.product_id AND v$count.layout_specific_data_id='" . $value->layout_specific_data_id . "' AND (md5(v$count.data_value)='$data_value'" . ($q != "" ? " OR v$count.data_value LIKE '%$q%'" : "") . ")";
				// $value_where .= ($value_where ? " OR " : "") . "(md5(v$count.data_value)='$data_value'" . ($q != "" ? " OR v$count.data_value LIKE '%$q%'" : "") . ") ";// " OR CONCAT(' ', v$count.data_value, ' ') LIKE '%$q%'";
			}
			$count++;
		}

		$sql = "SELECT p.*, prices.price AS price_cad,
							prices.price * cur.exchange_rate AS price, cur.currency_code,
							IF(i.filename IS NULL OR i.filename='', 'noimage.png', i.filename) AS image_filename,
    						mc.category_name AS main_category_name, mc.url AS main_category_url, category_path, category_path_string, r.url
						FROM shop_products AS p
						INNER JOIN shop_prices AS prices ON prices.product_id=p.product_id AND prices.shopper_group_id='$shopper_group_id' AND prices.price IS NOT NULL
                        INNER JOIN shop_currency AS cur ON cur.currency_code='" . (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD") . "'
						INNER JOIN shop_routes AS r ON p.product_id=r.product_id
						INNER JOIN shop_categories AS mc ON mc.category_id=p.main_category_id AND mc.published='1'
						$value_joins
						LEFT JOIN shop_images AS i ON p.product_image_id=i.image_id ";


		// We've got some part filters (year/make/model/etc)
		if($part_filters)
		{
			$sql .= "INNER JOIN shop_vehicles_products AS vp ON p.product_id=vp.product_id
					 INNER JOIN shop_vehicles AS v ON vp.vehicle_id=v.vehicle_id ";
		}

		$sql .= "WHERE p.published='1' " . ($where != "" ? " AND ($where) " : "");

		// We've got some part filters (year/make/model/etc)
		if($part_filters)
		{
			$sql .= ($year > 0 		? " AND v.`year`='$year' " 		: "")
                  . ($make != "" 	? " AND v.`make`='$make' " 		: "")
                  . ($model != "" 	? " AND v.`model`='$model' " 	: "");
        }

 		if($q != "")
		{
			$sql .= "
			AND
			(
				p.product_name LIKE '%$q%' OR
			 	r.category_path_string LIKE '%$q%' OR
				p.product_short_description LIKE '%$q%' OR
				p.product_description LIKE '%$q%' OR
				p.sku LIKE '%$q%' OR
			 	p.datasource_product_id LIKE '%$q%'
			) ";
		}

		if($include_filters)
		{
			if($value_where != "")
			{
				$sql .= "
				AND
				(
					$value_where
				)";
			}

			// Use HAVING for price checks because we overrode "price" previously with a calculated price.
			if($price_range != "0" && $price_range != "")
			{
				$having .= ($having ? " AND " : " HAVING ") . "(price >= $min_price AND price <= $max_price) ";
			}
		}
		$sql .= "GROUP BY p.product_id
				$having
				ORDER BY IF(corner_tag IS NULL OR corner_tag = 0, 1000, corner_tag), p.sort_priority ASC, `product_name`";

		$query = $this->db->query($sql);

		return $query->result();
	}

	function LoadLayoutSpecificDataValues($product_ids=null, $filters_only=false)
	{
		if(is_array($product_ids))
		{
			$product_ids = implode(",", $product_ids);
		}

		$sql = "SELECT d.layout_specific_data_id, v.layout_specific_data_value_id, d.data_name, d.data_group, v.data_value, d.datatype, d.search_filter
				FROM shop_layout_specific_data AS d
				INNER JOIN shop_layout_specific_data_values AS v ON d.layout_specific_data_id=v.layout_specific_data_id
				WHERE v.data_value IS NOT NULL AND v.data_value <> '' " . ($filters_only ? " AND search_filter='1' " : "");

		if($product_ids)
		{
			$sql .= " AND v.product_id IN ($product_ids)";
		}

		$sql .= " GROUP BY d.layout_specific_data_id, v.data_value
				ORDER BY d.data_name
				";

		$query = $this->db->query($sql);

		return $query->result();
	}

	function LoadAllPrices($id)
	{
		$this->load->dbutil();
		//$mysqli = $this->load->database("mysqli", true);

		//generate a cross tab query and save it in @sql
		//because we need to use a Code Igniter result object rather than a MySQLi result object, we're just going to return the generated SQL so we can run it with CI's native database object
		$result = mysqli_multi_query($this->db->conn_id, "SET @sql = NULL;
			SET SESSION group_concat_max_len = 1000000;
			SELECT
			  GROUP_CONCAT(DISTINCT
			    CONCAT(IF(prices.price IS NULL, 0, prices.price), ' AS price_', LOWER(prices.currency_code))
			  ) INTO @sql
			FROM shop_products AS p
			LEFT JOIN
				(SELECT p.product_id,
				 prices.price AS price_cad,
				 prices.price * cur.exchange_rate AS price,
				 cur.currency_code
                FROM shop_products AS p
                LEFT JOIN shop_prices AS prices ON prices.product_id=p.product_id
                LEFT JOIN shop_shopper_groups AS g ON prices.shopper_group_id=g.shopper_group_id
                INNER JOIN shop_currency AS cur
                WHERE p.published='1' AND p.product_id='" . $id . "')
				AS `prices` ON p.product_id=prices.product_id
			WHERE p.published='1' AND p.product_id='" . $id . "';

			SET @sql = concat('SELECT p.product_id, ', @sql, '
			FROM shop_products AS p
			WHERE p.published=\'1\' AND p.product_id=\'" . $id . "\'');

			SELECT @sql AS 'myquery';

			-- PREPARE stmt FROM @sql;
			-- EXECUTE stmt;
			-- DEALLOCATE PREPARE stmt;");

		$count = 0;
		$saved_row = null;	//we need to save the row for after the multi-query stuff is done (table is locked)

		while($this->db->conn_id->more_results())
		{
			$this->db->conn_id->next_result();
			// $count++;

	        /* store first result set */
	        if($result = $this->db->conn_id->store_result())
	        {
	        	// if($count == 5)	//each query above gets stored in an array element, grab the one we care about
	        	// {
	        		$saved_row = $result->fetch_row();	//save this row for after the looping
	        	// }
	        	$result->free();
	        }
	    }

		//now we can run the generated SQL using CI's database object so we can use the CSV helper function to spit it out
		$query = $this->db->query($saved_row[0]);

		$result = $query->result();
		$result = $result[0];	//fetch one and only record

		return $result;
	}

    public function LoadAll()
    {
    	$query = $this->db->query("SELECT * FROM shop_products");

    	return $query->result();
    }

    public function LoadAllBare()
    {
    	$query = $this->db->query("SELECT product_id, site_id, published FROM shop_products WHERE published='1'");

    	return $query->result();
    }

	function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}

	function publish_products($product_ids)
	{
		$sql = "UPDATE shop_products SET published='1' WHERE product_id IN ($product_ids)";
		$query = $this->db->query($sql);

		return ($this->db->affected_rows() > 0);
	}

	function unpublish_products($product_ids)
	{
		$sql = "UPDATE shop_products SET published='0' WHERE product_id IN ($product_ids)";
		$query = $this->db->query($sql);

		return ($this->db->affected_rows() > 0);
	}

	function update_field($product_ids, $field, $value)
	{
		$sql = "UPDATE shop_products SET `$field`=? WHERE product_id IN ($product_ids)";
		$query = $this->db->query($sql, array($value));

		return ($this->db->affected_rows() > 0);
	}
}
