<?php
class Shop_Product_Layout extends MY_Model
{
	const DB_TABLE = 'shop_product_layout';
    const DB_TABLE_PK = 'product_layout_id';

    public function get_layout_options()
    {
    	$sql = "SELECT * FROM shop_layout_specific_data WHERE layout_id=? ORDER BY data_name";
    	$result = $this->db->query($sql, array($this->product_layout_id));

    	return $result->result();
    }

    public function get_layout_options_for_product($product_id)
    {
        $sql = "SELECT d.*, IF(v.data_value IS NULL, '', v.data_value) AS data_value, IF(d.datatype='file' OR d.datatype='url', '1', '0') AS files_last
                FROM shop_layout_specific_data AS d
                LEFT JOIN shop_layout_specific_data_values AS v ON d.layout_specific_data_id=v.layout_specific_data_id AND v.product_id=?
                WHERE d.layout_id=?
                ORDER BY files_last, d.sort, d.data_name";

        $result = $this->db->query($sql, array($product_id, $this->product_layout_id));

        return $result->result();
    }

    public function get_layout_options_for_product_display($product_id)
    {
        $sql = "SELECT d.*, IF(v.data_value IS NULL, '', v.data_value) AS data_value, IF(d.datatype='file' OR d.datatype='url', '1', '0') AS files_last
                FROM shop_layout_specific_data AS d
                LEFT JOIN shop_layout_specific_data_values AS v ON d.layout_specific_data_id=v.layout_specific_data_id AND v.product_id=?
                WHERE data_value IS NOT NULL AND trim(data_value != '')
                ORDER BY files_last, d.sort, d.data_name";

        $result = $this->db->query($sql, array($product_id));

        return $result->result();
    }

    public function save_product_option($product_id, $key, $value)
    {
        // $sql = "UPDATE shop_layout_specific_data AS d
        //         LEFT JOIN shop_layout_specific_data_values AS v ON d.layout_specific_data_id=v.layout_specific_data_id AND v.product_id='$product_id'
        //         SET v.data_value='" . addslashes($value) . "' WHERE v.product_id='$product_id' AND d.`key`='$key'";
        $sql = "SELECT layout_specific_data_value_id FROM shop_layout_specific_data_values WHERE product_id=? AND layout_specific_data_id=(SELECT layout_specific_data_id FROM shop_layout_specific_data WHERE `key`=?)";
        $result = $this->db->query($sql, array($product_id, $key));

        if($result->num_rows() > 0)
        {
            $sql = "UPDATE shop_layout_specific_data_values
                SET data_value=?
                WHERE product_id=? AND layout_specific_data_id=(SELECT layout_specific_data_id FROM shop_layout_specific_data WHERE `key`=?)";
            $result = $this->db->query($sql, array($value, $product_id, $key));
        }
        else
        {
            $sql = "INSERT INTO shop_layout_specific_data_values SET data_value=?, product_id=?, layout_specific_data_id=(SELECT layout_specific_data_id FROM shop_layout_specific_data WHERE `key`=?)";

            $this->db->query($sql, array($value, $product_id, $key));
        }
    }
}
