<?php
class Shop_Product_Option extends MY_Model
{
	const DB_TABLE = 'shop_product_options';
    const DB_TABLE_PK = 'product_option_id';

    public function __construct()
	{
		parent::__construct();

		$this->site_id = 1;
	}

    function LoadBySiteID($id)
	{
		$query = $this->db->query("SELECT * FROM shop_product_options AS p WHERE p.site_id=? ORDER BY `option_label`", array($id));

		return $query->result();
	}

	function LoadByProductOrCategoryID($product_id=null, $category_id=null, $include_subcategories=true)
	{
		$sql = "SELECT * FROM shop_product_options AS p";
		$where = "";

		if($product_id != null)
		{
			$where .= ($where ? " OR " : " WHERE ") . "product_id='$product_id'";
		}
		if($category_id != null)
		{
			if($include_subcategories)
			{
				$this->load->model("shop/shop_category");
				$category = new Shop_Category();
				$category->load($category_id);

				$parent_ids = $category->GetParentIDs();

				if($parent_ids != "")
				{
					$where .= ($where ? " OR " : " WHERE ") . "category_id IN ($parent_ids)";
				}
			}
			else
			{
				$where .= ($where ? " OR " : " WHERE ") . "category_id='$category_id'";
			}
		}

		$sql .= $where;
		$sql .= " ORDER BY `option_label`";

		$query = $this->db->query($sql);

		return $query->result();
	}

	function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}
}
