<?php
class Shop_Product_Variant extends MY_Model
{
	const DB_TABLE = 'shop_product_variant';
    const DB_TABLE_PK = 'product_variant_id';

    function LoadByProductID($id)
	{
		$query = $this->db->query("SELECT v.*, prices.price AS price_cad,
									prices.price * cur.exchange_rate AS price,
									cur.currency_code, prices.shopper_group_id
		                          FROM shop_product_variant AS v
		                          INNER JOIN shop_prices AS prices ON prices.product_id=v.product_id AND v.product_variant_id=prices.product_variant_id AND prices.shopper_group_id=? AND prices.price IS NOT NULL
		                          INNER JOIN shop_currency AS cur ON cur.currency_code='" . (class_exists("Shop") ? (class_exists("Shop") ? Shop::currency() : "CAD") : "CAD") . "'
								  WHERE v.product_id=?
		                          ORDER BY v.`sort`, v.`variant`", array(Mainframe::user()->shopper_group_id, $id));

		return $query->result();
	}

	function LoadAllByProductID($id)
	{
		$query = $this->db->query("SELECT *
		                          FROM shop_product_variant
		                          WHERE product_id=?
		                          ORDER BY `sort`, `variant`",
		                          array($id));

		return $query->result();
	}

    public function delete_all($product_id)
    {
    	$this->db->query("DELETE FROM shop_product_variant WHERE product_id=?",
    	                 array($product_id));
    }

    public function delete_others($product_id, $variant_ids)
    {
    	$this->db->query("DELETE FROM shop_product_variant WHERE product_id=? AND product_variant_id NOT IN ?",
    	                 array($product_id, $variant_ids));
    }
}
