<?php
class Shop_Route extends MY_Model
{
	private $category_ids = "0";	//This value is for no other reason than to make concatenation easier.

	const DB_TABLE = 'shop_routes';
    const DB_TABLE_PK = 'route_id';

    public function __construct()
    {
    	parent::__construct();

    	$this->load->model(array("shop/shop_product", "shop/shop_category"));
    }

    public function LoadAllBySiteID($site_id)
    {
    	$query = $this->db->query("SELECT * FROM shop_routes WHERE site_id=?", array($site_id));

    	return $query->result();
    }

    public function LoadBySiteID($site_id, $url)
    {
    	$query = $this->db->query("SELECT * FROM shop_routes WHERE site_id=? AND url=?", array($site_id, $url));

    	foreach($query->result() as $row)
    	{
    		return $this->populate($row);
    	}

    	return false;
    }

    public function load_by_url_fragment($site_id, $url)
    {
    	$query = $this->db->query("SELECT * FROM shop_routes WHERE site_id=? AND (url=? OR url LIKE '" . $this->db->escape_str($url) . "/%')", array($site_id, $url));

    	return $query->result();
    }

    public function build_product_route($product)
	{
		$url 					= $product->GetURL();
		$category_path 			= $product->GetCategoryPath(false);
		$category_path_string 	= $product->GetCategoryPath(true);

		if($product->published == 0 || $url == "")
		{
			$this->db->query("DELETE FROM shop_routes WHERE product_id=?", array($product->product_id));
			return;
		}

		$query = $this->db->query("SELECT route_id FROM shop_routes WHERE site_id=? AND product_id=?",
		                          array($product->site_id, $product->product_id));

		if($query->num_rows())
		{
			$this->db->query("UPDATE shop_routes SET url=?, category_path=?, category_path_string=? WHERE site_id=? AND product_id=?",
			                 array($url, $category_path, $category_path_string, $product->site_id, $product->product_id));
		}
		else
		{
			$this->db->query("INSERT INTO shop_routes SET site_id=?, product_id=?, url=?, category_path=?, category_path_string=?",
			                 array($product->site_id, $product->product_id, $url, $category_path, $category_path_string));
		}
	}

	public function build_category_route($category)
	{
		$url 					= $category->GetURL();
		$category_path 			= $category->GetPath(false);
		$category_path_string 	= $category->GetPath(true);

		if($url == "" || $category == "" || $category_path_string == "")
		{
			return;
		}

		if($category->published == 0 || $url == "")
		{
			$this->db->query("DELETE FROM shop_routes WHERE category_id=?", array($category->category_id));
			return;
		}

		$query = $this->db->query("SELECT route_id FROM shop_routes WHERE site_id=? AND category_id=?",
		                          array($category->site_id, $category->category_id));

		if($query->num_rows())
		{
			$this->db->query("UPDATE shop_routes SET url=?, category_path=?, category_path_string=? WHERE site_id=? AND category_id=?",
			                 array($url, $category_path, $category_path_string, $category->site_id, $category->category_id));
		}
		else
		{
			$this->db->query("INSERT INTO shop_routes SET site_id=?, category_id=?, url=?, category_path=?, category_path_string=?",
			                 array($category->site_id, $category->category_id, $url, $category_path, $category_path_string));
		}

		// Add this category ID to the list of ones to ignore.
		// This is essential or we could end up in an infinite loop.
		$this->category_ids .= "," . $category->category_id;

		// Now rebuild any related categories or products
		$query = $this->db->query("SELECT category_id, product_id
		                          FROM shop_routes
		                          WHERE (category_id IS NULL OR category_id NOT IN (" . $this->category_ids . ")) AND
		                          (
		                           	category_path = '" . $category->category_id . "' OR
		                          	category_path LIKE '%|" . $category->category_id . "' OR
		                          	category_path LIKE '" . $category->category_id . "|%' OR
		                          	category_path LIKE '%|" . $category->category_id . "|%'
		                          )");

		foreach($query->result() as $row)
		{
			if($row->category_id)
			{
				$c = new Shop_Category();
				$c->load($row->category_id);
				$this->build_category_route($c);
				unset($c);
			}
			else if($row->product_id)
			{
				$p = new Shop_Product();
				$p->load($row->product_id);
				$this->build_product_route($p);
				unset($p);
			}
		}
	}
}
