<?php
class Shop_Vehicle extends MY_Model
{
	const DB_TABLE = 'shop_vehicles';
    const DB_TABLE_PK = 'vehicle_id';

    function GetVehiclesForProduct($id)
	{
		$query = $this->db->query("SELECT v.*
		                          FROM shop_vehicles AS v
								  INNER JOIN shop_vehicles_products AS vp ON v.vehicle_id=vp.vehicle_id
								  WHERE vp.product_id=?
								  ORDER BY `year` DESC, `make`, `model`, `style`",
								  array($id));

		return $query->result();
	}

    function GetVehicles()
	{
		$query = $this->db->query("SELECT * FROM shop_vehicles ORDER BY `year` DESC, `make`, `model`, `style`");

		return $query->result();
	}

	function GetYears()
	{
		$query = $this->db->query("SELECT DISTINCT `year`
		                          FROM shop_vehicles AS v
		                          ORDER BY `year` DESC");

		return $query->result();
	}

	function GetMakes($year)
	{
		$query = $this->db->query("SELECT DISTINCT `make`
		                          FROM shop_vehicles AS v
		                          WHERE `year`=? ORDER BY `make`",
		                          array($year));

		return $query->result();
	}

	function GetModels($year, $make)
	{
		$query = $this->db->query("SELECT DISTINCT `model`
		                          FROM shop_vehicles AS v
		                          WHERE `year`=? AND `make`=? ORDER BY `model`",
		                          array($year, $make));

		return $query->result();
	}

	function GetStyles($year, $make, $model)
	{
		$query = $this->db->query("SELECT DISTINCT `style`
		                          FROM shop_vehicles AS v
		                          WHERE `year`=? AND `make`=? AND `model`=? ORDER BY `style`",
		                          array($year, $make, $model));

		return $query->result();
	}

	function GetProducts($year, $make, $model, $style, $category_id=0)
	{
		$query = $this->db->query("SELECT p.*
		                          FROM shop_vehicles AS v
		                          INNER JOIN shop_vehicles_products AS vp ON v.vehicle_id=vp.vehicle_id
		                          INNER JOIN shop_products AS p ON p.product_id=vp.product_id
		                          INNER JOIN shop_routes AS r ON r.product_id=p.product_id
		                          LEFT JOIN shop_layout_specific_data_values AS dv ON p.product_id=dv.product_id
		                          WHERE p.published='1'" . ($category_id ? " AND $category_id REGEXP CONCAT('^(', r.category_path, ')$') " : "")
		                          . ($year > 0 		? " AND v.`year`='$year' " 		: "")
		                          . ($make != "" 	? " AND v.`make`='$make' " 		: "")
		                          . ($model != "" 	? " AND v.`model`='$model' " 	: "")
		                          . ($style != ""	? " AND v.`style`='$style' " 	: "")
		                          . " GROUP BY p.product_id");

		return $query->result();
	}

	function GetMakesMulti($years)
	{
		$years = urldecode($years);

		$query = $this->db->query("SELECT DISTINCT `make` FROM shop_vehicles WHERE `year` REGEXP '$years' ORDER BY `make`");

		return $query->result();
	}

	function GetModelsMulti($years, $makes)
	{
		$years = urldecode($years);
		$makes = addslashes(urldecode($makes));

		$query = $this->db->query("SELECT DISTINCT `model` FROM shop_vehicles WHERE `year` REGEXP '$years' AND `make` REGEXP '$makes' ORDER BY `model`");

		return $query->result();
	}

	function GetStylesMulti($years, $makes, $models)
	{
		$years 	= urldecode($years);
		$makes 	= addslashes(urldecode($makes));
		$models = addslashes(urldecode($models));

		$query = $this->db->query("SELECT DISTINCT `style` FROM shop_vehicles WHERE `year` REGEXP '$years' AND `make` REGEXP '$makes' AND `model` REGEXP '$models' ORDER BY `style`");

		return $query->result();
	}

	function GetProductsMulti($years, $makes, $models, $styles)
	{
		$years 	= urldecode($years);
		$makes 	= addslashes(urldecode($makes));
		$models = addslashes(urldecode($models));
		$styles = addslashes(urldecode($styles));

		$query = $this->db->query("SELECT p.*, v.vehicle_id, v.year, v.make, v.model, v.style
		                          FROM shop_vehicles AS v
		                          INNER JOIN shop_vehicles_products AS vp ON v.vehicle_id=vp.vehicle_id
		                          INNER JOIN shop_products AS p ON p.product_id=vp.product_id
		                          WHERE `year` REGEXP '$years' AND `make` REGEXP '$makes' AND `model` REGEXP '$models' AND `style` REGEXP '$styles'
		                          GROUP BY vehicle_id");

		return $query->result();
	}

	function link_to_product($vehicle_id, $product_id)
	{
		$query = $this->db->query("SELECT shop_vehicle_product_id FROM shop_vehicles_products WHERE vehicle_id=? AND product_id=?",
		                          array($vehicle_id, $product_id));

		if($query->num_rows() == 0)
		{
			$this->db->query("INSERT INTO shop_vehicles_products SET vehicle_id=?, product_id=?",
		                          array($vehicle_id, $product_id));
		}
	}

	function delete_link($vehicle_id, $product_id)
	{
		$query = $this->db->query("DELETE FROM shop_vehicles_products WHERE vehicle_id=? AND product_id=?",
		                          array($vehicle_id, $product_id));
	}
}
