<?php
/**
 *  FERAL FORM WIDGETS
 *  www.nerivon.com
 *  GPL
 *
 * Version 0.8.0 July 26, 2017
 * - Constructors updated for PHP 7 compatibility.
 *
 * Version 0.7.11 March 15, 2010
 * - added FeralProvinceSelectWidget to display a province select box.
 *
 *  Version 0.7.10 July 24, 2008
 *  -added quotes around the values for FeralRadioYesNo because the value 0 (no quotes)
 *  was being ignored by the browser and was resulting in random browser-specific results for "No"
 *
 *  Version 0.7.9 November, 19, 2007
 *  -added FeralGet() Function for retrieving clean values from GET and POST arrays
 *  -helps prevent SQL and HTML script injection.
 *
 *  Version 0.7.8 August 3, 2007
 *  -added another condition to the addInput() function of feral form to allow
 *      a combination of output buffer and straight HTML as a parameter
 *
 *  Version 0.7.7 July 30, 2007
 *  -added bare string input handling to the FeralForm->addInput() Function
 *  -enables the user to inject HTML/String etc directly into the inputs column
 *
 *  Version 0.7.6 July 30, 2007
 *  -added FeralForm object for creating a basic form in a two-column table layout
 *  -the FeralForm allows any Feral input object to be added to the form
 *  -added "id" tag to FeralTextArea
 *
 *  Version 0.7.5 July 5, 2007
 *  -added SetAttribute("id",$name."_checkbox") to the functionality of the FeralCheckBoxWidget
 *   so that if you use the widget, the associated checkbox control "can" be referenced if needed.
 *
 *  Version 0.7.4 July 4, 2006
 *  -added CheckedIfValue parameter to the FeralRadioWidget and FeralRadio function
 *  -modified FeralRadio widget to have the checkedifvalue attribute included before class and style
 *   in the constructor function so that it makes more sense in practice.
 *
 *  Version 0.7.4 August 11, 2006
 *  -added FeralRadioListWidget class
 *
 *  Version 0.7.3 June 28, 2006
 *  -added SetCols() / SetRows() functions to the FeralListPicker class
 *
 *  Version 0.7.2 June 21, 2006
 *  -added FeralRadioYesNo() function which produces a yes/no selector
 *
 *  Version 0.7.1 June 20, 2006
 *  -modified the AddOption() function of the BasicSelectWidget so that
 *   caption could be omitted during function calls, and the value is
 *   both used as a value and displayed.
 *  -modified the SetAttribute() function include a $force_inclusion option
 *   which forces an attribute to be output to the browser, even if the value
 *   provided is null or 0.
 *
 *  Version 0.7 June 20, 2006
 *  -added the FeralRadio function
 *  -added the FeralRadioWidget class
 *
 *  Version 0.6 June 7, 2006
 *  -added the FeralPasswordWidget class/function
 *  -added the FeralSubmit function and the FeralSubmitWidget class
 *  -added the FeralHidden function and the FeralHiddenWidget class
 *
 *  Version 0.5 (May 31, 2006)
 *  -added the FeralRedirect() function
 *
 *  Version 0.4 (May 29, 2006)
 *  -moved Javascript output into the FeralListPicker class
 *  -all subsequent classes will now have a Javascript() function which output
 *   the required javascript at the first call to the object.
 *
 *  Version 0.3 (May 24, 2006)
 *  -added FeralButtonConfirmJS() and FeralButtonConfirmURL
 *
 *  Version 0.2
 *  -bug fixes to FeralInput which correct for values that are provided empty
 *  -addition of FeralImageLink function
 *
 *  Version 0.1
 */

/**
 * An abstraction class for defining an HTML tag with attributes
 */
class FeralTag{
  var $tag;
  var $name;
  var $style;
  var $class;
  var $attributes;
  var $closetag;//indicates a tag that has a beginning and end tag ie, </option>
  var $enc;          //the text that is output between opening and closing tags
  var $encattribute; //the attribute value that is enclosed inside the tags *Optional

  /**
   * Constructor function
   */
  function __construct($tag, $closetag=false, $encattribute=NULL){
    $this->attributes = array();
    $this->tag = $tag;
    $this->closetag = $closetag;
    $this->encattribute = $encattribute;
  }//function FeralWidget

  /**
   * Adds an attribute to the attributes array
   * and sets a member value named $name to $value
   * $force_inclusion - use this to override the default behaviour of NOT including
   *                    an attribute if the value submitted is in face NULL or 0
   */
  function SetAttribute($name, $value=NULL, $force_inclusion=false){
    if($value != NULL || $force_inclusion){
      if($this->closetag && $this->encattribute == $name){
        $this->enc = $value;
      }else{
        $this->attributes[$name] = $value;
      }//if
    }//if
  }//function SetAttribute

  /**
   * Outputs the Control in the Browser
   */
  function Create(){
    echo $this->RenderHtml();
  }//function Create

  /**
   * Creates the HTML for the widget
   */
  function RenderHtml($extra=''){
    $html = "<$this->tag";
    $html .= $this->RenderAttributes();
    $html .= " $extra";
    if($this->closetag){
      $html .= ">";
      $html .= $this->enc;
      $html .= "</$this->tag>";
    }else{
      $html .= "/>";
    }//if
    return $html;
  }//function CreateHTML

  /**
   * Creates the HTML for attributes
   */
  function RenderAttributes(){
    $html = '';
    foreach($this->attributes as $k => $v){
      $html .= " $k=\"$v\"";
    }//foreach
    return $html;
  }//function RenderAttributes
}//class FeralWidget


/**
 * Provides the base class for all derivatives of the INPUT tag
 */
class FeralInput extends FeralTag{
  var $type;
  var $name;
  var $value;
  var $size;
  var $style;
  var $class;
  var $attributes;

  /**
   * Constructor function optionally defines the type and name attributes
   * at instantiation.
   */
  function __construct($type, $name=NULL, $value=NULL, $class=NULL, $style=NULL){
    parent::__construct('input');
    $this->SetAttribute('type', $type);
    $this->SetAttribute('name', $name);
    $this->SetAttribute('id', $name);
    $this->SetAttribute('value', $value);
    $this->SetAttribute('class', $class);
    $this->SetAttribute('style', $style);
  }//function FeralInput
}//class FeralWidget


/**
 * The Text Element is the most basic INPUT type form element that can be
 * implemented.
 */
class FeralTextWidget extends FeralInput{
  function __construct($name, $value='', $class=NULL, $style=NULL){
    parent::__construct('text', $name, $value, $class, $style);
  }//function FeralTextWidget
}//class FeralTextWidget


/**
 * The password element is a variant of the text widget
 */
class FeralPasswordWidget extends FeralInput{
  function __construct($name, $value='', $class=NULL, $style=NULL){
    parent::__construct('password', $name, $value, $class, $style);
  }//function
}//class


/**
 * the submit button is a basic element
 */
class FeralSubmitWidget extends FeralInput{
  function __construct($name, $value='', $class=NULL, $style=NULL){
    parent::__construct('submit', $name, $value, $class, $style);
  }//function
}//class


class FeralHiddenWidget extends FeralInput{
  function __construct($name, $value='', $class=NULL, $style=NULL){
    parent::__construct('hidden', $name, $value, $class, $style);
  }//function
}//class


/**
 * One of the basic controls is the checkbox/or yes/no field
 * Uses Javascript and a hidden field to store the actual data
 */
class FeralCheckBoxWidget extends FeralInput{
  function __construct($name, $value=0, $class=NULL, $style=NULL){
    parent::__construct('checkbox', NULL, NULL, $class, $style);
    $this->SetAttribute('id',$name."_checkbox");
    $this->SetAttribute('name',$name."_checkbox");
    $this->_field = new FeralInput('hidden', $name, $value);
    $this->_field->SetAttribute('id', $name);
    if($value) $this->SetAttribute('checked', 1);
    $this->SetAttribute('onclick', "if(this.checked){document.getElementById('$name').value=1;}else{document.getElementById('$name').value=0;}");
  }//function FeralCheckboxWidget

  function Create(){
    parent::Create();
    $this->_field->Create();
  }//function Create
}//class FeralCheckboxWidget


/**
 * DropDown Box which uses an AddOption function to add options
 * handles Values and Selections automatically based on the value
 * set in the attributes.
 */
class FeralBasicSelectWidget extends FeralTag{
  function __construct($name, $value=NULL, $class=NULL, $style=NULL){
    parent::__construct('select',true);
    $this->SetAttribute('name', $name);
    $this->SetAttribute('id', $name);
    $this->SetAttribute('class', $class);
    $this->SetAttribute('style', $style);
    $this->value = $value;
    $this->options = array();
    $this->_hasgroups = false;
  }//function FeralSelectWidget

  function AddOption($value, $caption=NULL){
    $newoption = new FeralTag('option', true, 'caption');
    $newoption->SetAttribute('value',$value,true);
    if($caption == NULL){
      $newoption->SetAttribute('caption',$value);
    }else{
      $newoption->SetAttribute('caption',$caption);
    }//if
    $this->options[] = $newoption;
  }//function AddOption

  function AddGroup($caption=NULL){
    //check to see if we need to end the group
    if($this->_hasgroups){
      $closetag = new FeralTag('/optgroup');
      $this->options[] = $closetag;
    }//if

    $group = new FeralTag('optgroup', true);
    $group->SetAttribute('label', $caption);
    $this->options[] = $group;
    $this->_hasgroups = true;
  }//function AddGroup

  function Create(){
    /*  fill the enc with data
        draw the control
    */
    $html = '';
    foreach($this->options as $option){
      $selected = ($option->attributes['value']==$this->value?'selected':'');
      $html .= $option->RenderHtml($selected);
    }//foreach
    $this->enc = $html;
    echo $this->RenderHtml();
  }//function Create
}//class FeralSelect


/**
 * Creates a list widget, instead of a drop down
 */
class FeralBasicListWidget extends FeralBasicSelectWidget{
  function __construct($name, $value=NULL, $class=NULL, $style=NULL){
    parent::__construct($name,$value,$class,$style);
    $this->SetCols();
    $this->SetRows();
  }//function FeralBasicListWidget

  function SetCols($cols=1){
    $this->SetAttribute('cols', $cols);
  }//function SetCols

  function SetRows($rows=5){
    $this->SetAttribute('rows', $rows);
  }//function SetRows

  function RenderHtml($extra=''){
    $result = $extra.=' multiple';
    return parent::RenderHtml($result);
  }//function RenderHtml
}//class FeralBasicListWidget

/**
 * Creates a list of radio options which all pertain to the same field but allow the selection of
 * only one option.
 */
class FeralRadioListWidget{
  var $options = array();
  var $name;
  var $value;
  var $class;
  var $style;
  var $orientation;

  function __construct($name, $value=NULL, $orientation="x", $class=NULL, $style=NULL){
    $this->name = $name;
    $this->value = $value;
    $this->class = $class;
    $this->style = $style;
    $this->orientation = $orientation;
  }//function

  function AddOption($value="", $label="", $default=false){
    $i = count($this->options);
    $this->options[$i]->label = $label;
    $this->options[$i]->value = $value;
    $this->options[$i]->default = $default;
  }//function

  function Create(){
    $y = ($this->orientation == "y");
    foreach($this->options as $opt){
      $radio = new FeralRadioWidget($this->name, $opt->value, $this->class, $this->style);
      if((string)$opt->value == (string)$this->value || (empty($this->value) && $opt->default)) $radio->SetAttribute('checked', '1');
      $radio->Create();
      echo " $opt->label".($y?"<br>":" ");
    }//foreach
  }//function
}//


/**
 * Instantiates a FeralTextWidget and displays the output
 */
function FeralText($name, $value='', $class='', $style=''){
  $widget = new FeralTextWidget($name, $value, $class, $style);
  $widget->Create();
}//function FeralText


/**
 * Instantiates a feralpasswordwidget and displays the output
 */
function FeralPassword($name, $value='', $class='', $style=''){
  $widget = new FeralPasswordWidget($name, $value, $class, $style);
  $widget->Create();
}//function


function FeralHidden($name, $value='', $class='', $style=''){
  $widget = new FeralHiddenWidget($name, $value, $class, $style);
  $widget->Create();
}//function


/**
 * Instantiates a FeralSubmitWidget
 */
function FeralSubmit($name, $value='', $class='', $style=''){
  $widget = new FeralSubmitWidget($name, $value, $class, $style);
  $widget->Create();
}//function

/**
 * Instantiates a FeralCheckBoxWidget and displays the Output
 */
function FeralCheckBox($name, $value=NULL, $class=NULL, $style=NULL){
  $widget = new FeralCheckBoxWidget($name, $value, $class, $style);
  $widget->Create();
}//function FeralCheckBox


/**
 * Creates a textarea element
 */
function FeralTextArea($name, $value=NULL, $class=NULL, $style=NULL){
  $widget = new FeralTag('textarea', true, 'value');
  $widget->SetAttribute('name', $name);
  $widget->SetAttribute('id', $name);
  $widget->SetAttribute('class', $class);
  $widget->SetAttribute('style', $style);
  $widget->SetAttribute('value', $value);
  $widget->Create();
}//function


/**
 * Radio Widget Class
 */
class FeralRadioWidget extends FeralInput{
  function __construct($name, $value=NULL, $checkedifvalue=NULL, $class=NULL, $style=NULL){
    parent::__construct('radio', $name, $value, $class, $style);
    if($checkedifvalue!=NULL){
      if($value==$checkedifvalue) $this->SetAttribute('checked',1);
    }//if
    $this->SetAttribute('id', '');
  }//function
}//class


/**
 * Creates a radio button and prints it immediately
 */
function FeralRadio($name, $value=NULL, $checkedifvalue=NULL, $class=NULL, $style=NULL){
  $widget = new FeralRadioWidget($name, $value, $checkedifvalue, $class, $style);
  $widget->Create();
}//function FeralRadio


/**
 * Creates a button with a link built into it.
 */
function FeralButton($value='', $target='', $class=NULL, $style=NULL){
  $widget = new FeralInput('button', NULL, $value, $class, $style);
  $widget->SetAttribute('onclick', $target);
  $widget->Create();
}//function Button


/**
 * Creates a button which follows a URL
 */
function FeralButtonURL($value='', $url='', $class=NULL, $style=NULL){
  $widget = new FeralInput('button', NULL, $value, $class, $style);
  $widget->SetAttribute('onclick', "window.location='$url';");
  $widget->Create();
}//function FeralURLButton


/**
 * Create a button which executes javascript after confirming with a question
 */
function FeralButtonConfirmJS($value='', $target='', $confirm='Click OK to Continue.', $class=NULL, $style=NULL){
  $widget = new FeralInput('button', NULL, $value, $class, $style);
  $widget->SetAttribute('onclick', "if(window.confirm('$confirm')){$target}");
  $widget->Create();
}//function


/**
 * Create a button which follows a url after confirming with a question
 */
function FeralButtonConfirmURL($value='', $url='', $confirm='Click OK to Continue.', $class=NULL, $style=NULL){
  $widget = new FeralInput('button', NULL, $value, $class, $style);
  $widget->SetAttribute('onclick', "if(window.confirm('$confirm')){window.location='$url';}");
  $widget->Create();
}//function


/**
 * Creates 3 Listboxes, one hidden, two displayed
 * One of the listboxes contains source objects
 * One of the listboxes contains the values selected and is hidden, all values are "selected" by default
 * The last box is for display purposes and it doesn't matter if any of the items are selected
 */
class FeralListPicker{
  var $addbutton;
  var $removebutton;
  var $sourcelist;
  var $displaylist;
  var $valuelist;
  var $values;

  function __construct($name, $values=array(), $class=NULL, $style=NULL){
    //Output the Javascript
    $this->Javascript();

    //Make Sure that the [] have not been included as part of the name
    if(substr($name,-2,2)=='[]'){
      $name = substr($name,0,strlen($name)-2);
    }//if

    //Initialization
    $sourcename = $name.'_source[]';
    $displayname = $name.'_display[]';
    $valuename = $name.'[]';
    $this->sourcelist = new FeralBasicListWidget($sourcename, NULL, $class, $style);
    $this->displaylist = new FeralBasicListWidget($displayname, NULL, $class, $style);
    $this->valuelist = new FeralBasicListWidget($valuename, NULL, NULL, "display:none");
    $this->sourceelement = "document.getElementById('$sourcename')";
    $this->displayelement = "document.getElementById('$displayname')";
    $this->valueelement = "document.getElementById('$valuename')";
    $this->values = $values;

    //Define the button Elements
    $this->addbutton = new FeralInput('button');
    $this->addbutton->SetAttribute('value', '&gt;&gt;');
    $this->addbutton->SetAttribute('onClick', "ListPicker_AddOption($this->sourceelement,$this->displayelement,$this->valueelement);");
    $this->removebutton = new FeralInput('button');
    $this->removebutton->SetAttribute('value', '&lt;&lt;');
    $this->removebutton->SetAttribute('onClick', "ListPicker_RemoveOption($this->sourceelement,$this->displayelement,$this->valueelement);");
  }//function

  /**
   * Javascript Function Definitions for the List Picker
   */
  function Javascript(){
    if(!defined("FERAL_LISTPICKERJS")){
      define("FERAL_LISTPICKERJS", 1);
      ?>
      <script type="text/javascript">
        /**
         * Used by the FeralListPicker class to select an option from the sourcelist
         * and add it to the displaylist and valuelist respectively, then remove the
         * option from the sourcelist.
         */
        function ListPicker_AddOption(sourcelist, displaylist, valuelist){
          var obj;
          var i;
          var opt;

          displaylist.options[displaylist.options.length]=sourcelist.options[sourcelist.selectedIndex];
          var option = displaylist.options[displaylist.options.length-1];

          valuelist.options.length = 0;

          for(i=0;i<displaylist.options.length;i++){
           obj = displaylist.options[i];
           opt = new Option(obj.text, obj.value, false, true);
           valuelist.add(opt,null);
          }//for

          for(i=0;i<valuelist.options.length;i++){
           valuelist.options[i].selected = true;
          }//for
        }//function

        /**
         * Used by the FeralListPicker class to select an option from the displaylist
         * and remove it from the displaylist and the valuelist elements respectively
         * then add the option to the sourcelist
         */
        function ListPicker_RemoveOption(sourcelist, displaylist, valuelist){
          var newopt;
          var opt;
          var val = displaylist.options[displaylist.selectedIndex].value;
          opt = displaylist.options[displaylist.selectedIndex];
          for(i=0;i<valuelist.options.length;i++){
           opt = valuelist.options[i];
           if(opt.value == val){
             valuelist.remove(i);
             break;
           }//if
          }//for
          newopt = new Option(opt.text, opt.value, false, false);
          sourcelist.add(newopt, null);
          displaylist.remove(displaylist.selectedIndex);
        }//function
      </script>
      <?php
    }//if
  }//function

  function AddOption($value, $caption=NULL){
    //This little block ignores a value if its been passed as part of the values array
    if(is_array($this->values)){
      if(count($this->values) > 0){
        if(in_array($value, $this->values)) {
          $this->displaylist->AddOption($value, $caption);
          $this->valuelist->AddOption($value, $caption);
          return;
        }//if
      }//if
    }//if

    //If the above block doesn't work out, then show the new option in source lists
    $this->sourcelist->AddOption($value, $caption);
  }//function

  function SetButtonStyle($style='', $class=''){
    $this->addbutton->SetAttribute('style',$style);
    $this->addbutton->SetAttribute('class',$style);
    $this->removebutton->SetAttribute('style',$style);
    $this->removebutton->SetAttribute('class',$style);
  }//function

  function SetListStyle($style='', $class=''){
    $this->displaylist->SetAttribute('style',$style);
    $this->displaylist->SetAttribute('class',$class);
    $this->sourcelist->SetAttribute('style',$style);
    $this->sourcelist->SetAttribute('class',$class);
  }//function

  function SetCols($cols=1){
    $this->sourcelist->SetCols($cols);
    $this->displaylist->SetCols($cols);
    $this->valuelist->SetCols($cols);
  }//function

  function SetRows($rows=1){
    $this->sourcelist->SetRows($rows);
    $this->displaylist->SetRows($rows);
    $this->valuelist->SetRows($rows);
  }//function

  function Create(){
    $this->valuelist->Create();
    echo "<table><tr><td>";
    $this->sourcelist->Create();
    echo "</td><td>";
    $this->addbutton->Create();
    echo "<br>";
    $this->removebutton->Create();
    echo "</td><td>";
    $this->displaylist->Create();
    echo "</td></table>";
  }//function
}//class


/**
 * Creates an image link, with an optional rollover image
 * the rollover is handled very very simply
 */
function FeralImageLink($srcImage, $targeturl, $srcRollOverImage='', $confirm='', $class=NULL, $style=NULL){
  $rollover = ($srcRollOverImage != ''?" onMouseOver=\"this.src='$srcRollOverImage';\" onMouseOut=\"this.src='$srcImage';\"":"");
  $onclick = ($confirm!=''?" onClick=\"if(window.confirm('$confirm')){window.location='$targeturl';}\"":" onClick=\"window.location='$targeturl';\"");
  echo "<img style='cursor:pointer' src='$srcImage' border='0'$rollover$onclick>";
}//function


/**
 * Redirect using either javascript or header
 * not really a control, but handy
 */
function FeralRedirect($url){
  if(headers_sent()){
    echo "<script type='text/javascript'>window.location='$url';</script>";
  }else{
    header("Location: $url");
  }//if
}//function


/**
 * Display two radio boxes, with values set so that its possible to select only one
 * with "Yes" and "No" labels.
 * @value - must be a boolean 1 or 0
 */
function FeralRadioYesNo($name, $value=0, $class=NULL, $style=NULL){
  $yes = new FeralInput("radio", $name, "1", $class, $style);
  if($value == 1) $yes->SetAttribute("checked", 1);
  $no = new FeralInput("radio", $name, "0", $class, $style);
  if($value != 1) $no->SetAttribute("checked", 1);
  $yes->Create();
  echo "Yes ";
  $no->Create();
  echo "No";
}//function


/**
 * FeralDatePicker is a simple version of a date picker, with drop downs for month, day and year
 */
function FeralDatePicker($name, $value=NULL, $class=NULL, $style=NULL, $yearsback=5, $yearsahead=5){
  //TODO:
}//function


/**
 *  Creates an HTML form element in a 2 column label/input pair
 *  Any Feral input object can be added to the form using addInput()
 */
class FeralForm extends FeralTag
{
    var $labels = "";
    var $inputs = "";
    var $count = 0;

    function __construct($name=NULL, $action=NULL, $method="POST", $class=NULL, $style=NULL)
    {
        parent::__construct('form', true);
        $this->SetAttribute('name', $name);
        $this->SetAttribute('id', $name);
        $this->SetAttribute('action', $action);
        $this->SetAttribute('method', $method);
        $this->SetAttribute('class', $class);
        $this->SetAttribute('style', $style);

        /*  while creating the form, output buffering must be enabled the whole time
            because some of the Feral objects directly echo their results to the screen.

            output buffering allows us to capture the echo'd HTML and save it to a variable
            so that we can add it to our generated HTML
        */

        ob_start();
    }//function FeralForm

    /**
    *    adds a label and a FeralTag object to arrays which will later build our table
    */
    function addInput($label, $input)
    {
        $this->labels[$this->count] = $label;

        if(is_object($input)){
            //if $input is an object, it is a FeralTag and is already what we want
            $this->inputs[$this->count] = $input;
        }elseif(ob_get_length() >0 && is_string($input)){
            /*  If there is something in the buffer AND a string passed, combine them */
            $this->inputs[$this->count] = ob_get_contents() . $input;
            ob_clean();
        }elseif(ob_get_length() >0){
            /*  If there is something in the buffer grab it */
            $this->inputs[$this->count] = ob_get_contents();
            ob_clean();
        }elseif(is_string($input)){
			/*  if $input is a string, save it for HTML later
            */
            $this->inputs[$this->count] = $input;
        }//if
        $this->count ++;
    }//function addInput

    function Create()
    {
        $html = "<table>";

        for($i=0; $i<$this->count; $i++)
        {
            $html .= "<tr>";
            $html .= "<td><label>" . $this->labels[$i] . "</label></td>";
            $html .= "<td>";

            if(is_object($this->inputs[$i]))
            {
                /*  if this is a Feral object, call its Create() function
                    and capture the HTML so that we an build our HTML
                */
                $this->inputs[$i]->Create();
                $html .= ob_get_contents();  //get the buffered component
                ob_clean();
            }
            else
            {
                /* if this isn't an object it's bare HTML captured earlier */
                $html .= $this->inputs[$i];
            }
            $html .= "</td>";
            $html .= "</tr>";
        }
        $html .= "</table>";
        $this->enc = $html;

        // ob_end_clean();     //clear and disable the output buffer
        parent::Create();
    }//function Create
}

/**
 * Retrieves a specified value by the associative key
 * from the specified array and sanitizes it for use
 * in code.
 */
function FeralGet($array, $key, $default_value = "")
{
	if(!isset($array[$key]))
	   return $default_value;

	return mysql_real_escape_string(strip_tags($array[$key]));
}

/**
 * Creates a province drop down list.
 */
function FeralProvinceSelectWidget($name, $value=NULL, $class=NULL, $style=NULL)
{
	$wgt = new FeralBasicSelectWidget($name, $value, $class, $style);
	$wgt->AddOption("AB", "Alberta");
	$wgt->AddOption("BC", "British Columbia");
	$wgt->AddOption("MB", "Manitoba");
	$wgt->AddOption("NB", "New Brunswick");
	$wgt->AddOption("NL", "Newfoundland and Labrador");
	$wgt->AddOption("NT", "Northwest Territories");
	$wgt->AddOption("NS", "Nova Scotia");
	$wgt->AddOption("NU", "Nunavut");
	$wgt->AddOption("ON", "Ontario");
	$wgt->AddOption("PE", "Prince Edward Island");
	$wgt->AddOption("QC", "Quebec");
	$wgt->AddOption("SK", "Saskatchewan");
	$wgt->AddOption("YT", "Yukon");

	$wgt->Create();
}
?>
