<fieldset class="<?php echo((!isset($accordion) || $accordion != false) ? "accordion" : ""); ?>">
	<legend>Access Control</legend>

	<div id="acl">
		<?php
		$user = get_user();

		foreach($acls as $acl)
		{
			if(!$acl->acl_id)
			{
				if($acl->acl_role_id == 3 || $user->has_role($acl->acl_role_id))	// Admins
				{
					$acl->read 	= 1;
					$acl->write = 1;
				}
				else
				{
					$acl->read 	= 1;
					$acl->write = 0;
				}
			}
			?>
			<div class="form-row mb-2">
				<label for="acl_<?php echo($acl->acl_role_id); ?>n" class="<?php echo(LABEL_COL); ?>"><?php echo($acl->role); ?></label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					if($acl->acl_role_id == 3 || $user->has_role($acl->acl_role_id))
					{
						multipleChoice("acl_" . $acl->acl_role_id, "rw", ["rw" => "Read / Write"]);
					}
					else
					{
						$options = ["n" => "None", "r" => "Read Only"];

						if($acl->acl_role_id > 1)
						{
							$options["rw"] = "Read / Write";
						}
						multipleChoice("acl_" . $acl->acl_role_id, ($acl->write == "1" ? "rw" : ($acl->read == "1" ? "r" : "n")), $options);
					}
					?>
				</div>
			</div>
			<?php
		}
		?>
	</div>
</fieldset>
