<?php
echo form_open("admin/category_save", array("id" => "category_form", "class" => "nvForm"));
echo form_hidden("category_id", $category->category_id);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Category</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/categories" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>
</div>

	<div class="form-row mb-2">
		<label for="name" class="<?php echo(LABEL_COL); ?>">Category</label>

		<div class="<?php echo(FIELD_COL); ?>">
			<?php
			echo form_input(array(
			              "name"        => "name",
			              "id"          => "name",
			              "value"       => $category->name,
			              "placeholder" => 'Category Name',
			              "required"	=> "required",
			              "class" 		=> "form-control"
			            ));
			?>
		</div>
	</div>

	<?php
	if(count($sites) > 1)
	{
		?>
		<div class="form-row mb-2">
			<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("site_id", ($category->site_id ? $category->site_id : Mainframe::active_site_id()), "form-control custom-select");

				foreach($sites as $site)
				{
					$wgt->AddOption($site->site_id, $site->name);
				}
				$wgt->Create();
				?>
			</div>
		</div>
		<?php
	}
	else
	{
		echo form_hidden("site_id", ($category->site_id ? $category->site_id : Mainframe::active_site_id()));
	}
	?>
</div>
<?php
echo form_close();
