<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Categories</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/category/0" class="btn btn-primary"><em class="fas fa-inbox" aria-hidden="true"></em> Add Category</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_categories",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "name", "title": "Category", "width": "70%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/category/' + row["category_id"] + '" class="click">' + data + '</a>';
		        	}},
		        { "data": "site_name", "title": "Site", "width": "20%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/site/' + row["site_id"] + '">' + data + '</a>';
		        	}},
		        { "data": "category_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/admin/category_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/category/{id}");
			}
		});
	});
</script>
