<?php
if($matomo_site_id && $matomo_token_auth)
{
	?>
	<div class="row">
		<div class="col-12"><h1>Website Stats Since <?php echo(date("F jS", strtotime("-6 months"))); ?></h1></div>

		<div class="col-12"><div id="stats_by_month" style="width: 100%; height: 300px"><div class="text-center"><em class="fas fa-circle-notch fa-3x fa-spin"></em></div></div><br></div>

		<div class="col-12 col-lg-6 col-xl-4">
			<fieldset>
				<legend>Vistor Information</legend>
				<table class="table table-striped table-bordered table-sm">
					<thead>
						<tr><th>Statistic</th><th>Value</th></tr>
					</thead>
					<tbody>
						<tr><td>Total Visitors</td><td id="totalVisitors"><em class="fas fa-circle-notch fa-spin"></em></td></tr>
						<tr><td>Bounce Rate</td><td id="bouncedVisitors"><em class="fas fa-circle-notch fa-spin"></em></td></tr>
						<tr><td>Returning Visitors</td><td id="returningVisitors"><em class="fas fa-circle-notch fa-spin"></em></td></tr>
						<tr><td>Returning Bounce Rate</td><td id="returningBouncedVisitors"><em class="fas fa-circle-notch fa-spin"></em></td></tr>
						<tr><td>Average Time On Site</td><td id="avgTimeOnSite"><em class="fas fa-circle-notch fa-spin"></em></td></tr>
					</tbody>
				</table><br>
			</fieldset>
		</div>
		<div class="col-12 col-lg-6 col-xl-4">
			<fieldset>
				<legend>Top 5 Search Engines</legend>
				<div id="Referrers_getSearchEngines"><div class="text-center"><em class="fas fa-circle-notch fa-spin"></em></div></div>
			</fieldset>
		</div>
		<div class="col-12 col-lg-6 col-xl-4">
			<fieldset>
				<legend>Top 5 Keywords</legend>
				<div id="Referrers_getKeywords"><div class="text-center"><em class="fas fa-circle-notch fa-spin"></em></div></div>
			</fieldset>
		</div>
		<div class="col-12 col-lg-6 col-xl-4">
			<fieldset>
				<legend>Top 5 Social Networks</legend>
				<div id="Referrers_getSocials"><div class="text-center"><em class="fas fa-circle-notch fa-spin"></em></div></div>
			</fieldset>
		</div>
		<div class="col-12 col-lg-6 col-xl-4">
			<fieldset>
				<legend>Top 5 Web Browsers</legend>
				<div id="DevicesDetection_getBrowsers"><div class="text-center"><em class="fas fa-circle-notch fa-spin"></em></div></div>
			</fieldset>
		</div>
		<div class="col-12 col-lg-6 col-xl-4">
			<fieldset>
				<legend>Top 5 Operating Systems</legend>
				<div id="DevicesDetection_getOsFamilies"><div class="text-center"><em class="fas fa-circle-notch fa-spin"></em></div></div>
			</fieldset>
		</div>
	</div>
	<?php
}
else
{
	?>
	<div class="row">
		<div class="col-12">
			<h1><?php echo(PRODUCT_NAME); ?> <span class="slogan"><?php echo(PRODUCT_VERSION); ?></span></h1>
		</div>

		<div class="col-12 col-md-6">
			<p class="text-center">
				<em class="fas fa-5x fa-chart-line"></em><br>You don't have Nerivon Stats enabled.<br>Please <a href="https://billing.nerivon.com/submitticket.php?step=2&deptid=1" target="_blank">contact us for an account</a>. Its FREE with your website.
			</p>
		</div>
		<?php
		if(Mainframe::site()->ga_code)
		{
			?>
			<div class="col-12 col-md-6">
				<p class="text-center">
					<em class="fab fa-5x fa-google"></em><br>You do have <a href="https://analytics.google.com" target="_blank">Google Analytics</a> installed.<br>You can <a href="https://analytics.google.com" target="_blank">view those stats here</a>.
				</p>
			</div>
			<?php
		}
		?>
	</div>
	<?php
}

if($matomo_site_id && $matomo_token_auth)
{
	?>
	<script>
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart()
		{
			jQuery.post
		    (
		        "/matomo/chart",
		        {
		        	function: "VisitsSummary.get",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var d = [];
		    	var i = 1;
		    	d[0] = ['Month', 'Total Visitors', 'Unique Visitors', 'Bounced Visitors'];

		    	for(var row in data)
		    	{
		    		d[i] = [row, data[row].nb_visits, data[row].nb_uniq_visitors, data[row].bounce_count];
		    		i++;
		    	}

		    	var data = google.visualization.arrayToDataTable(d);

				var options = {
					legend: { position: 'right' },
					animation:
					{
						duration: 1000,
						easing: 'linear',
						startup: true
					},
					hAxis:
					{
						slantedText: true,
						slantedTextAngle: 30
					},
					pointsVisible: true,
					chartArea:
					{
						top: "5%",
						left: "5%",
						width: "75%",
						height: "75%"
					}
				};

				var chart = new google.visualization.LineChart(document.getElementById('stats_by_month'));
				chart.draw(data, options);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});
		}

		jQuery(window).on("load", function()
		{
			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "VisitsSummary.get",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var t = "";
		    	var h = 0;
		    	var m = 0;
		    	var s = 0;

		    	h = Math.floor(data.avg_time_on_site / 60 / 60);
		    	m = Math.floor((data.avg_time_on_site - (h * 60 * 60)) / 60);
		    	s = data.avg_time_on_site - (h * 60 * 60) - (m * 60);

		    	if(h > 0)
		    	{
		    		t = h + "h, ";
		    	}
		    	if(m > 0)
		    	{
		    		t += m + "m, ";
		    	}
		    	t += s + "s";

		    	jQuery("#totalVisitors").html(data.nb_visits);
    			jQuery("#bouncedVisitors").html(data.bounce_count + " (" + data.bounce_rate + ")");
    			jQuery("#bounceRate").html(data.bounce_rate);
    			jQuery("#avgTimeOnSite").html(t);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});

  			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "VisitFrequency.get",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	jQuery("#returningVisitors").html(data.nb_visits_returning);
		    	jQuery("#returningBouncedVisitors").html(data.bounce_count_returning + " (" + data.bounce_rate_returning + ")");
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});

  			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "DevicesDetection.getBrowsers",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var html = '<table class="table table-striped table-bordered table-sm">';
		    	html += '<thead><tr><th>Browser</th><th>Visitors</th></thead><tbody>';
		    	var count = 0;
				var count = 0;

	    		for(var i=0; i<data.length; i++)
		    	{
		    		count++;
		    		html += '<tr><td>' + data[i].label + '</td><td>' + data[i].nb_visits + '</td></tr>';

		    		if(count == 5)
		    		{
		    			break;
		    		}
		    	}

		    	for(var i=count; i<5; i++)
		    	{
		    		html += '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
		    	}

		    	html += '</tbody></table><br>';

			    jQuery("#DevicesDetection_getBrowsers").html(html);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});

  			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "DevicesDetection.getOsFamilies",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var html = '<table class="table table-striped table-bordered table-sm">';
		    	html += '<thead><tr><th>Operating System</th><th>Visitors</th></thead><tbody>';
				var count = 0;

	    		for(var i=0; i<data.length; i++)
		    	{
		    		count++;
		    		html += '<tr><td>' + data[i].label + '</td><td>' + data[i].nb_visits + '</td></tr>';

		    		if(count == 5)
		    		{
		    			break;
		    		}
		    	}

		    	for(var i=count; i<5; i++)
		    	{
		    		html += '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
		    	}

		    	html += '</tbody></table><br>';

			    jQuery("#DevicesDetection_getOsFamilies").html(html);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});

  			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "Referrers.getKeywords",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var html = '<table class="table table-striped table-bordered table-sm">';
		    	html += '<thead><tr><th>Referral Source</th><th>Referrals</th></thead><tbody>';
				var count = 0;

	    		for(var i=0; i<data.length; i++)
		    	{
		    		count++;
		    		html += '<tr><td>' + data[i].label + '</td><td>' + data[i].nb_visits + '</td></tr>';

		    		if(count == 5)
		    		{
		    			break;
		    		}
		    	}

		    	for(var i=count; i<5; i++)
		    	{
		    		html += '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
		    	}

		    	html += '</tbody></table><br>';

			    jQuery("#Referrers_getKeywords").html(html);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});

  			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "Referrers.getSearchEngines",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var html = '<table class="table table-striped table-bordered table-sm">';
		    	html += '<thead><tr><th>Search Engine</th><th>Referrals</th></thead><tbody>';
				var count = 0;

	    		for(var i=0; i<data.length; i++)
		    	{
		    		count++;
		    		html += '<tr><td>' + data[i].label + '</td><td>' + data[i].nb_visits + '</td></tr>';

		    		if(count == 5)
		    		{
		    			break;
		    		}
		    	}

		    	for(var i=count; i<5; i++)
		    	{
		    		html += '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
		    	}

		    	html += '</tbody></table><br>';

			    jQuery("#Referrers_getSearchEngines").html(html);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});

  			jQuery.post
		    (
		        "/matomo/report",
		        {
		        	function: "Referrers.getSocials",
		        	matomo_site_id: "<?php echo($matomo_site_id); ?>",
		        	matomo_token_auth: "<?php echo($matomo_token_auth); ?>"
		        }
		    ).done(function(data)
		    {
		    	if(typeof data == "string")
		    	{
		    		data = JSON.parse(data);
		    	}

		    	var html = '<table class="table table-striped table-bordered table-sm">';
		    	html += '<thead><tr><th>Social Network</th><th>Referrals</th></thead><tbody>';
				var count = 0;

	    		for(var i=0; i<data.length; i++)
		    	{
		    		count++;
		    		html += '<tr><td>' + data[i].label + '</td><td>' + data[i].nb_visits + '</td></tr>';

		    		if(count == 5)
		    		{
		    			break;
		    		}
		    	}

		    	for(var i=count; i<5; i++)
		    	{
		    		html += '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
		    	}

		    	html += '</tbody></table><br>';

			    jQuery("#Referrers_getSocials").html(html);
  			})
			.fail(function(data)
			{
    			error("Error Loading Report", "", true, null);
  			});
		});
	</script>
	<?php
}