<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Event List</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/event/0" class="btn btn-primary"><em class="far fa-fw fa-calendar-alt" aria-hidden="true"></em> Add Event</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_events",
			"pageLength": 50,
			"order": [[2,'desc'], [1,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "is_parent", "title": "Type", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(row["is_parent"] == "1")
						{
							return "Parent";
						}
						else if(row["is_parent"] == "0" && row["parent_id"] > 0)
						{
							return "Child";
						}
						else
						{
							return "Single";
						}
			        }},
		        { "data": "headline", "title": "Headline", "width": "40%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/event/' + row["event_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "event_date", "title": "Date", "width": "20%", "className": "click", "searchable": true},
		        { "data": "time_start", "title": "Time", "width": "20%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	date_string = "";

						if(row["all_day"] == "1")
						{
							date_string += "all day";
						}
						else
						{
							if(row["time_start"] != null && row["time_end"] != null)
							{
								date_string += row["time_start"] + " to " + row["time_end"];
							}
						}

						return date_string;
			        }},
		        { "data": "event_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/admin/event_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/event/{id}");
			}
		});
	});
</script>
