<?php
echo form_open("admin/menu_save", array("id" => "menu_form", "class" => "nvForm"));
echo form_hidden("menu_id", $menu->menu_id);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Menu</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/menus" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>
</div>

<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<?php
		if(count($sites) > 1)
		{
			?>
			<div class="form-row mb-2">
				<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("site_id", ($menu->site_id ? $menu->site_id : Mainframe::active_site_id()), "form-control custom-select");

					foreach($sites as $site)
					{
						$wgt->AddOption($site->site_id, $site->name);
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<?php
		}
		else
		{
			echo form_hidden("site_id", ($menu->site_id ? $menu->site_id : Mainframe::active_site_id()));
		}
		?>
		<div class="form-row mb-2">
			<label for="name" class="<?php echo(LABEL_COL); ?>">Name <sup class="required">*</sup></label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralTextWidget("name", $menu->name, "form-control");
				$wgt->SetAttribute("required", "required");
				$wgt->Create();
				?>
			</div>
		</div>
	</div>

	<div class="<?php echo(TWO_COL); ?>"></div>
</div>

<?php
if($menu->menu_id)
{
	?>
	<div class="row">
		<div class="<?php echo(TWO_COL); ?>">
			<div class="alert alert-info">Drag &amp; Drop menu items to reorganize them. <span class="text-danger">You must save the menu after reorganizing menu items.</span></div>
		</div>
		<div class="<?php echo(TWO_COL); ?> text-right">
			<button type="button" class="btn btn-info" onclick="bulk_links()"><em class="fas fa-fw fa-list" aria-hidden="true"></em> Bulk Links</button>
			<a href="/admin/menuitem/<?php echo($menu->menu_id);?>/0" class="btn btn-primary"><em class="fas fa-fw fa-link" aria-hidden="true"></em> New Link</a>
		</div>
	</div>

	<div class="row">
		<div class="col-5 text-bold text-center">Menu Link</div>
		<div class="col-5 text-bold text-center">Page or URL</div>
		<div class="col-2 text-bold text-center">Actions</div>
	</div>

	<?php submenu($items); ?>
	<input type="hidden" name="sorting" id="sorting" />
	<?php
}

echo form_close();
?>

<div id="bulk-links-dialog" class="dialog">
	<form method="post" action="/admin/menuitem_bulk_save" class="nvForm">
		<input type="hidden" name="menu_id" value="<?php echo($menu->menu_id); ?>" />
		<input type="hidden" name="page_ids" id="page_ids" value="" />
		<?php csrf(); ?>

		<div class="row">
			<div class="col-6"><button type="button" class="btn btn-secondary" onclick="bulk_link_select_all()"><em class="far fa-fw fa-check-square" aria-hidden="true"></em> Select All</button> <button type="button" class="btn btn-secondary" onclick="bulk_link_select_none()"><em class="far fa-fw fa-square" aria-hidden="true"></em> Select None</button></div>
			<div class="col-6"><button type="submit" class="btn btn-primary"><em class="fas fa-fw fa-link" aria-hidden="true"></em> Create Menu Links For Selected Pages</button></div>
		</div>
	</form>

	<?php
	$last_category = "";

	foreach($orphans as $p)
	{
		if($last_category != $p->category_id)
		{
			?><p><b><?php echo($p->category_name); ?></b></p><?php
		}
		?><input type="checkbox" value="<?php echo($p->page_id); ?>" class="orphan-checkbox" name="page_id_<?php echo($p->page_id); ?>" id="page_id_<?php echo($p->page_id); ?>" onchange="bulk_link_click()" /> <label for="page_id_<?php echo($p->page_id); ?>" class="inline nobold"><?php echo($p->title); ?></label><br><?php
		$last_category = $p->category_id;
	}
	?>
</div>

<script>
jQuery(window).on("load", function()
{
	var group = jQuery("ol.sortable").sortable({
		delay: 100,
		group: "menuitems",
		onDrop: function ($item, container, _super)
		{
		    var data 		= group.sortable("serialize").get();
		    var jsonString 	= JSON.stringify(data, null, ' ');
		    jQuery("#sorting").val(jsonString);
		    _super($item, container);
		}
	});
});

function bulk_links()
{
	jQuery("#bulk-links-dialog").dialog(
	{
		title: "Bulk Add Menu Links",
		modal: true,
		width: 800,
		height: jQuery(window).height() * 0.9
	});
}

function bulk_link_click()
{
	ids = "";

	jQuery(".orphan-checkbox:checked").each(function()
	{
		ids = ids + jQuery(this).val() + ",";
	});

	if(ids)
	{
		ids = ids.substring(0, ids.length-1);
	}

	jQuery("#page_ids").val(ids);
}

function bulk_link_select_all()
{
	jQuery(".orphan-checkbox").prop("checked", true);
	bulk_link_click();
}

function bulk_link_select_none()
{
	jQuery(".orphan-checkbox").prop("checked", false);
	bulk_link_click();
}
</script>

<?php
function submenu($items)
{
	static $counter = 0;
	$counter++;
	?>
	<ol<?php echo($counter == 1 ? " class='sortable'" : ""); ?>>
		<?php
		foreach($items as $item)
		{
			?>
			<li data-id="<?php echo($item->menu_item_id); ?>">
				<div class="row">
					<div class="col-5">
						<a href="/admin/menuitem/<?php echo($item->menu_id); ?>/<?php echo($item->menu_item_id)?>"><?php
						if($item->icon)
						{
							?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
						}
						echo($item->title);
						?></a>
					</div>
					<div class="col-5">
						<?php
						if($item->page_id)
						{
							?><a href="/admin/page/<?php echo $item->page_id?>"><?php echo $item->page_title?></a><?php
						}
						else
						{
							?><a href="<?php echo $item->url?>" target="_blank"><?php echo $item->url?></a><?php
						}
						?>
					</div>

					<div class="col-2 nowrap text-right">
						<a href="/admin/menuitem/<?php echo($item->menu_id); ?>/<?php echo($item->menu_item_id)?>" class="btn btn-sm btn-primary"><em class="fas fa-fw fa-wrench" aria-hidden="true"></em></a>
						<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="nerivon_confirm('Are you sure?', 'This menu item will be deleted.', 'warning', true, function(){ window.location='/admin/menuitem_delete?id=<?php echo $item->menu_item_id?>'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>
					</div>
				</div>

				<?php
				if(count($item->children))
				{
					submenu($item->children);
				}
				else
				{
					?><ol></ol><?php
				}
				?>
			</li>
			<?php
		}
		?>
	</ol>
	<?php
}
