<div ng-controller="ModuleController" ng-init="load_page_settings(<?php echo($page->page_id ? $page->page_id : 0); ?>, $event);" ng-cloak>
	<?php
	echo form_open_multipart("admin/page_save", array("id" => "page_form", "class" => "nvForm"));
	echo form_hidden("page_id", $page->page_id);
	echo form_hidden("content_type_id", $page->content_type_id);
	echo form_hidden("created", $page->created);
	echo form_hidden("modified", $page->modified);
	csrf();
	?>
	<div class="row">
		<div class="<?php echo(TOP_LEFT); ?>">
			<h2>Edit <?php echo($page->content_type); ?></h2>
		</div>
		<div class="<?php echo(TOP_RIGHT); ?>">
			<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
			<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
			<a href="/admin/pages" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
		</div>
	</div>

	<?php
	if($page->page_info == 0)
	{
		$this->load->view("content/" . $page->content_type_filename . "_admin", array("page" => $page));
	}
	else
	{
		if($page->page_info == 2)
		{
			$this->load->view("content/" . $page->content_type_filename . "_admin", array("page" => $page));
		}
		?>
		<div class="row">
			<div class="<?php echo(TWO_COL); ?>">
				<fieldset>
					<legend>General Information</legend>

					<div>
						<?php
						if(count($sites) > 1)
						{
							?>
							<div class="form-row mb-2">
								<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site <sup class="required">*</sup></label>

								<div class="<?php echo(FIELD_COL); ?>">
									<?php
									$wgt = new FeralBasicSelectWidget("site_id", ($page->site_id ? $page->site_id : Mainframe::active_site_id()), "form-control custom-select");

									foreach($sites as $s)
									{
										$wgt->AddOption($s->site_id, $s->name);
									}
									$wgt->Create();
									?>
								</div>
							</div>
							<?php
						}
						else
						{
							echo form_hidden("site_id", ($page->site_id ? $page->site_id : Mainframe::active_site_id()));
						}
						?>
						<div class="form-row mb-2">
							<label for="title" class="<?php echo(LABEL_COL); ?>">Title <sup class="required">*</sup></label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("title", htmlentities($page->title), "form-control");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("placeholder", "The title will display in the title bar of the user's web browser.");
								$wgt->SetAttribute("onblur", "updateURL(this, 'url', 'category_id', " . ($page->page_id ? 'false' : 'true') . ");");
								$wgt->Create();
								?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php multipleChoice("title_heading_level", $page->title_heading_level, ["1" => "H1", "2" => "H2", "3" => "H3", "4" => "H4", "5" => "H5", "6" => "H6", "0" => "None"]); ?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="category_id" class="<?php echo(LABEL_COL); ?>">Category</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralBasicSelectWidget("category_id", $page->category_id, "form-control custom-select");
								$wgt->AddOption(0, "None");
								$wgt->SetAttribute("onblur", "updateURL(document.getElementById('title'), 'url', 'category_id', " . ($page->page_id ? 'false' : 'true') . ");");

								foreach($categories as $category)
								{
									$wgt->AddOption($category->category_id, $category->name);
								}
								$wgt->Create();
								?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="tag_ids" class="<?php echo(LABEL_COL); ?>">Tags</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$x = new Tag_TokenInput("tag_ids", "/ajax/get_tokens/page_tag", true);
								$x->render();
								?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="url_override" class="<?php echo(LABEL_COL); ?>">Content List URL Override</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("url_override", $page->url_override, "form-control");
								$wgt->SetAttribute("placeholder", "URL used for content lists");
								$wgt->Create();
								?>
							</div>
						</div>
					</div>
				</fieldset>
			</div>
			<div class="<?php echo(TWO_COL); ?>">
				<fieldset class="accordion">
					<legend>Publishing Options</legend>

					<div>
						<div class="form-row mb-2">
							<label for="published" class="<?php echo(LABEL_COL); ?>">Published</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("published", $page->published); ?></div>
						</div>
						<div class="form-row mb-2">
							<label for="searchable" class="<?php echo(LABEL_COL); ?>">Searchable</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("searchable", $page->searchable); ?></div>
						</div>
						<div class="form-row mb-2">
							<label for="allow_url_segments" class="<?php echo(LABEL_COL); ?>">Allow URL Segments</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("allow_url_segments", $page->allow_url_segments); ?></div>
						</div>
						<div class="form-row mb-2">
							<label for="allow_url_query" class="<?php echo(LABEL_COL); ?>">Allow Query String</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("allow_url_query", $page->allow_url_query); ?></div>
						</div>
						<div class="form-row mb-2">
							<label for="rss" class="<?php echo(LABEL_COL); ?>">RSS</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("rss", $page->rss); ?></div>
						</div>
						<div class="form-row mb-2">
							<label for="start_publishing" class="<?php echo(LABEL_COL); ?>">Start Publishing</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<input type="datetime-local" name="start_publishing" id="start_publishing" value="<?php echo(($page->start_publishing ? date("Y-m-d\TH:i:s", strtotime($page->start_publishing)) : null)); ?>" class="form-control" />
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="stop_publishing" class="<?php echo(LABEL_COL); ?>">Stop Publishing</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<input type="datetime-local" name="stop_publishing" id="stop_publishing" value="<?php echo(($page->stop_publishing ? date("Y-m-d\TH:i:s", strtotime($page->stop_publishing)) : null)); ?>" class="form-control" />
							</div>
						</div>
					</div>
				</fieldset>

				<fieldset class="accordion">
					<legend>Search Engine Optimization</legend>

					<div>
						<div class="form-row mb-2">
							<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("url", $page->url, "form-control");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("pattern", "[A-Za-z0-9/\-_]*");
								$wgt->SetAttribute("placeholder", "The URL will display in the address bar of the user's web browser.");
								$wgt->SetAttribute("title", "Please enter a URL using only letters, numbers, dashes, underscores, or forward slashes.  Do not include '.html' in your URL.");
								$wgt->SetAttribute("onkeyup", "jQuery('#url_preview').html(this.value)");
								$wgt->Create();
								?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label class="<?php echo(LABEL_COL); ?>"></label>

							<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><a href="<?php echo(LIVE_SITE); ?>/<?php echo($page->url); ?>" target="_blank"><?php echo(LIVE_SITE); ?>/<span id="url_preview"><?php echo($page->url); ?></span></a></div></div>
						</div>
						<div class="form-row mb-2">
							<label for="description" class="col-12">Description</label>

							<div class="col-12">
								<?php FeralTextArea("description", $page->description, "form-control"); ?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="title" class="<?php echo(LABEL_COL); ?>">Sitemap Priority</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("sitemap_priority", htmlentities($page->sitemap_priority), "form-control");
								$wgt->SetAttribute("placeholder", "The sitemap.xml page priority.");
								if ($page->sitemap_priority == "")
								{
								    $wgt->SetAttribute("value", "0.5");
								}
								$wgt->Create();
								?>
							</div>
						</div>
						
						<div class="form-row mb-2">
							<label for="title" class="<?php echo(LABEL_COL); ?>">Sitemap Change Frequency</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("sitemap_changefreq", htmlentities($page->sitemap_changefreq), "form-control");
								$wgt->SetAttribute("placeholder", "The sitemap.xml page changefreq.");
								$wgt->Create();
								?>
							</div>
						</div>
					</div>
				</fieldset>

				<fieldset class="accordion">
					<legend>Module Selection</legend>

					<div>
						<p><a href="#" onclick="selectAllModules(1); return false;"><em class="far fa-fw fa-check-square" aria-hidden="true"></em> All Modules</a>
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<a href="#" onclick="selectAllModules(0);" return false;><em class="far fa-fw fa-square" aria-hidden="true"></em> No Modules</a></p>

						<?php
						foreach($modules as $module)
						{
							?>
							<div class="form-row mb-2">
								<label for="module_<?php echo($module->module_instance_id); ?>" class="<?php echo(LABEL_COL); ?>"><?php echo($module->tag); ?></label>
								<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("module_$module->module_instance_id", $module->module_installed, "module-checkbox", "Show", "Hide"); ?></div>
							</div>
							<?php
						}
						?>
					</div>
				</fieldset>

				<?php $this->load->view("admin/acl", array("acls" => $acls)); ?>
				
				<fieldset class="accordion">
					<legend>Facebook Open Graph</legend>

					<div>
						<div class="form-row mb-2">
							<label for="og_title" class="<?php echo(LABEL_COL); ?>">Title</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<p id="og_title" name="og_title"><?php echo($page->title); ?></p>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="og_description" class="<?php echo(LABEL_COL); ?>">Description</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<p id="og_description" name="og_description"><?php echo($page->description); ?></p>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="og_url" class="<?php echo(LABEL_COL); ?>">URL</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<p id="og_url" name="og_url"><?php echo(base_url($page->url)); ?></p>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="og_type" class="<?php echo(LABEL_COL); ?>">Type</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("og_type", $page->og_type, "form-control");
								$wgt->SetAttribute("placeholder", "Open Graph type property");
								if ($page->og_type == "")
								{
								    $wgt->SetAttribute("value", "article");
								}
								$wgt->Create();
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="og_image" class="<?php echo(LABEL_COL); ?>">Image URL</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("og_image", $page->og_image, "form-control");
								$wgt->SetAttribute("placeholder", "Open Graph image property");
								$wgt->Create();
								?>
							</div>
						</div>
					</div>
				</fieldset>
			</div>
		</div>

		<?php
		if($page->page_info == 1)
		{
			$this->load->view("content/" . $page->content_type_filename . "_admin", array("page" => $page));
		}
	}
	echo form_close();
	?>
</div>

<script>
jQuery(window).on("load", function()
{
	// We have to wait until we know the tokeninput is initialized.
	var x = setInterval(function()
	{
		if(!document.getElementById("token-input-tag_ids"))
		{
			return;
		}

		obj = jQuery("#tag_ids");
		obj.tokenInput("clear");

		<?php
		foreach($page->tags as $tag)
		{
			?>obj.tokenInput("add", {id: "<?php echo($tag->tag_id); ?>", name: "<?php echo($tag->tag); ?>"});
			<?php
		}
		?>
		clearInterval(x);
	}, 1000);

	get_popular_image_size(null);
	
	jQuery("#title").on("input", function(e) {
        jQuery("#og_title").text(jQuery("#title").val());
    });
    
    jQuery("#url").on("input", function(e) {
        jQuery("#og_url").text(jQuery("#url").val());
    });
    
    jQuery("#description").on("input", function(e) {
        jQuery("#og_description").text(jQuery("#description").val());
    });
});
</script>
