<div class="row">
	<div class="col-12 col-lg-3">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Pages</h2>
	</div>
	<div class="col-12 col-lg-6">
		<form class="nvForm">
			<?php csrf(); ?>

			<div class="form-row mb-2">
				<label for="content_type_id" class="<?php echo(LABEL_COL); ?>">Content Type</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<select id="content_type_id" class="form-control form-control-sm custom-select list-filter" data-filter-name="content_type_id">
						<?php
						$content_type_id = $this->input->get_post("content_type_id");
						$selected = (!$content_type_id);
						?><option value="" <?php echo($selected ? "selected" : ""); ?>>All Content Types</option><?php

						foreach($content_types as $type)
						{
							$selected = ($content_type_id == $type->content_type_id);
							?><option value="<?php echo($type->content_type_id); ?>" <?php echo($selected ? "selected" : ""); ?>><?php echo($type->content_type); ?></option><?php
						}
						?>
					</select>
				</div>
			</div>
			<div class="form-row mb-2">
				<label for="category_id" class="<?php echo(LABEL_COL); ?>">Category</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<select id="category_id" class="form-control form-control-sm custom-select list-filter" data-filter-name="category_id">
						<?php
						$category_id = $this->input->get_post("category_id");
						$selected = (!$category_id);
						?><option value="" <?php echo($selected ? "selected" : ""); ?>>All Categories</option><?php

						foreach($categories as $cat)
						{
							$selected = ($category_id == $cat->category_id);
							?><option value="<?php echo($cat->category_id); ?>" <?php echo($selected ? "selected" : ""); ?>><?php echo($cat->name); ?></option><?php
						}
						?>
					</select>
				</div>
			</div>
		</form>
	</div>
	<div class="col-12 col-lg-3 text-right">
		<a href="/admin/content_types" class="btn btn-primary"><em class="far fa-edit" aria-hidden="true"></em> Add Page</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	var table;

	jQuery(window).on("load", function()
	{
		// For some reason we have to delay slightly or jQuery picks up the filters as having no value initially.
		setTimeout(function()
		{
			table = jQuery("#list").DataTable(
		    {
				"pagingType": "full_numbers",
				"processing": true,
				"serverSide": true,
				"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
				"ajax": {
					url: "/ajax/get_pages",
					type: "GET",
					data: function(d)
					{
	                    d.content_type_id = jQuery("#content_type_id").val();
	                    d.category_id     = jQuery("#category_id").val();
	                }
				},
				"pageLength": 50,
				"order": [[0,'asc']],
				"stateSave": true,
				"columns": [
			        { "data": "title", "title": "Title", "width": "20%", "className": "click", "searchable": true,
			        	"render": function(data, x, row)
				        {
				        	return '<a href="/admin/page/' + row["page_id"] + '" class="click">' + data + '</a>';
				        }},
			        { "data": "url", "title": "URL", "width": "15%", "className": "click", "searchable": true},
			        { "data": "content_type", "title": "Content Type", "width": "15%", "className": "click", "searchable": true},
			        { "data": "created", "title": "Created", "width": "15%", "className": "click", "searchable": true},
			        { "data": "modified", "title": "Modified", "width": "15%", "className": "click", "searchable": true},
			        { "data": "category_name", "title": "Category", "width": "10%", "className": "click", "searchable": true},
			        { "data": "page_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
			        	"render": function(data, x, row)
				        {
				        	var buttons = '<div class="nowrap">';
		                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/admin/page_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
		                    buttons += '</div>';

		                    return buttons;
				        }}
			    ],
				'drawCallback': function()
				{
					table_hover("#list", "/admin/page/{id}");
				}
			});
		}, 250);

		jQuery('#content_type_id, #category_id').change(function()
		{
	        table.draw();
	    });
	});
</script>
