<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>URL Redirects</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/redirect/0" class="btn btn-primary"><em class="fas fa-sync" aria-hidden="true"></em> Add URL Redirect</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_redirects",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "old_url", "title": "Old URL", "width": "45%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return data;
			        }},
		        { "data": "new_url", "title": "New URL", "width": "45%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return data;
			        }},
		        { "data": "redirect_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This redirect will be deleted.\', true, function() { window.location=\'/admin/redirect_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/redirect/{id}");
			}
		});
	});
</script>
