<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Roles</h2>
	</div>

	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/role" class="btn btn-primary"><em class="fas fa-tasks" aria-hidden="true"></em> Add Role</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_roles",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "role", "title": "Name", "width": "30%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/role/' + row["acl_role_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "description", "title": "Description", "width": "30%", "className": "click", "searchable": true},
		        { "data": "actions", "title": "Permitted Actions", "width": "30%", "className": "click", "searchable": true},
		        { "data": "acl_role_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '';

			        	// Role ID 1, 2, and 3 are reserved and can't be deleted.
			        	if(data > 3)
			        	{
			        		buttons = '<div class="nowrap">';
	                    	buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/admin/role_delete/' + data+ '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    	buttons += '</div>';
	                    }

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/role/{id}");
			}
		});
	});
</script>
