<h2>Search Engine Optimization Tools (SEO)</h2>

<fieldset>
	<legend>Google Analytics</legend>

	<p>Google Analytics is the gold standard in website traffic analysis. You can obtain a free tracking ID and enter it in your site configuration to begin tracking website traffic.</p>
	<?php
	if($ga_code)
	{
		?><div class="alert alert-success text-center">Google Analytics is enabled (<?php echo($ga_code); ?>).</div><?php
	}
	else
	{
		?><div class="alert alert-warning text-center">Google Analytics is not enabled.<hr>It can be enabled by adding your tracking ID to your site configuration.</div><?php
	}
	?>
	<p class="text-center">
		<a href="https://analytics.google.com" class="btn btn-primary" target="_blank"><em class="fab fa-fw fa-google" aria-hidden="true"></em> Access Google Analytics</a>
		<?php
		if($user->has(ACTION_CONFIG))
		{
			?><a href="/admin/site/<?php echo(Mainframe::site()->site_id); ?>" class="btn btn-primary"><em class="fas fa-fw fa-globe" aria-hidden="true"></em> Edit Site Configuration</a><?php
		}
		?>
	</p>
</fieldset>

<div class="row">
	<div class="col-12 col-sm-6">
		<fieldset>
			<legend>Sitemap Generator</legend>

			<p>This will crawl your website and create a <code>sitemap.xml</code> file which search engines use to locate your content.</p>
			<p>Ideally you should add a daily cron job to run the following:<br><code>php <?php echo(ABSOLUTE_PATH); ?>/index.php crawler sitemap >/dev/null 2>&1</code></p>
			<p>If you'd prefer to run this command manually, use the button below.</p>
			<p class="text-center"><a href="/crawler/sitemap/1" class="btn btn-primary"><em class="fas fa-fw fa-sitemap" aria-hidden="true"></em> Generate Sitemap</a></p>
		</fieldset>
	</div>

	<div class="col-12 col-sm-6">
		<fieldset>
			<legend>Link Checker</legend>

			<p>This will crawl your website and look for links, images, and other resources that may be broken.</p>
			<p>Ideally you should add a daily cron job to run the following:<br><code>php <?php echo(ABSOLUTE_PATH); ?>/index.php crawler linkcheck >/dev/null 2>&1</code></p>
			<p>If you'd prefer to run this command manually, use the button below.</p>
			<div class="alert alert-warning">This can take a <b>long time</b> depending on the size of your website.</div>
			<p class="text-center">
				<a href="/crawler/linkcheck/1" class="btn btn-primary"><em class="fas fa-fw fa-link" aria-hidden="true"></em> Check Links</a>
				<a href="/admin/crawler_issues" class="btn btn-primary"><em class="fas fa-fw fa-exclamation-circle" aria-hidden="true"></em> View Crawler Issues</a>
			</p>
		</fieldset>
	</div>

	<div class="col-12 col-sm-6">
		<fieldset>
			<legend>Page Meta Data</legend>

			<p>This page allows you to update the meta data for each of your pages, as well as the meta data for any given URL that you want such as a specific portfolio or testimonial item.</p>
			<p class="text-center"><a href="/admin/metadata_pages" class="btn btn-primary"><em class="far fa-fw fa-file-alt" aria-hidden="true"></em> Edit Page Meta Data</a></p>
		</fieldset>
	</div>

	<div class="col-12 col-sm-6">
		<fieldset>
			<legend>Image Meta Data</legend>

			<p>Image meta data can be edited using Media Manager.</p>
			<p class="text-center"><a href="/finder" class="btn btn-primary"><em class="far fa-fw fa-file-image" aria-hidden="true"></em> Edit Image Meta Data</a></p>
		</fieldset>
	</div>

	<div class="col-12 col-sm-6">
		<fieldset>
			<legend>404 Errors</legend>

			<p>404 errors are pages or files that somebody tried to access which were not available (broken links).</p>
			<p class="text-center"><a href="/admin/http404s" class="btn btn-primary"><em class="fas fa-fw fa-unlink" aria-hidden="true"></em> View 404 Errors</a></p>
		</fieldset>
	</div>

	<div class="col-12 col-sm-6">
		<fieldset>
			<legend>URL Redirects</legend>

			<p>URL redirects can be added to redirect old pages to new pages or redirect broken links to a new page.</p>
			<p class="text-center"><a href="/admin/redirects" class="btn btn-primary"><em class="fas fa-fw fa-sync" aria-hidden="true"></em> Manage URL Redirects</a></p>
		</fieldset>
	</div>
</div>