<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Sites</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/site/0" class="btn btn-primary"><em class="fas fa-globe" aria-hidden="true"></em> Add Site</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_sites",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "name", "title": "Name", "width": "60%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/site/' + row["site_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "template_name", "title": "Template", "width": "30%", "className": "click", "searchable": true},
		        { "data": "site_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/admin/site_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/site/{id}");
			}
		});
	});
</script>
