<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Users</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/user/0" class="btn btn-primary"><em class="far fa-user" aria-hidden="true"></em> Add User</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get/user",
			"pageLength": 50,
			"order": [[5,'desc'],[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "username", "title": "Username", "width": "20%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/user/' + row["user_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "fname", "title": "First Name", "width": "15%", "className": "click", "searchable": true},
		        { "data": "lname", "title": "Last Name", "width": "15%", "className": "click", "searchable": true},
		        { "data": "company", "title": "Company", "width": "15%", "className": "click", "searchable": true},
		        { "data": "email", "title": "Email", "width": "15%", "className": "click", "searchable": true},
		        { "data": "active", "title": "Active", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return (data == "1" ? "Yes" : "No");
			        }},
		        { "data": "user_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/admin/user_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/user/{id}");
			}
		});
	});
</script>
