<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Contact Form Settings</legend>

			<div class="form-row mb-2">
				<label for="field_title_contact" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_title_contact" id="field_title_contact" ng-model="params.title_contact.value" class="form-control" data-default="Contact Us" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_title_heading_level_contact" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_title_heading_level_contact", "params.title_heading_level_contact.value", "h2", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_module_class" id="field_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_recaptcha_public_key" class="<?php echo(LABEL_COL); ?>">Recaptcha Site Key</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_recaptcha_public_key" id="field_recaptcha_public_key" ng-model="params.recaptcha_public_key.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_recaptcha_private_key" class="<?php echo(LABEL_COL); ?>">Recaptcha Secret Key</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_recaptcha_private_key" id="field_recaptcha_private_key" ng-model="params.recaptcha_private_key.value" class="form-control" /></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Recipients</legend>

			<div class="form-row mb-2">
				<label for="field_recipients" class="<?php echo(LABEL_COL); ?>">Recipients (separate with ;)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_recipients" id="field_recipients" ng-model="params.recipients.value" class="form-control" data-default="" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_departments" class="<?php echo(LABEL_COL); ?>">Departments (separate with ;)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_departments" id="field_departments" ng-model="params.departments.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_addresses" class="<?php echo(LABEL_COL); ?>">E-mail Addresses (separate with ;)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_addresses" id="field_addresses" ng-model="params.addresses.value" class="form-control" /></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Field Settings</legend>

			<div class="form-row mb-2">
				<label for="field_show_name" class="<?php echo(LABEL_COL); ?>">Show Name?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_name", "params.show_name.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_phone" class="<?php echo(LABEL_COL); ?>">Show Phone?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_phone", "params.show_phone.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_email" class="<?php echo(LABEL_COL); ?>">Show Email?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_email", "params.show_email.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_subject" class="<?php echo(LABEL_COL); ?>">Show Subject?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_subject", "params.show_subject.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_default_subject" class="<?php echo(LABEL_COL); ?>">Default Subject</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_default_subject" id="field_default_subject" ng-model="params.default_subject.value" class="form-control" data-default="" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_message" class="<?php echo(LABEL_COL); ?>">Show Message?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_message", "params.show_message.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_extra_fields" class="<?php echo(LABEL_COL); ?>">Extra Fields</label>
				<div class="<?php echo(FIELD_COL); ?>"><textarea name="field_extra_fields" id="field_extra_fields" ng-model="params.extra_fields.value" class="form-control" placeholder="label|name|type|required|any other attributes (one per line)"></textarea></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_redirect" class="<?php echo(LABEL_COL); ?>">Success Redirect</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<input type="text" name="field_redirect" id="field_redirect" ng-model="params.redirect.value" class="form-control" data-default="" />
					<div class="alert alert-info">Leave this blank to show the success message instead.</div>
				</div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Messages</legend>

			<div class="form-row mb-2">
				<label for="field_success_message" class="col-12" class="<?php echo(LABEL_COL); ?>">Success Message</label>
				<div class="col-12"><textarea ckeditor-basic name="field_success_message" id="field_success_message" ng-model="params.success_message.value" class="form-control" data-default="Thank you, your message was sent."></textarea></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_error_message" class="col-12" class="<?php echo(LABEL_COL); ?>">Error Message</label>
				<div class="col-12"><textarea ckeditor-basic name="field_error_message" id="field_error_message" ng-model="params.error_message.value" class="form-control" data-default="There was an error sending your message."></textarea></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Contact Information</legend>

			<div class="form-row mb-2">
				<label for="field_title_info" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_title_info" id="field_title_info" ng-model="params.title_info.value" class="form-control" data-default="Contact Information" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_title_heading_level_info" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_title_heading_level_info", "params.title_heading_level_info.value", "h3", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_layout" class="<?php echo(LABEL_COL); ?>">Layout</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_layout", "params.layout.value", "vertical", ["vertical" => "Vertical", "horizontal" => "Horizontal"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_icon_size_info" class="<?php echo(LABEL_COL); ?>">Icon Size</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_icon_size_info", "params.icon_size_info.value", "2x", ["1x" => "1x", "lg" => "Large", "2x" => "2x", "3x" => "3x", "4x" => "4x", "5x" => "5x"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_phone_numbers_icon" class="<?php echo(LABEL_COL); ?>">Phone Number Icon</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fa-fw fa-lg {{params.phone_numbers_icon.value}}" aria-hidden="true"></em></span>
					</div>
					<select name="field_phone_numbers_icon" id="field_phone_numbers_icon" ng-model="params.phone_numbers_icon.value" class="form-control custom-select" data-default="fa-phone fas" ng-options="v.value as v.text for (k, v) in icons">
						<option value="">Choose Icon</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_phone_numbers" class="<?php echo(LABEL_COL); ?>">Phone Number(s)</label>
				<div class="<?php echo(FIELD_COL); ?>"><textarea name="field_phone_numbers" id="field_phone_numbers" ng-model="params.phone_numbers.value" class="form-control" class="short-input"></textarea></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_hours_icon" class="<?php echo(LABEL_COL); ?>">Hours Of Operation Icon</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fa-fw fa-lg {{params.hours_icon.value}}" aria-hidden="true"></em></span>
					</div>
					<select name="field_hours_icon" id="field_hours_icon" ng-model="params.hours_icon.value" class="form-control custom-select" data-default="fa-clock far" ng-options="v.value as v.text for (k, v) in icons">
						<option value="">Choose Icon</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_hours" class="<?php echo(LABEL_COL); ?>">Hours Of Operation</label>
				<div class="<?php echo(FIELD_COL); ?>"><textarea name="field_hours" id="field_hours" ng-model="params.hours.value" class="form-control" class="short-input"></textarea></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_address_icon" class="<?php echo(LABEL_COL); ?>">Address Icon</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fa-fw fa-lg {{params.address_icon.value}}" aria-hidden="true"></em></span>
					</div>
					<select name="field_address_icon" id="field_address_icon" ng-model="params.address_icon.value" class="form-control custom-select" data-default="fa-map-marker-alt fas" ng-options="v.value as v.text for (k, v) in icons">
						<option value="">Choose Icon</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_address_info" class="<?php echo(LABEL_COL); ?>">Address</label>
				<div class="<?php echo(FIELD_COL); ?>"><textarea name="field_address_info" id="field_address_info" ng-model="params.address_info.value" class="form-control" class="short-input"></textarea></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Social Networks</legend>

			<div class="form-row mb-2">
				<label for="field_title_social" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_title_social" id="field_title_social" ng-model="params.title_social.value" class="form-control" data-default="Follow Us" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_title_heading_level_social" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_title_heading_level_social", "params.title_heading_level_social.value", "h3", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_icon_size_social" class="<?php echo(LABEL_COL); ?>">Icon Size</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_icon_size_social", "params.icon_size_social.value", "2x", ["1x" => "1x", "lg" => "Large", "2x" => "2x", "3x" => "3x", "4x" => "4x", "5x" => "5x"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_facebook" class="<?php echo(LABEL_COL); ?>">Facebook Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
    					<span class="input-group-text"><em class="fab fa-fw fa-lg fa-facebook-square" aria-hidden="true"></em></span>
  					</div>
  					<input type="url" name="field_facebook" id="field_facebook" ng-model="params.facebook.value" class="form-control" placeholder="https://facebook.com" />
  				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_twitter" class="<?php echo(LABEL_COL); ?>">Twitter Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-twitter-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_twitter" id="field_twitter" ng-model="params.twitter.value" class="form-control" placeholder="https://twitter.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_gplus" class="<?php echo(LABEL_COL); ?>">Google Plus Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-google-plus-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_gplus" id="field_gplus" ng-model="params.gplus.value" class="form-control" placeholder="https://plus.google.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_flickr" class="<?php echo(LABEL_COL); ?>">Flickr Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-flickr" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_flickr" id="field_flickr" ng-model="params.flickr.value" class="form-control" placeholder="https://flickr.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_pinterest" class="<?php echo(LABEL_COL); ?>">Pinterest Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-pinterest-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_pinterest" id="field_pinterest" ng-model="params.pinterest.value" class="form-control" placeholder="https://pinterest.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_youtube" class="<?php echo(LABEL_COL); ?>">YouTube Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-youtube-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_youtube" id="field_youtube" ng-model="params.youtube.value" class="form-control" placeholder="https://youtube.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_linkedin" class="<?php echo(LABEL_COL); ?>">LinkedIn Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-linkedin" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_linkedin" id="field_linkedin" ng-model="params.linkedin.value" class="form-control" placeholder="https://linkedin.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_instagram" class="<?php echo(LABEL_COL); ?>">Instagram Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-instagram" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_instagram" id="field_instagram" ng-model="params.instagram.value" class="form-control" placeholder="https://instagram.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_etsy" class="<?php echo(LABEL_COL); ?>">Etsy Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-etsy" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_etsy" id="field_etsy" ng-model="params.etsy.value" class="form-control" placeholder="https://etsy.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_tumblr" class="<?php echo(LABEL_COL); ?>">Tumblr Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-tumblr-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="field_tumblr" id="field_tumblr" ng-model="params.tumblr.value" class="form-control" placeholder="https://tumblr.com" />
				</div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Google Map Settings</legend>

			<div class="form-row mb-2">
				<label for="field_title_map" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_title_map" id="field_title_map" ng-model="params.title_map.value" class="form-control" data-default="" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_title_heading_level_map" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_title_heading_level_map", "params.title_heading_level_map.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_api_key" class="<?php echo(LABEL_COL); ?>">API Key</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_api_key" id="field_api_key" ng-model="params.api_key.value" class="form-control" data-default="AIzaSyB4idrXhKkepF-nlDSGwJQ8ZA5OsuK_1V8" /></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Map Pin</legend>

			<div class="form-row mb-2">
				<label for="field_address_map" class="<?php echo(LABEL_COL); ?>">Address</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_address_map" id="field_address_map" ng-model="params.address_map.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_latitude" class="<?php echo(LABEL_COL); ?>">Latitude</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_latitude" id="field_latitude" ng-model="params.latitude.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_longitude" class="<?php echo(LABEL_COL); ?>">Longitude</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_longitude" id="field_longitude" ng-model="params.longitude.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_bubble_text" class="<?php echo(LABEL_COL); ?>">Bubble Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_bubble_text" id="field_bubble_text" ng-model="params.bubble_text.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_zoom" class="<?php echo(LABEL_COL); ?>">Default Zoom</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" min="0" max="23" step="1" name="field_zoom" id="field_zoom" ng-model="params.zoom.value" class="form-control" data-default="13" /></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Street View</legend>

			<div class="form-row mb-2">
				<label for="field_initial_view" class="<?php echo(LABEL_COL); ?>">Initial View</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_initial_view", "params.initial_view.value", "map", ["map" => "Map", "sv" => "Street View"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_sv_heading" class="<?php echo(LABEL_COL); ?>">Street View Heading</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_sv_heading" id="field_sv_heading" ng-model="params.sv_heading.value" class="form-control" data-default="0" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_sv_pitch" class="<?php echo(LABEL_COL); ?>">Street View Pitch</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_sv_pitch" id="field_sv_pitch" ng-model="params.sv_pitch.value" class="form-control" data-default="0" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_sv_zoom" class="<?php echo(LABEL_COL); ?>">Street View Zoom</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_sv_zoom" id="field_sv_zoom" ng-model="params.sv_zoom.value" class="form-control" data-default="1" /></div>
			</div>
		</fieldset>
	</div>
</div>
