<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Content List Settings</legend>

			<div class="form-row mb-2">
				<label for="field_heading_level" class="<?php echo(LABEL_COL); ?>">Content Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_heading_level", "params.title_heading_level.value", "h1", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_module_class" id="field_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_category_id" class="<?php echo(LABEL_COL); ?>">Content Category</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_category_id" id="field_category_id" ng-model="params.category_id.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in categories">
						<option value="">Any Category</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_content_type_id" class="<?php echo(LABEL_COL); ?>">Content Type</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_content_type_id" id="field_content_type_id" ng-model="params.content_type_id.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in content_types">
						<option value="">Any Content Type</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_tag_ids" class="<?php echo(LABEL_COL); ?>">Tags</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" class="tokeninput" name="field_tag_ids" id="field_tag_ids" data-source="/ajax/get_tokens/page_tag" data-allow_new="0" data-options="{'theme': 'facebook', 'preventDuplicates': '1'}" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_tag_logic" class="<?php echo(LABEL_COL); ?>">Tag Logic</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_tag_logic", "params.tag_logic.value", "OR", ["OR" => "Any tag can match", "AND" => "All tags must match"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_ordering" class="<?php echo(LABEL_COL); ?>">Ordering</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_ordering" id="field_ordering" ng-model="params.ordering.value" class="form-control custom-select" data-default="newest_created" required>
						<option value="">Choose Sort Order</option>
						<option value="newest_created">Newest First (date created)</option>
						<option value="oldest_created">Oldest First (date created)</option>
						<option value="newest_modified">Newest First (date modified)</option>
						<option value="oldest_modified">Oldest First (date modified)</option>
						<option value="alpha">Alphabetical</option>
						<option value="random">Random</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_layout" class="<?php echo(LABEL_COL); ?>">Layout</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_layout", "params.layout.value", "normal", ["normal" => "Normal", "alpha" => "Grouped Alphabetically", "year" => "Grouped By Year"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_search_legend" class="<?php echo(LABEL_COL); ?>">Search Box Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_search_legend" id="field_search_legend" ng-model="params.search_legend.value" class="form-control" data-default="Search Our Website" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_ignore_searchable" class="<?php echo(LABEL_COL); ?>">Ignore Per-Page Searchable Setting</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_ignore_searchable", "params.ignore_searchable.value", 0); ?></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Featured Articles</legend>

			<div class="form-row mb-2">
				<label for="field_num_featured" class="<?php echo(LABEL_COL); ?>">Number of Articles</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_num_featured" id="field_num_featured" ng-model="params.num_featured.value" class="form-control" min="0" step="1" data-default="1" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_num_columns_featured" class="<?php echo(LABEL_COL); ?>">Number of Columns</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_num_columns_featured" id="field_num_columns_featured" ng-model="params.num_columns_featured.value" class="form-control" min="1" max="4" step="1" data-default="1" required /></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Regular Articles</legend>

			<div class="form-row mb-2">
				<label for="field_num_articles" class="<?php echo(LABEL_COL); ?>">Number of Articles</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_num_articles" id="field_num_articles" ng-model="params.num_articles.value" class="form-control" min="0" step="1" data-default="0" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_num_columns" class="<?php echo(LABEL_COL); ?>">Number of Columns</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_num_columns" id="field_num_columns" ng-model="params.num_columns.value" class="form-control" min="1" max="4" step="1" data-default="3" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_per_page" class="<?php echo(LABEL_COL); ?>">Number of Articles Per Page</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_per_page" id="field_per_page" ng-model="params.per_page.value" class="form-control" min="0" step="1" data-default="10" required /></div>
			</div>
		</fieldset>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Content Display Settings</legend>

			<div class="form-row mb-2">
				<label for="field_show_title" class="<?php echo(LABEL_COL); ?>">Content Title</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_show_title", "params.show_title.value", "below", ["no" => "Hide Title", "above" => "Above Image", "below" => "Below Image"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_date" class="<?php echo(LABEL_COL); ?>">Content Date</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_date", "params.show_date.value", 0, "Show", "Hide"); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_text" class="<?php echo(LABEL_COL); ?>">Content Preview</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_text", "params.show_text.value", 1, "Show", "Hide"); ?></div>
			</div>

			<div class="form-row mb-2" ng-show="params.show_text.value == 1">
				<label for="field_character_limit" class="<?php echo(LABEL_COL); ?>">Preview Limit</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_character_limit" id="field_character_limit" ng-model="params.character_limit.value" class="form-control" min="0" step="1" data-default="300" /> characters</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_do_not_link" class="<?php echo(LABEL_COL); ?>">Do Not Link Articles</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_do_not_link", "params.do_not_link.value", 0, "Do Not Link", "Link"); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_always_show_readmore" class="<?php echo(LABEL_COL); ?>">Always Show Read More Buttons</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_always_show_readmore", "params.always_show_readmore.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_never_show_readmore" class="<?php echo(LABEL_COL); ?>">Never Show Read More Buttons</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_never_show_readmore", "params.never_show_readmore.value", 0, "Never Show", "Show As Needed"); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_read_more_text" class="<?php echo(LABEL_COL); ?>">Read More Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_read_more_text" id="field_read_more_text" ng-model="params.read_more_text.value" class="form-control" data-default="Continue Reading <em class=&quot;fa fa-arrow-circle-right&quot;></em>" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_strip_tags" class="<?php echo(LABEL_COL); ?>">Remove HTML</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_strip_tags", "params.strip_tags.value", "some", ["no" => "No", "some" => "Yes (keep images)", "all" => "Yes (all tags)"]); ?>
				</div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Notes:</legend>
			<ul>
				<li>Setting "Number of Articles" to zero will display all articles.</li>
				<li>Setting "Number of Articles Per Page" to zero will disable pagination.</li>
				<li>Setting "Character Limit" to zero will display the entire article.</li>
				<li>"Keep Formatting" will preserve any existing formatting applied to the image rather than processing it.</li>
			</ul>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Image Settings (Featured Articles)</legend>
			<div class="alert alert-info">The first image in each article can be extracted and shown above the article.</div>

			<div class="form-row mb-2">
				<label for="field_show_image_featured" class="<?php echo(LABEL_COL); ?>">Show First Image</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_image_featured", "params.show_image_featured.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_image_raw_featured" class="<?php echo(LABEL_COL); ?>">Keep Formatting</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_image_raw_featured", "params.image_raw_featured.value", 0); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_image_width_featured" class="<?php echo(LABEL_COL); ?>">Image Width (px)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_image_width_featured" id="field_image_width_featured" ng-model="params.image_width_featured.value" class="form-control" data-default="1200" min="0" step="1" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_image_height_featured" class="<?php echo(LABEL_COL); ?>">Image Height (px)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_image_height_featured" id="field_image_height_featured" ng-model="params.image_height_featured.value" class="form-control" data-default="900" min="0" step="1" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_crop_featured" class="<?php echo(LABEL_COL); ?>">Crop Position</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_crop_featured" id="field_crop_featured" ng-model="params.crop_featured.value" class="form-control custom-select" data-default="center:center">
						<option value="">Do Not Crop</option>
						<option value="top:left">Top Left Corner</option>
						<option value="top:center">Top Edge, Centered Vertically</option>
						<option value="center:left">Centered Horizontally, Left Edge</option>
						<option value="center:center">Center of Image</option>
					</select>
				</div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Image Settings (Regular Articles)</legend>
			<div class="alert alert-info">The first image in each article can be extracted and shown above the article.</div>

			<div class="form-row mb-2">
				<label for="field_show_image" class="<?php echo(LABEL_COL); ?>">Show First Image</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_image", "params.show_image.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_image_raw" class="<?php echo(LABEL_COL); ?>">Keep Formatting</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_image_raw", "params.image_raw.value", 0); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_image_width" class="<?php echo(LABEL_COL); ?>">Image Width (px)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_image_width" id="field_image_width" ng-model="params.image_width.value" class="form-control" data-default="400" min="0" step="1" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_image_height" class="<?php echo(LABEL_COL); ?>">Image Height (px)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_image_height" id="field_image_height" ng-model="params.image_height.value" class="form-control" data-default="300" min="0" step="1" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_crop" class="<?php echo(LABEL_COL); ?>">Crop Position</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_crop" id="field_crop" ng-model="params.crop.value" class="form-control custom-select" data-default="center:center">
						<option value="">Do Not Crop</option>
						<option value="top:left">Top Left Corner</option>
						<option value="top:center">Top Edge, Centered Vertically</option>
						<option value="center:left">Centered Horizontally, Left Edge</option>
						<option value="center:center">Center of Image</option>
					</select>
				</div>
			</div>
		</fieldset>
	</div>
</div>
