<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Document List Settings</legend>

			<div class="form-row mb-2">
				<label for="field_heading_level" class="<?php echo(LABEL_COL); ?>">Content Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_title_heading_level", "params.title_heading_level.value", "p", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "p" => "Plain"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_module_class" id="field_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_category_id" class="<?php echo(LABEL_COL); ?>">Document Category</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_category_id" id="field_category_id" ng-model="params.category_id.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in categories">
						<option value="">Any Category</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_ordering" class="<?php echo(LABEL_COL); ?>">Ordering</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="field_ordering" id="field_ordering" ng-model="params.ordering.value" class="form-control custom-select" data-default="newest_created" required>
						<option value="">Choose Sort Order</option>
						<option value="newest_created">Newest First (date created)</option>
						<option value="oldest_created">Oldest First (date created)</option>
						<option value="newest_modified">Newest First (date modified)</option>
						<option value="oldest_modified">Oldest First (date modified)</option>
						<option value="alpha">Alphabetical</option>
						<option value="random">Random</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_layout" class="<?php echo(LABEL_COL); ?>">Layout</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("field_layout", "params.layout.value", "normal", ["normal" => "Normal", "alpha" => "Grouped Alphabetically", "year" => "Grouped By Year"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="field_search_legend" class="<?php echo(LABEL_COL); ?>">Search Box Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="field_search_legend" id="field_search_legend" ng-model="params.search_legend.value" class="form-control" data-default="Search Documents" /></div>
			</div>

			<div class="form-row mb-2" ng-show="params.show_text.value == 1">
				<label for="field_character_limit" class="<?php echo(LABEL_COL); ?>">Description Limit</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_character_limit" id="field_character_limit" ng-model="params.character_limit.value" class="form-control" min="0" step="1" data-default="300" /></div> characters
			</div>

			<div class="form-row mb-2">
				<label for="field_num_columns" class="<?php echo(LABEL_COL); ?>">Number of Columns</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_num_columns" id="field_num_columns" ng-model="params.num_columns.value" class="form-control" min="1" max="4" step="1" data-default="3" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_per_page" class="<?php echo(LABEL_COL); ?>">Number of Documents Per Page</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="field_per_page" id="field_per_page" ng-model="params.per_page.value" class="form-control" min="0" step="1" data-default="12" required /></div>
			</div>
		</fieldset>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>&nbsp;</legend>
			<div class="form-row mb-2">
				<label for="field_show_preview" class="<?php echo(LABEL_COL); ?>">Show PDF Previews</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_preview", "params.show_preview.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_categories" class="<?php echo(LABEL_COL); ?>">Show Category List</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_categories", "params.show_categories.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_title" class="<?php echo(LABEL_COL); ?>">Show Title</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_title", "params.show_title.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_date" class="<?php echo(LABEL_COL); ?>">Show Date</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_date", "params.show_date.value", 0); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_category" class="<?php echo(LABEL_COL); ?>">Show Category</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_category", "params.show_category.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_icons" class="<?php echo(LABEL_COL); ?>">Show Icons</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_icons", "params.show_icons.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_text" class="<?php echo(LABEL_COL); ?>">Show Description</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_text", "params.show_text.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="field_show_uncategorized" class="<?php echo(LABEL_COL); ?>">Show Uncategorized Documents</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("field_show_uncategorized", "params.show_uncategorized.value", 1); ?></div>
			</div>
		</fieldset>
	</div>
</div>