<h1 class="text-center"><?php echo(PRODUCT_NAME); ?> Installation</h1>

<?php
if(INSTALLED)
{
	?><div class="alert alert-danger">It appears that <?php echo(PRODUCT_NAME); ?> has already been installed!</div><?php
}

$this->load->view("common/message", array("messages" => $messages, "errors" => (count($fatal_errors) ? $fatal_errors : $errors)));

if(INSTALLED || count($fatal_errors))
{
	?><div class="alert alert-danger"><?php echo(PRODUCT_NAME); ?> can not be installed until these issues are resolved.</div><?php
}
else
{
	?>
	<form name="install" id="install" method="post" action="/install/go" enctype="multipart/form-data" class="nvForm">
		<?php csrf(); ?>
		<div class="row">
			<div class="<?php echo(TWO_COL); ?>">
				<fieldset>
					<legend>Website Information</legend>

					<div class="form-row mb-2">
						<label for="name" class="<?php echo(LABEL_COL); ?>">Website Name</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "name",
							              "id"          => "name",
							              "value"       => ($this->input->post("name") ? $this->input->post("name") : ""),
							              "placeholder" => 'Website Name',
							              "required"	=> "required",
							              "class" 		=> "form-control",
							              "autofocus" 	=> "autofocus"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="fname" class="<?php echo(LABEL_COL); ?>">First Name</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "fname",
							              "id"          => "fname",
							              "value"       => ($this->input->post("fname") ? $this->input->post("fname") : ""),
							              "placeholder" => 'First Name',
							              "required"	=> "required",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="lname" class="<?php echo(LABEL_COL); ?>">Last Name</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "lname",
							              "id"          => "lname",
							              "value"       => ($this->input->post("lname") ? $this->input->post("lname") : ""),
							              "placeholder" => 'Last Name',
							              "required"	=> "required",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="company" class="<?php echo(LABEL_COL); ?>">Company Name</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "company",
							              "id"          => "company",
							              "value"       => ($this->input->post("company") ? $this->input->post("company") : ""),
							              "placeholder" => 'Company Name',
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="email" class="<?php echo(LABEL_COL); ?>">Email Address</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "email",
							              "id"          => "email",
							              "value"       => ($this->input->post("email") ? $this->input->post("email") : ""),
							              "placeholder" => 'E-mail Address',
							              "type"		=> "email",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>
				</fieldset>
			</div>

			<div class="<?php echo(TWO_COL); ?>">
				<fieldset>
					<legend>Database Information</legend>

					<div class="form-row mb-2">
						<label for="db_server" class="<?php echo(LABEL_COL); ?>">Database Server</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "db_server",
							              "id"          => "db_server",
							              "value"       => ($this->input->post("db_server") ? $this->input->post("db_server") : "localhost"),
							              "placeholder" => 'Database Server',
							              "required"	=> "required",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="db_name" class="<?php echo(LABEL_COL); ?>">Database Name</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "db_name",
							              "id"          => "db_name",
							              "value"       => ($this->input->post("db_name") ? $this->input->post("db_name") : ""),
							              "placeholder" => 'Database Name',
							              "required"	=> "required",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="db_username" class="<?php echo(LABEL_COL); ?>">Database Username</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "db_username",
							              "id"          => "db_username",
							              "value"       => ($this->input->post("db_username") ? $this->input->post("db_username") : ""),
							              "placeholder" => 'Database Username',
							              "required"	=> "required",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>

					<div class="form-row mb-2">
						<label for="db_password" class="<?php echo(LABEL_COL); ?>">Database Password</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "db_password",
							              "id"          => "db_password",
							              "value"       => ($this->input->post("db_password") ? $this->input->post("db_password") : ""),
							              "placeholder" => 'Database Password',
							              "required"	=> "required",
							              "class" 		=> "form-control",
							              "type"		=> "password"
							            ));
							?>
					</div>
				</fieldset>
			</div>

			<div class="<?php echo(TWO_COL); ?>">
				<fieldset class="accordion">
					<legend>Template Options</legend>

					<div>
						<div class="form-row mb-2">
							<label for="template_id" class="<?php echo(LABEL_COL); ?>">Template</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralBasicSelectWidget("template_id", ($this->input->post("template_id") ? $this->input->post("template_id") : "kasper"), "form-control custom-select");

								foreach($templates as $template)
								{
									$wgt->AddOption($template, ucwords($template));
								}
								$wgt->Create();
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="theme" class="<?php echo(LABEL_COL); ?>">Theme</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralBasicSelectWidget("theme", ($this->input->post("theme") ? $this->input->post("theme") : "monochrome"), "form-control custom-select");
								$wgt->SetAttribute("required", "required");

								foreach($themes as $theme)
								{
									$wgt->AddOption($theme);
								}
								$wgt->Create();
								?>
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="font" class="<?php echo(LABEL_COL); ?>">Font Package</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralBasicSelectWidget("font", ($this->input->post("font") ? $this->input->post("font") : "Open Sans"), "form-control custom-select");
								$wgt->SetAttribute("required", "required");

								foreach($fonts as $font)
								{
									$wgt->AddOption($font);
								}
								$wgt->Create();
								?>
							</div>
						</div>
					</div>
				</fieldset>
			</div>

			<div class="<?php echo(TWO_COL); ?>">
				<fieldset class="accordion">
					<legend>Colour Overrides</legend>

					<div>
						<div class="alert alert-info">You can override the selected theme's default colours by specifying values here.
						Empty values will use colours from the selected theme.
						Any valid CSS colour may be used.</div>

						<div class="form-row mb-2">
							<label class="<?php echo(LABEL_COL); ?>">Company Logo</label>
							<span>Upload your logo and we'll show you the colour codes used.</span>
						</div>

						<div class="form-row mb-2">
							<label for="logo_image" class="<?php echo(LABEL_COL); ?>">Choose File</label>
							<div class="<?php echo(FIELD_COL); ?>"><input type="file" name="logo_image" id="logo_image" /></div>
						</div>

						<div class="form-row mb-2 colour-analysis-result">
							<label class="<?php echo(LABEL_COL); ?>"></label><span id="colour-analysis"></span>
						</div>

						<div class="form-row mb-2 colour-analysis-result">
							<label class="<?php echo(LABEL_COL); ?>"></label><span id="colour-analysis-code"></span>
						</div>

						<div class="form-row mb-2">
							<label for="colour1" class="<?php echo(LABEL_COL); ?>">Primary Colour</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "colour1",
								              "id"          => "colour1",
								              "placeholder" => "Use colour from selected theme.",
								              "value"       => $this->input->post("colour1"),
							              	  "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="colour2" class="<?php echo(LABEL_COL); ?>">Secondary Colour</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "colour2",
								              "id"          => "colour2",
								              "placeholder" => "Use colour from selected theme.",
								              "value"       => $this->input->post("colour2"),
							             	  "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>
						<div class="form-row mb-2">
							<label for="colour3" class="<?php echo(LABEL_COL); ?>">Third Colour</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "colour3",
								              "id"          => "colour3",
								              "placeholder" => "Use colour from selected theme.",
								              "value"       => $this->input->post("colour3"),
							              	  "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>
					</div>
				</fieldset>
			</div>

			<div class="<?php echo(TWO_COL); ?>">
				<fieldset class="accordion">
					<legend>Common Pages</legend>

					<div>
						<div class="alert alert-info">Installation will start you off with one site, one domain, one user, and one page.
							The following common pages can also be created automatically for you.</div>

						<div class="form-row mb-2">
							<label for="create_search_checkbox" class="<?php echo(LABEL_COL); ?>">Search Results Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_search", ($this->input->post("create_search") ? $this->input->post("create_search") : 1)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_documents_checkbox" class="<?php echo(LABEL_COL); ?>">Documents Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_documents", ($this->input->post("create_documents") ? $this->input->post("create_documents") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_login_checkbox" class="<?php echo(LABEL_COL); ?>">Login Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_login", ($this->input->post("create_login") ? $this->input->post("create_login") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_registration_checkbox" class="<?php echo(LABEL_COL); ?>">Registration Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_registration", ($this->input->post("create_registration") ? $this->input->post("create_registration") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_gallery_checkbox" class="<?php echo(LABEL_COL); ?>">Gallery Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_gallery", ($this->input->post("create_gallery") ? $this->input->post("create_gallery") : 1)); ?></div>
						</div>
						<div class="form-row mb-2">
							<label for="create_contact_checkbox" class="<?php echo(LABEL_COL); ?>">Contact Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_contact", ($this->input->post("create_contact") ? $this->input->post("create_contact") : 1)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_portfolio_checkbox" class="<?php echo(LABEL_COL); ?>">Portfolio Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_portfolio", ($this->input->post("create_portfolio") ? $this->input->post("create_portfolio") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_testimonials_checkbox" class="<?php echo(LABEL_COL); ?>">Testimonials Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_testimonials", ($this->input->post("create_testimonials") ? $this->input->post("create_testimonials") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_directory_checkbox" class="<?php echo(LABEL_COL); ?>">Business Directory Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_directory", ($this->input->post("create_directory") ? $this->input->post("create_directory") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="create_shop_checkbox" class="<?php echo(LABEL_COL); ?>">Shop Page</label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("create_shop", ($this->input->post("create_shop") ? $this->input->post("create_shop") : 0)); ?></div>
						</div>

						<div class="form-row mb-2">
							<label for="additional_pages" class="<?php echo(LABEL_COL); ?>">Extra Blank Pages</label>
							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								echo form_input(array(
								              "name"        => "additional_pages",
								              "id"          => "additional_pages",
								              "value"       => ($this->input->post("additional_pages") ? $this->input->post("additional_pages") : 0),
								              "placeholder" => 'Create Blank Pages',
								              "type"		=> "number",
								              "min"			=> 0,
							             	  "class" 		=> "form-control"
								            ));
								?>
							</div>
						</div>
					</div>
				</fieldset>
			</div>

			<div class="<?php echo(TWO_COL); ?>">
				<fieldset class="accordion">
					<legend>Other Information (Optional)</legend>

					<div>
						<div class="alert alert-info">This information will allow the installer to configure parts of your website automatically.</div>

						<div class="form-row mb-2">
							<label for="phone_numbers" class="<?php echo(LABEL_COL); ?>">Phone Number(s)</label>
							<div class="<?php echo(FIELD_COL); ?>"><textarea name="phone_numbers" id="phone_numbers" class="form-control"><?php echo(($this->input->post("phone_numbers") ? $this->input->post("phone_numbers") : "")); ?></textarea></div>
						</div>

						<div class="form-row mb-2">
							<label for="hours" class="<?php echo(LABEL_COL); ?>">Hours of Operation</label>
							<div class="<?php echo(FIELD_COL); ?>"><textarea name="hours" id="hours" class="form-control"><?php echo(($this->input->post("hours") ? $this->input->post("hours") : "Mon-Fri: \nSat: \nSun: ")); ?></textarea></div>
						</div>

						<div class="form-row mb-2">
							<label for="address" class="<?php echo(LABEL_COL); ?>">Address</label>
							<div class="<?php echo(FIELD_COL); ?>"><textarea name="address" id="address" class="form-control"><?php echo(($this->input->post("address") ? $this->input->post("address") : "")); ?></textarea></div>
						</div>
					</div>
				</fieldset>
			</div>

			<div class="<?php echo(TWO_COL); ?>">
				<fieldset class="accordion">
					<legend>Social Networks (Optional)</legend>

					<div>
						<div class="alert alert-info">This information will allow the installer to configure parts of your website automatically.</div>

						<div class="form-row mb-2">
							<label for="facebook" class="<?php echo(LABEL_COL); ?>">Facebook Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-facebook-square" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="facebook" id="facebook" value="<?php echo(($this->input->post("facebook") ? $this->input->post("facebook") : "")); ?>" placeholder="https://facebook.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="twitter" class="<?php echo(LABEL_COL); ?>">Twitter Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-twitter-square" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="twitter" id="twitter" value="<?php echo(($this->input->post("twitter") ? $this->input->post("twitter") : "")); ?>" placeholder="https://twitter.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="gplus" class="<?php echo(LABEL_COL); ?>">Google Plus Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-google-plus-square" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="gplus" id="gplus" value="<?php echo(($this->input->post("gplus") ? $this->input->post("gplus") : "")); ?>" placeholder="https://plus.google.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="flickr" class="<?php echo(LABEL_COL); ?>">Flickr Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-flickr" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="flickr" id="flickr" value="<?php echo(($this->input->post("flickr") ? $this->input->post("flickr") : "")); ?>" placeholder="https://flickr.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="pinterest" class="<?php echo(LABEL_COL); ?>">Pinterest Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-pinterest-square" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="pinterest" id="pinterest" value="<?php echo(($this->input->post("pinterest") ? $this->input->post("pinterest") : "")); ?>" placeholder="https://pinterest.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="youtube" class="<?php echo(LABEL_COL); ?>">YouTube Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-youtube-square" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="youtube" id="youtube" value="<?php echo(($this->input->post("youtube") ? $this->input->post("youtube") : "")); ?>" placeholder="https://youtube.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="linkedin" class="<?php echo(LABEL_COL); ?>">LinkedIn Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-linkedin" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="linkedin" id="linkedin" value="<?php echo(($this->input->post("linkedin") ? $this->input->post("linkedin") : "")); ?>" placeholder="https://linkedin.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="instagram" class="<?php echo(LABEL_COL); ?>">Instagram Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-instagram" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="instagram" id="instagram" value="<?php echo(($this->input->post("instagram") ? $this->input->post("instagram") : "")); ?>" placeholder="https://instagram.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="etsy" class="<?php echo(LABEL_COL); ?>">Etsy Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-etsy" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="etsy" id="etsy" value="<?php echo(($this->input->post("etsy") ? $this->input->post("etsy") : "")); ?>" placeholder="https://etsy.com" class="form-control" />
							</div>
						</div>

						<div class="form-row mb-2">
							<label for="tumblr" class="<?php echo(LABEL_COL); ?>">Tumblr Profile</label>
							<div class="<?php echo(FIELD_COL); ?> input-group">
								<div class="input-group-prepend">
									<span class="input-group-text"><em class="fab fa-fw fa-lg fa-tumblr-square" aria-hidden="true"></em></span>
								</div>
								<input type="url" name="tumblr" id="tumblr" value="<?php echo(($this->input->post("tumblr") ? $this->input->post("tumblr") : "")); ?>" placeholder="https://tumblr.com" class="form-control" />
							</div>
						</div>
					</div>
				</fieldset>
			</div>
		</div>

		<div class="text-center">
			<br />
            <button type="submit" class="btn btn-primary">Install <em class="fas fa-arrow-right" aria-hidden="true"></em></button>
        </div>
	</form>
	<?php
}
?>

<script>
jQuery(window).on("load", function()
{
	jQuery("#logo_image").change(function()
	{
		var result = jQuery("#colour-analysis");
		result.html('<em class="fas fa-fw fa-spin fa-spinner fa-2x" aria-hidden="true"></em> Analyzing Image...');
		jQuery(".colour-analysis-result").slideDown(500);

		var formData = new FormData();

		try
		{
			formData.append("image", document.getElementById("logo_image").files[0]);
		}
		catch(e){}

		$.ajax(
		{
			url: '/functions/colour_analysis',
			type: 'POST',
			data: formData,
			processData: false,
			contentType: false
		}).done(function(data, textStatus, jqXHR)
		{
			result.siblings("label").eq(0).html("Colour Breakdown");

			colours = data;
			html 	= "";

			for(i=0; i<colours.length; i++)
			{
				colour 	= colours[i];
				// rgb 	= 'rgb(' + colour["red"] + ',' + colour["green"] + ',' + colour["blue"] + ')';
				hex 	= colour["hex"];
				html 	+= '<span class="colour-analysis-preview" style="background: ' + hex + ';" onclick="colour_preview(this, \'' + hex + '\')">' + (i+1) + '</span>';
			}
			result.html(html);
			jQuery(".colour-analysis-preview").eq(0).click();
		}).fail(function(jqXHR, textStatus, errorThrown)
		{
			result.html("An Error Occurred: " + errorThrown);
		});
	});

	colour_preview = function(obj, hex)
	{
		jQuery('#colour-analysis-code').html("Selected Colour Code: " + hex);
		jQuery('.colour-analysis-preview').removeClass('colour-analysis-clicked');
		jQuery(obj).addClass('colour-analysis-clicked');
	}

	jQuery("#db_name").change(function()
	{
		if(jQuery("#db_username").val().trim() == "")
		{
			jQuery("#db_username").val(jQuery("#db_name").val());
		}
	});
});
</script>
