<div id="module_<?php echo($module_instance_id); ?>" class="module accessibility-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>
	<a href="#" onclick="accessibility_open(); return false;" onkeypress="this.click(); return false;" class="accessibility-open" title="<?php echo(strip_tags($text_customize)); ?>"><em class="fa-fw <?php echo($icon); ?>" aria-hidden="true"></em> <?php echo($text_customize); ?></a><a href="https://translate.google.com/translate?hl=en&sl=en&tl=fr&u=<?php echo(urlencode(current_url())); ?>" target="_blank" class="accessibility-translate" title="<?php echo(strip_tags($text_language)); ?>"><em class="fa-fw <?php echo($language_icon); ?>" aria-hidden="true"></em> <?php echo($text_language); ?></a>

	<script>
		var accessibility = "";

		jQuery(document).ready(function()
		{
			accessibility = getCookie("accessibility");

			if(accessibility == "")
			{
				accessibility = {
					font_size: 1,
					colour: "",
					background: "",
					font: ""
				};
			}
			else
			{
				accessibility = JSON.parse(accessibility);
			}

			accessibility["font_size"] 	= (accessibility["font_size"] 	!= "" ? accessibility["font_size"] 	: 1);
			accessibility["colour"] 	= (accessibility["colour"] 		!= "" ? accessibility["colour"] 	: "");
			accessibility["background"] = (accessibility["background"] 	!= "" ? accessibility["background"] : "");
			accessibility["font"] 		= (accessibility["font"] 		!= "" ? accessibility["font"] 		: "");

			if(accessibility["font_size"] == "0.5")
			{
				jQuery("#accessibility-font-size-t").prop("checked", true);
			}
			else if(accessibility["font_size"] == "0.75")
			{
				jQuery("#accessibility-font-size-s").prop("checked", true);
			}
			else if(accessibility["font_size"] == "1.5")
			{
				jQuery("#accessibility-font-size-l").prop("checked", true);
			}
			else if(accessibility["font_size"] == "2")
			{
				jQuery("#accessibility-font-size-xl").prop("checked", true);
			}
			else
			{
				jQuery("#accessibility-font-default").prop("checked", true);
			}

			if(accessibility["font"])
			{
				jQuery("#accessibility-font-family").val(accessibility["font"]);
			}

			if(accessibility["colour"] == "black")
			{
				jQuery("#accessibility-font-colour-black").prop("checked", true);
			}
			else if(accessibility["colour"] == "white")
			{
				jQuery("#accessibility-font-colour-white").prop("checked", true);
			}
			else
			{
				jQuery("#accessibility-font-colour-default").prop("checked", true);
			}

			if(accessibility["background"] == "black")
			{
				jQuery("#accessibility-background-black").prop("checked", true);
			}
			else if(accessibility["background"] == "white")
			{
				jQuery("#accessibility-background-white").prop("checked", true);
			}
			else
			{
				jQuery("#accessibility-background-default").prop("checked", true);
			}

			accessibility_set();

			jQuery(".accessibility-control").change(function()
			{
				accessibility_set();
			});

			jQuery("#accessibility-close").click(function()
			{
				jQuery("#accessibility-dialog").dialog("close");
			});

			jQuery("#accessibility-reset").click(function()
			{
				accessibility_reset();
			});
		});

		function accessibility_open()
		{
			jQuery("#accessibility-dialog").dialog(
			{
				title: "Customize Font and Colours",
				modal: true,
				width: jQuery(window).width() * 0.9,
				height: 600,
				maxHeight: jQuery(window).height() * 0.9
			});
		}

		function accessibility_reset()
		{
			// Reset font size to 1em.
			jQuery("body").css(
			{
		        "font-size": "1em"
		    });

			// Reset font family for anything with font family set.
		    jQuery("*").filter(function()
	        {
	        	return (jQuery(this).css('font-family') != "");
	        }).css(
			{
				"font-family" : ""
			});

			// Reset colour for anything with colour set.
		    jQuery("*").filter(function()
	        {
	        	return (jQuery(this).css('color') != "");
	        }).css(
			{
				"color" : ""
			});

			// Reset background colour for anything with background colour set.
		    jQuery("*").filter(function()
	        {
	        	return (jQuery(this).css('background-color') != "");
	        }).css(
			{
				"background-color" : ""
			});

			jQuery("#accessibility-font-size-default").prop("checked", true);
			jQuery("#accessibility-font-colour-default").prop("checked", true);
			jQuery("#accessibility-background-colour-default").prop("checked", true);
			jQuery("#accessibility-font-family").val("");

			accessibility = {
				font_size: 1,
				colour: "",
				background: "",
				font: ""
			};
			var d = new Date();
			d.setTime(d.getTime()+(7*24*60*60*1000));
			var expires = "expires="+d.toGMTString();
			document.cookie = "accessibility=" + JSON.stringify(accessibility) + "; " + expires + "; path=/;";
		}

		function accessibility_set()
		{
			accessibility["font_size"] 	= jQuery("input[name='accessibility-font-size']:checked").val();
			accessibility["colour"] 	= jQuery("input[name='accessibility-font-colour']:checked").val();
			accessibility["background"] = jQuery("input[name='accessibility-background-colour']:checked").val();
			accessibility["font"] 		= jQuery("#accessibility-font-family").val();

			if(accessibility["colour"] == "#ffffff" && accessibility["background"] == "#ffffff")
			{
				accessibility["background"] = "#000000";
				jQuery("#accessibility-background-colour-black").prop("checked", true);
			}
			else if(accessibility["colour"] == "#000000" && accessibility["background"] == "#000000")
			{
				accessibility["background"] = "#ffffff";
				jQuery("#accessibility-background-colour-white").prop("checked", true);
			}

			// Apply selected font size to the body.  Everything else will scale from there.
			jQuery("body").css(
			{
		        "font-size": accessibility["font_size"] + "em"
		    });

			// Reset font family for anything with font family set.
		    jQuery("*").filter(function()
	        {
	        	return (jQuery(this).css('font-family') != "");
	        }).css(
			{
				"font-family" : ""
			});

			// Reset colour for anything with colour set.
		    jQuery("*").filter(function()
	        {
	        	return (jQuery(this).css('color') != "");
	        }).css(
			{
				"color" : ""
			});

			// Reset background colour for anything with background colour set.
		    jQuery("*").filter(function()
	        {
	        	return (jQuery(this).css('background-color') != "");
	        }).css(
			{
				"background-color" : ""
			});

		    // Apply selected font to everything with font family set.
		    if(accessibility["font"] != "")
		    {
			    jQuery("*").filter(function()
	            {
	            	return (jQuery(this).css('font-family') != "");
	            }).css(
				{
			        "font-family": accessibility["font"]
			    });
			}

		    // Apply selected colour to everything with a colour set.
			if(accessibility["colour"] != "")
		    {
				jQuery("*").filter(function()
	            {
	            	return (jQuery(this).css('color') != "");
	            }).css(
				{
			        "color": accessibility["colour"]
			    });
			}

		    // Apply selected background colour to everything which has a background colour set.
			if(accessibility["background"] != "")
		    {
				jQuery("*").filter(function()
	            {
	            	return (jQuery(this).css('background-color') != "");
	            }).css(
				{
			        "background-color": accessibility["background"]
			    });
			}

			// Fix Font Awesome.
			jQuery("body .fa, body .fas, body .far, body .fal").css(
			{
		        "font-family": "Font Awesome 5 Free"
		    });

		    jQuery("body .fab").css(
			{
		        "font-family": "Font Awesome 5 Brands"
		    });

		    var d = new Date();
			d.setTime(d.getTime()+(7*24*60*60*1000));
			var expires = "expires="+d.toGMTString();
			document.cookie = "accessibility=" + JSON.stringify(accessibility) + "; " + expires + "; path=/;";
		}
	</script>

	<div class="dialog accessibility-dialog" id="accessibility-dialog">
		<form class="pure-form pure-form-aligned">
			<?php csrf(); ?>
			<div class="pure-control-group">
				<label for="accessibility-font-family">Font Family</label>
				<select name="accessibility-font-family" id="accessibility-font-family" class="accessibility-control">
					<option value="" selected>Default</option>
					<option value="'Times New Roman', Times">Times New Roman (serif)</option>
					<option value="Arial">Arial (sans-serif)</option>
					<option value="'Courier New', Courier">Courier New (mono space)</option>
				</select>
			</div>

			<div class="pure-control-group">
				<label for="accessibility-font-size">Text Size</label>
				<input type="radio" name="accessibility-font-size" id="accessibility-font-size-t" class="accessibility-control" value="0.5" /> <label class="inline" for="accessibility-font-size-t" style="font-size: 8px !important;">Tiny</label>
				<input type="radio" name="accessibility-font-size" id="accessibility-font-size-s" class="accessibility-control" value="0.75" /> <label class="inline" for="accessibility-font-size-s" style="font-size: 12px !important;">Small</label>
				<input type="radio" name="accessibility-font-size" id="accessibility-font-size-default" class="accessibility-control" value="1" checked /> <label class="inline" for="accessibility-font-size-default" style="font-size: 16px !important;">Default</label>
				<input type="radio" name="accessibility-font-size" id="accessibility-font-size-m" class="accessibility-control" value="1.25" /> <label class="inline" for="accessibility-font-size-m" style="font-size: 20px !important;">Medium</label>
				<input type="radio" name="accessibility-font-size" id="accessibility-font-size-l" class="accessibility-control" value="1.5" /> <label class="inline" for="accessibility-font-size-l" style="font-size: 24px !important;">Large</label>
				<input type="radio" name="accessibility-font-size" id="accessibility-font-size-xl" class="accessibility-control" value="2" /> <label class="inline" for="accessibility-font-size-xl" style="font-size: 32px !important;">Extra Large</label>
			</div>

			<div class="pure-control-group">
				<label for="accessibility-font-colour-default">Text Colour</label>
				<input type="radio" name="accessibility-font-colour" id="accessibility-font-colour-default" class="accessibility-control" value="" checked /> <label class="inline" for="accessibility-font-colour-default">Default</label>
				<input type="radio" name="accessibility-font-colour" id="accessibility-font-colour-black" class="accessibility-control" value="#000000" /> <label class="inline" for="accessibility-font-colour-black">Black</label>
				<input type="radio" name="accessibility-font-colour" id="accessibility-font-colour-white" class="accessibility-control" value="#ffffff" /> <label class="inline" for="accessibility-font-colour-white">White</label>
			</div>

			<div class="pure-control-group">
				<label for="accessibility-background-colour-default">Background Colour</label>
				<input type="radio" name="accessibility-background-colour" id="accessibility-background-colour-default" class="accessibility-control" value="" checked /> <label class="inline" for="accessibility-background-colour-default">Default</label>
				<input type="radio" name="accessibility-background-colour" id="accessibility-background-colour-black" class="accessibility-control" value="#000000" /> <label class="inline" for="accessibility-background-colour-black">Black</label>
				<input type="radio" name="accessibility-background-colour" id="accessibility-background-colour-white" class="accessibility-control" value="#ffffff" /> <label class="inline" for="accessibility-background-colour-white">White</label>
			</div>

			<div class="center">
				<button type="button" id="accessibility-close" class="pure-button"><em class="fas fa-times" aria-hidden="true"></em> Close</button>
				<button type="button" id="accessibility-reset" class="pure-button"><em class="fas fa-sync" aria-hidden="true"></em> Reset</button>
			</div>
		</form>
	</div>
</div>
