<div id="module_<?php echo($module_instance_id); ?>" class="module shop-account-module <?php echo($module_class); ?>">
	<h2>Edit Account Information</h2>

	<div class="error"><?php echo validation_errors(); ?></div>

	<?php
	if(isset($saved) && $saved == true)
	{
		?><div class="success">Your account information was saved.</div><?php
	}
	?>

	<form name="account_info" id="account_info" method="post" action="<?php echo($page); ?>" class="pure-form pure-form-aligned">
		<?php
		csrf();
		FeralHidden("user_id", $user->user_id);
		FeralHidden("joined", $user->joined);
		FeralHidden("joined_site_id", $user->joined_site_id);
		FeralHidden("last_login", $user->last_login);
		FeralHidden("active", $user->active);
		FeralHidden("shopper_group_id", $user->shopper_group_id);
		FeralHidden("task", "save_info");
		?>

		<div class="pure-g">
			<div class="pure-u-1 pure-u-md-1-2">
				<fieldset class="padded">
					<legend>Login Information</legend>

					<div class="pure-control-group">
						<label for="username">Username</label>
						<input type="text" name="username" id="username" value="<?php echo($user->username); ?>" required />
					</div>

					<div class="pure-control-group">
						<label for="password"><?php echo(($user->user_id ? "Change" : "Create")); ?> Password</label>
						<input type="password" name="password" id="password" <?php echo(($user->user_id ? "" : "required")); ?> pattern=".{8,255}" title="Enter a password at least 8 characters long." />
					</div>

					<div class="pure-control-group">
						<label for="password2">Confirm Password</label>
						<input type="password" name="password2" id="password2" <?php echo(($user->user_id ? "" : "required")); ?> pattern=".{8,255}" title="Enter a password at least 8 characters long." />
					</div>
				</fieldset>
			</div>

			<div class="pure-u-1 pure-u-md-1-2">
				<fieldset class="padded">
					<legend>Contact Information</legend>

					<div class="pure-control-group">
						<label for="fname">First Name</label>
						<input type="text" name="fname" id="fname" value="<?php echo($user->fname); ?>" required />
					</div>

					<div class="pure-control-group">
						<label for="lname">Last Name</label>
						<input type="text" name="lname" id="lname" value="<?php echo($user->lname); ?>" />
					</div>

					<div class="pure-control-group">
						<label for="company">Company</label>
						<input type="text" name="company" id="company" value="<?php echo($user->company); ?>" />
					</div>

					<div class="pure-control-group">
						<label for="email">Email Address</label>
						<input type="email" name="email" id="email" value="<?php echo($user->email); ?>" required />
					</div>

					<div class="pure-control-group">
						<label for="phone">Phone Number</label>
						<input type="tel" name="phone" id="phone" value="<?php echo($user->phone); ?>" />
					</div>

					<div class="pure-control-group">
						<label for="shipping_address">Address</label>
						<input type="text" name="shipping_address" id="shipping_address" value="<?php echo($user->shipping_address); ?>" />
					</div>

					<div class="pure-control-group">
						<label for="shipping_city">City</label>
						<input type="text" name="shipping_city" id="shipping_city" value="<?php echo($user->shipping_city); ?>" />
					</div>

					<div class="pure-control-group">
						<label for="shipping_postalcode">Postal Code</label>
						<input type="text" name="shipping_postalcode" id="shipping_postalcode" value="<?php echo($user->shipping_postalcode); ?>" />
					</div>

					<div class="pure-control-group">
						<label for="shipping_province">Province</label>
						<input type="text" name="shipping_province" id="shipping_province" value="<?php echo(($user->shipping_province ? $user->shipping_province : "ON")); ?>" maxlength="2" />
					</div>

					<div class="pure-control-group">
						<label for="shipping_country">Country</label>
						<input type="text" name="shipping_country" id="shipping_country" value="<?php echo(($user->shipping_country ? $user->shipping_country : "CA")); ?>" maxlength="2" />
					</div>
				</fieldset>
			</div>
		</div>

		<div class="center padded">
			<button type="submit" id="submit" value="true" class="pure-button pure-button-primary"><em class="fas fa-save" aria-hidden="true"></em> Save</button>
		</div>
	</form>
</div>
