<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Calendar Information</legend>

			<div class="form-row mb-2">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="Online Booking" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_recipients" class="<?php echo(LABEL_COL); ?>">Recipients (separate with ;)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_recipients" id="param_recipients" ng-model="params.recipients.value" class="form-control" data-default="" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_recaptcha_public_key" class="<?php echo(LABEL_COL); ?>">Recaptcha Site Key</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_recaptcha_public_key" id="param_recaptcha_public_key" ng-model="params.recaptcha_public_key.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_recaptcha_private_key" class="<?php echo(LABEL_COL); ?>">Recaptcha Secret Key</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_recaptcha_private_key" id="param_recaptcha_private_key" ng-model="params.recaptcha_private_key.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_services" class="<?php echo(LABEL_COL); ?>">Services (one per line)</label>
				<textarea name="param_services" id="param_services" ng-model="params.services.value" class="form-control"></textarea>
			</div>

			<div class="form-row mb-2">
				<label for="param_practitioner" class="<?php echo(LABEL_COL); ?>">Practitioners (one per line)</label>
				<textarea name="param_practitioner" id="param_practitioner" ng-model="params.practitioner.value" class="form-control"></textarea>
			</div>

			<div class="form-row mb-2">
				<label for="param_practitioner_emails" class="<?php echo(LABEL_COL); ?>">Practitioner's E-mails (one per line)</label>
				<textarea name="param_practitioner_emails" id="param_practitioner_emails" ng-model="params.practitioner_emails.value" class="form-control"></textarea>
			</div>

			<div class="form-row mb-2">
				<label for="param_open_at" class="<?php echo(LABEL_COL); ?>">Open At (hour only, 24 hour time)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_open_at" id="param_open_at" ng-model="params.open_at.value" class="form-control" min="0" max="23" step="1" data-default="9" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_close_at" class="<?php echo(LABEL_COL); ?>">Close At (hour only, 24 hour time)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_close_at" id="param_close_at" ng-model="params.close_at.value" class="form-control" min="0" max="23" step="1" data-default="17" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_appointment_duration" class="<?php echo(LABEL_COL); ?>">Appointment Duration (minutes)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_appointment_duration" id="param_appointment_duration" ng-model="params.appointment_duration.value" class="form-control" min="1" max="480" step="1" data-default="30" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_show_appointments" class="<?php echo(LABEL_COL); ?>">Show Appointments in Month View</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_show_appointments", "params.show_appointments.value", 0); ?></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Messages</legend>

			<div class="form-row mb-2">
				<label for="param_success_message" class="<?php echo(LABEL_COL); ?>">Success Message</label>
				<textarea ckeditor-basic name="param_success_message" id="param_success_message" ng-model="params.success_message.value" class="form-control" data-default="Thank you, your message was sent." required></textarea>
			</div>

			<div class="form-row mb-2">
				<label for="param_error_message" class="<?php echo(LABEL_COL); ?>">Error Message</label>
				<textarea ckeditor-basic name="param_error_message" id="param_error_message" ng-model="params.error_message.value" class="form-control" data-default="There was an error sending your message." required></textarea>
			</div>
		</fieldset>
	</div>
</div>
