<?php
if($title && $title_heading_level)
{
	?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
}
if(count($errors))
{
	?><div class="error"><?php echo(implode("<br>", $errors)); ?></div><?php
}
if(count($messages))
{
	?><div class="success"><?php echo(implode("<br>", $messages)); ?></div><?php
}

if(!$sent)
{
	?>
	<div id="module_<?php echo($module_instance_id); ?>" class="module contact-module <?php echo($module_class); ?>">
		<form name="contact_<?php echo($module_instance_id); ?>" id="contact_<?php echo($module_instance_id); ?>" method="post" action="" class="pure-form pure-form-aligned">
			<?php csrf(); ?>
			<input type="hidden" name="sendmail" id="sendmail" value="1" />

			<?php
			if($show_name)
			{
				?>
				<div class="pure-control-group">
					<label for="name">Name: <sup class="required">*</sup></label>
					<input type="text" name="name" id="name" value="<?php echo $this->input->post("name");?>" required />
				</div>
				<?php
			}

			if($show_email)
			{
				?>
				<div class="pure-control-group">
					<label for="email">E-mail Address: <sup class="required">*</sup></label>
					<input type="email" name="email" id="email" value="<?php echo $this->input->post("email");?>" required />
				</div>
				<?php
			}

			if($show_phone)
			{
				?>
				<div class="pure-control-group">
					<label for="phone">Phone Number: <sup class="required">*</sup></label>
					<input type="tel" name="phone" id="phone" value="<?php echo $this->input->post("phone");?>" required />
				</div>
				<?php
			}

			if(is_array($departments) && count($departments))
			{
				?>
				<div class="pure-control-group">
					<label for="department">Department: <sup class="required">*</sup></label>

					<?php
					$wgt = new FeralBasicSelectWidget("department", $this->input->post("department"));

					for($i=0; $i<count($departments); $i++)
					{
						$d = trim($departments[$i]);
						$e = trim($addresses[$i]);

						$wgt->AddOption("$e", "$d");
					}
					$wgt->Create();
					?>
				</div>
				<?php
			}

			if($show_subject)
			{
				?>
				<div class="pure-control-group">
					<label for="subject">Subject: <sup class="required">*</sup></label>
					<input type="text" name="subject" id="subject" value="<?php echo $this->input->post("subject");?>" required />
				</div>
				<?php
			}

			foreach($extra_fields as $field)
			{
				if(count($field) < 3)
				{
					continue;
				}
				?>
				<div class="pure-control-group">
					<label for="<?php echo($field[1]); ?>"><?php echo($field[0]); ?>:<?php echo(($field[3] == 1 ? ' <sup class="required">*</sup>' : '')); ?></label>
					<?php
					if($field[2] == "textarea")
					{
						?><textarea name="<?php echo($field[1]); ?>" id="<?php echo($field[1]); ?>" <?php echo(($field[3] == 1 ? 'required' : '')); ?> <?php echo((isset($field[4]) ? $field[4] : "")); ?>><?php echo $this->input->post($field[1]);?></textarea><?php
					}
					else
					{
						?><input type="<?php echo($field[2]); ?>" name="<?php echo($field[1]); ?>" id="<?php echo($field[1]); ?>" value="<?php echo $this->input->post($field[1]);?>" <?php echo(($field[3] == 1 ? 'required' : '')); ?> <?php echo((isset($field[4]) ? $field[4] : "")); ?> /><?php
					}
					?>
				</div>
				<?php
			}

			if($show_message)
			{
				?>
				<div class="pure-control-group">
					<label for="message">Message: <sup class="required">*</sup></label>
					<textarea name="message" id="message" required><?php echo $this->input->post("message");?></textarea>
				</div>
				<?php
			}

			if(!Mainframe::site()->recaptcha && $publickey && $privatekey)
			{
				?>
				<div class="pure-control-group">
					<label aria-label="Google reCaptcha">&nbsp;</label>
					<div class="g-recaptcha" style="display: inline-block;" data-sitekey="<?php echo($publickey); ?>"></div>
				</div>
				<?php
			}
			?>

			<div class="pure-controls">
				<button type="submit" class="pure-button pure-button-primary" id="send_<?php echo($module_instance_id); ?>">Send</button>
			</div>
			<?php
			if(Mainframe::site()->recaptcha)
			{
				?>
				<input type="hidden" name="token_<?php echo($module_instance_id); ?>" id="token_<?php echo($module_instance_id); ?>" value="" />
				<input type="hidden" name="verification_<?php echo($module_instance_id); ?>" id="verification_<?php echo($module_instance_id); ?>" value="" />

				<script>
					<?php // Change the submit button to a regular button and attach our custom handler to it. ?>
					var send_<?php echo($module_instance_id); ?> = document.getElementById("send_<?php echo($module_instance_id); ?>")
					send_<?php echo($module_instance_id); ?>.type = "button";
					send_<?php echo($module_instance_id); ?>.onclick = function()
					{
						<?php // Get a bot token from Google. ?>
						botToken("contact_<?php echo($module_instance_id); ?>", function(token)
						{
							<?php
							/**
							 * Now that we have a token:
							 * - Remove the custom click handler.
							 * - Change the submit button back to a submit button.
							 * - Click the submit button to submit the form normally.
							 */
							?>
							document.getElementById("token_<?php echo($module_instance_id); ?>").value = token;
							send_<?php echo($module_instance_id); ?>.type = "submit";
							send_<?php echo($module_instance_id); ?>.onclick = null;
							send_<?php echo($module_instance_id); ?>.click();
						});
					}

					function verify_<?php echo($module_instance_id); ?>(e)
					{
						e.preventDefault();
						document.getElementById("verification_<?php echo($module_instance_id); ?>").value = "<?php echo($challenge); ?>";
						send_<?php echo($module_instance_id); ?>.click();
					}
				</script>
				<?php
			}
			?>
			<div class="clear"></div>
		</form>
	</div>
	<?php
}
