<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Gallery Settings</legend>

			<div class="form-row mb-2">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="Gallery" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_directory" class="<?php echo(LABEL_COL); ?>">Image Directory</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_directory" id="param_directory" ng-model="params.directory.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in image_dirs" required>
						<option value="">Choose a Directory</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_style" class="<?php echo(LABEL_COL); ?>">Style</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_style", "params.style.value", "padded", ["padded" => "Padded", "compact" => "Compact"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_ordering" class="<?php echo(LABEL_COL); ?>">Sorting</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_ordering" id="param_ordering" ng-model="params.ordering.value" class="form-control custom-select" data-default="filename">
						<option value="">Choose Sort Order</option>
						<option value="ratio">Aspect Ratio Then Filename</option>
						<option value="filename">Filename A-Z</option>
						<option value="filename_desc">Filename Z-A</option>
						<option value="date">Date Added (newest first)</option>
						<option value="date_desc">Date Added (oldest first)</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_aspect_ratio" class="<?php echo(LABEL_COL); ?>">Fixed Aspect Ratio</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_aspect_ratio" id="param_aspect_ratio" ng-model="params.aspect_ratio.value" class="form-control custom-select" data-default="4:3">
						<option value="">Choose Aspect Ratio</option>
						<option value="original">Original - No Cropping</option>
						<option value="1:1">1:1 (square)</option>
						<option value="4:3">4:3 (standard)</option>
						<option value="3:2">3:2 (35mm)</option>
						<option value="16:9">16:9 (widescreen)</option>
						<option value="3:4">3:4 (standard, vertical)</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_theme" class="<?php echo(LABEL_COL); ?>">Theme</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_theme", "params.theme.value", "theme3", ["theme1" => "1", "theme2" => "2", "theme3" => "3", "theme4" => "4", "theme5" => "5"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_lightbox_width" class="<?php echo(LABEL_COL); ?>">Lightbox Width</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_lightbox_width" id="param_lightbox_width" ng-model="params.lightbox_width.value" class="form-control" data-default="90%" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_lightbox_height" class="<?php echo(LABEL_COL); ?>">Lightbox Height</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_lightbox_height" id="param_lightbox_height" ng-model="params.lightbox_height.value" class="form-control" data-default="90%" /></div>
			</div>

			<legend>Breakpoints</legend>

			<div class="form-row mb-2">
				<label for="param_breakpoint_sm" class="<?php echo(LABEL_COL); ?>">Small Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_breakpoint_sm" id="param_breakpoint_sm" ng-model="params.breakpoint_sm.value" class="form-control" min="1" step="1" data-default="568" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_breakpoint_md" class="<?php echo(LABEL_COL); ?>">Medium Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_breakpoint_md" id="param_breakpoint_md" ng-model="params.breakpoint_md.value" class="form-control" min="1" step="1" data-default="768" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_breakpoint_lg" class="<?php echo(LABEL_COL); ?>">Large Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_breakpoint_lg" id="param_breakpoint_lg" ng-model="params.breakpoint_lg.value" class="form-control" min="1" step="1" data-default="1024" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_breakpoint_xl" class="<?php echo(LABEL_COL); ?>">Extra Large Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_breakpoint_xl" id="param_breakpoint_xl" ng-model="params.breakpoint_xl.value" class="form-control" min="1" step="1" data-default="1280" /></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Pictures Per Row</legend>

			<div class="form-row mb-2">
				<label for="param_per_row_sm" class="<?php echo(LABEL_COL); ?>">Small Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_per_row_sm" id="param_per_row_sm" ng-model="params.per_row_sm.value" class="form-control" min="1" max="10" step="1" data-default="2" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_per_row_md" class="<?php echo(LABEL_COL); ?>">Medium Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_per_row_md" id="param_per_row_md" ng-model="params.per_row_md.value" class="form-control" min="1" max="10" step="1" data-default="3" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_per_row_lg" class="<?php echo(LABEL_COL); ?>">Large Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_per_row_lg" id="param_per_row_lg" ng-model="params.per_row_lg.value" class="form-control" min="1" max="10" step="1" data-default="4" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_per_row_xl" class="<?php echo(LABEL_COL); ?>">Extra Large Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_per_row_xl" id="param_per_row_xl" ng-model="params.per_row_xl.value" class="form-control" min="1" max="10" step="1" data-default="5" /></div>
			</div>

			<legend>Albums Per Row</legend>

			<div class="form-row mb-2">
				<label for="param_album_per_row_sm" class="<?php echo(LABEL_COL); ?>">Small Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_album_per_row_sm" id="param_album_per_row_sm" ng-model="params.album_per_row_sm.value" class="form-control" min="1" max="10" step="1" data-default="2" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_album_per_row_md" class="<?php echo(LABEL_COL); ?>">Medium Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_album_per_row_md" id="param_album_per_row_md" ng-model="params.album_per_row_md.value" class="form-control" min="1" max="10" step="1" data-default="3" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_album_per_row_lg" class="<?php echo(LABEL_COL); ?>">Large Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_album_per_row_lg" id="param_album_per_row_lg" ng-model="params.album_per_row_lg.value" class="form-control" min="1" max="10" step="1" data-default="4" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_album_per_row_xl" class="<?php echo(LABEL_COL); ?>">Extra Large Screen</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_album_per_row_xl" id="param_album_per_row_xl" ng-model="params.album_per_row_xl.value" class="form-control" min="1" max="10" step="1" data-default="5" /></div>
			</div>
		</fieldset>
	</div>
</div>
