<div id="module_<?php echo($module_instance_id); ?>" class="module google-map-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>

	<script>
		var map;
		var geocoder;

		var points = Array(1);
		var markers = Array(1);
		var infos = Array(1);
		var headings = Array(1);
		var pitches = Array(1);
		var zooms = Array(1);

		function initialize()
		{
			geocoder = new google.maps.Geocoder();

			var myOptions =
	    	{
	      		zoom: <?php echo ($zoom ? $zoom : 13)?>,
	      		//center: points[0],
	      		mapTypeId: google.maps.MapTypeId.ROADMAP,
	      		streetViewControl: true
	    	};

	    	map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

	    	<?php
			if($latitude && $longitude)
			{
	    		?>
	    		points[0] = new google.maps.LatLng(<?php echo $latitude?>, <?php echo $longitude?>);
	    		mapit();
				<?php
	    	}
	    	else
	    	{
	    		?>geocode_location("<?php echo urldecode($address)?>")<?php
	    	}
	    	?>

			//remove our loading image so that it doesn't bleed through while moving the map around
			document.getElementById("map_canvas").style.background = "none";
		}

		function geocode_location(address)
		{
	    	geocoder.geocode( { 'address': address}, function(results, status)
	    	{
	      		if (status == google.maps.GeocoderStatus.OK)
	      		{
	        		points[0] = results[0].geometry.location;
	        		mapit();
	         	}
	      	});
	  	}

		function mapit()
		{
			clear_infos();

			<?php
			$info = addslashes("<div class=\"map_bubble\"><br />" .  ($bubble_text ? $bubble_text : urldecode($address)) . "<br /><br /></div>");
			$info = str_replace(array("\n", "\r"), "", $info);
			?>

	        markers[0] = new google.maps.Marker({
				position: points[0],
				map: map,
	        	title:"<?php echo Mainframe::site()->name?>"
			});


	        infos[0] = new google.maps.InfoWindow({
				content: "<?php echo $info?>"
			});


	        google.maps.event.addListener(markers[0], 'click', function()
			{
				clear_infos();
				infos[0].open(map,markers[0]);
			});


	        headings[0] = <?php echo ($sv_heading ? $sv_heading : "0");?>;
	        pitches[0] = <?php echo ($sv_pitch ? $sv_pitch : "0");?>;
	        zooms[0] = <?php echo ($sv_zoom ? $sv_zoom : "1");?>;

	        infos[0].open(map,markers[0]);
	        map.setCenter(points[0]);

	        <?php
	        //if we have detailed street view info, start them in Street View
	        if($sv_heading && $initial_view == "sv")
	        {
	        	?>
	        	street_view(0);
	        	<?php
	        }
			?>
		}

		function clear_infos()
		{
			kill_street_view();

			var i=0;

			for(i=0; i<infos.length; i++)
			{
				if(infos[i] != null && infos[i] != "undefined")
				{
					infos[i].close();
				}
			}
		}

		function street_view(index)
		{
			var panoramaOptions =
			{
	  			position: points[index],
	  			enableCloseButton: true,
	  			pov:
	  			{
	    			heading: headings[index],
				    pitch: pitches[index],
	    			zoom: zooms[index]
	  			}
			};

			var panorama = new google.maps.StreetViewPanorama(document.getElementById("map_canvas"), panoramaOptions);

			map.setStreetView(panorama);
		}

		function kill_street_view()
		{
			panorama = map.getStreetView();
			panorama.setVisible(false);
		}

		function display_sv_position()
		{
			var pano = map.getStreetView();
			var pov = pano.getPov();
			var obj = document.getElementById("sv_position");
			var position = pano.getPosition();

			obj.innerHTML = "Latitude: " + position.lat() + "<br />Longitude: " + position.lng() + "<br />Heading: " + pov.heading + "<br />Pitch: " + pov.pitch + "<br />Zoom: " + pov.zoom;
		}

		function loadScript()
		{
			var script = document.createElement("script");
			script.type = "text/javascript";
			script.src = "https://maps.google.com/maps/api/js?callback=initialize&v=3&key=<?php echo($api_key); ?>";
			document.body.appendChild(script);
		}

		jQuery(window).on("load", function()
		{
			loadScript();
		});
	</script>

	<div class="map-controls">
		<a href="#" onclick="kill_street_view(); return false;">Map View</a> |
		<a href="#" onclick="street_view(0); return false;">Street View</a>
	</div>

	<div id="map_canvas" class="map_canvas"></div>
</div>
