<div id="module_<?php echo($module_instance_id); ?>" class="module nvmenu-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>
	<nav class="nvmenu nvmenu-horizontal" id="nvmenu_<?php echo($module_instance_id); ?>">
		<?php
		nvmenu($module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title);
		?>
		<div class="clear"></div>
	</nav>

	<div class="nvmenu-overlay" id="nvmenu-overlay-<?php echo($module_instance_id); ?>">
		<div class="nvmenu-overlay-container">
			<nav class="nvmenu nvmenu-vertical">
				<div class="pure-g">
					<div class="pure-u-2-3 nvmenu-title"></div>
					<div class="pure-u-1-3 right">
						<a href="#" onclick="close_nvmenu<?php echo($module_instance_id); ?>(event)" class="nvmenu-close" title="Close This Menu"><em class="fas fa-times-circle" aria-hidden="true"></em><span class="hidden">Close This Menu</span></a>
					</div>

					<?php
					if($content_above)
					{
						?><div class="pure-u-1"><div class="padded"><?php echo($content_above); ?></div></div><?php
					}

					?>
					<div class="pure-u-1 nvmenu-items"></div>
					<div class="pure-u-1"></div>
					<?php
					if($search)
					{
						?>
						<div class="pure-u-1 pure-form pure-form-aligned">
							<fieldset class="padded">
								<?php
								if($search_legend)
								{
									?><legend><?php echo($search_legend); ?></legend><?php
								}
								?>
								<form action="<?php echo($search_action); ?>" method="get">
									<input type="search" placeholder="Search" aria-label="Search Term" name="q" value="<?php echo(html_escape($this->input->get_post("q"))); ?>" />
									<button type="submit" class="pure-button pure-button-tertiary" title="<?php echo($search_legend); ?>"><em class="fas fa-fw fa-search" aria-hidden="true"></em><span class="hidden">Search</span></button>
								</form>
							</fieldset>
						</div>
						<?php
					}
					?>
					<div class="pure-u-1"><div id="nvmenu-content-below"><?php echo($content_below); ?></div></div>
				</div>
			</nav>
		</div>
	</div>
</div>

<script>
var nvmenu_content_below = jQuery("#nvmenu-content-below").html();

jQuery("#module_<?php echo($module_instance_id); ?> .nvmenu-overlay-container").off("click").on("click", function(e)
{
	try
	{
		e.stopPropagation();
	}
	catch(e)
	{
		// For IE
		try
    	{
    		window.event.cancelBubble = true;
    	}
    	catch(e){}
	}
});

jQuery("#module_<?php echo($module_instance_id); ?> .nvmenu-overlay").off("click").on("click", function(e)
{
	try
	{
		e.stopPropagation();
	}
	catch(e)
	{
		// For IE
		try
    	{
    		window.event.cancelBubble = true;
    	}
    	catch(e){}
	}

	close_nvmenu<?php echo($module_instance_id); ?>(e);
});

jQuery(document).ready(function()
{
	jQuery("#module_<?php echo($module_instance_id); ?> > .nvmenu > .nvmenu-items").prioritize_nvmenu({
		more: '<?php echo(addslashes($more_text)); ?>',
		menu: '<?php echo(addslashes($menu_text)); ?>',
		module_instance_id: '<?php echo($module_instance_id); ?>'
	});
});

function close_nvmenu<?php echo($module_instance_id); ?>(e)
{
	try
	{
		e.preventDefault();
	}
	catch(e){}

	jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?>").fadeOut(500);
}

function open_nvmenu<?php echo($module_instance_id); ?>(e)
{
	jQuery("#nvmenu-content-below").removeClass("padded");

	if(nvmenu_content_below != "" && nvmenu_content_below != "0")
	{
		jQuery("#nvmenu-content-below").addClass("padded").html(nvmenu_content_below);
	}

	try
	{
		e.preventDefault();
	}
	catch(e){}

	var target = jQuery(e.target);

	if(!target.hasClass("nvmenu-link"))
	{
		target = target.parents(".nvmenu-link").eq(0);
	}

	var content_below = target.siblings('.nvmenu-content-below').eq(0).html();

	if(content_below != "" && content_below != "0")
	{
		jQuery("#nvmenu-content-below").addClass("padded").html(content_below);
	}

	jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?>").css({height: jQuery(document).outerHeight(true) + "px"});

	// If the overlay is already visible, slide it sideways. Otherwise, fade it in.
	if(jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?>:visible").size() > 0)
	{
		jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?> .nvmenu-overlay-container").fadeOut(250, function()
		{
			jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?> .nvmenu-title").html(target.siblings(".nvmenu-overlay-data-title").eq(0).html());
			jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?> .nvmenu-items").html(target.siblings(".nvmenu-overlay-data-items").eq(0).html());

			jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?> .nvmenu-overlay-container").fadeIn(250);
		});
	}
	else
	{
		jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?> .nvmenu-title").html(target.siblings(".nvmenu-overlay-data-title").eq(0).html());
		jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?> .nvmenu-items").html(target.siblings(".nvmenu-overlay-data-items").eq(0).html());
		jQuery("#nvmenu-overlay-<?php echo($module_instance_id); ?>").fadeIn(500);
	}
	jQuery(window).scrollTop(0);
}
</script>

<?php
function nvmenu($module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title)
{
	$page = Mainframe::page();
	$site = Mainframe::site();
	$CI   = get_instance();
	$CI->load->model("menuitem");
	$items = $CI->menuitem->LoadByMenuID($menu_id, null, Mainframe::user());

	if(count($items) == 0)
	{
		return;
	}
	?>
	<ul class="nvmenu-items">
		<?php
		$total = count($items);
		$count = 0;

		foreach($items as $item)
		{
			if(!$item->published)
			{
				continue;
			}
			$count++;

			$url          = (preg_match('/^http/', strtolower($item->url)) ? '' : '/') . ($item->page_id == $site->default_page_id ? "" : $item->url);
			$subitems     = $CI->menuitem->LoadByMenuID($menu_id, $item->menu_item_id, Mainframe::user());
			$class        = "nvmenu-item";
			$has_children = false;

			if($item->url == "index" || $url == "//")
			{
				$url = "/";
			}

			if(count($subitems) > 0)
			{
				$class .= " nvmenu-has-children";
				$has_children = true;
			}

			// The wonky PHP tags here help prevent spaces from being placed between menu items.
			?><li class="<?php echo($class); ?> <?php echo($count == 1 ? "first" : "")?> <?php echo($count == $total ? "last" : "")?> <?php echo($page->page_id == $item->page_id ? "active" : "")?>"><?php
				if($has_children)
				{
					?><a href="#" onclick="open_nvmenu<?php echo($module_instance_id); ?>(event); return false;" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nvmenu-link"><?php
				}
				else
				{
					?><a href="<?php echo $url?>" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nvmenu-link"><?php
				}
				if($item->icon && ($show_icons == "menu" || $show_icons == "both"))
				{
					?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
				}
				echo($item->title);
				?></a><span class="nvmenu-content-below hidden"><?php echo($item->description); ?></span><?php

				// Add the current menu item as the first child of the submenu for accessibility reasons.
				if($duplicate_parent_links && count($subitems))
				{
					$subitems = array_merge(array($item), $subitems);
				}

				nvsubmenu($item, $subitems, $module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title);
			?></li><?php
		}
		?>
	</ul>
	<?php
}

function nvsubmenu($parent, $items, $module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title)
{
	$page = Mainframe::page();
	$CI   = get_instance();
	$CI->load->model("menuitem");

	if(count($items) == 0)
	{
		return;
	}
	?>
	<div class="nvmenu-overlay-data-title hidden">
		<?php
		$url = (preg_match('/^http/', strtolower($parent->url)) ? '' : '/') . $parent->url;

		if($link_overlay_title)
		{
			?><a href="<?php echo $url?>" <?php echo ($parent->target ? "target=\"$parent->target\"" : "")?> <?php echo ($parent->title_tag ? "title=\"$parent->title_tag\"" : "")?> class="nvmenu-link nvmenu-link-heading"><?php
		}

		if($parent->icon && ($show_icons == "submenu" || $show_icons == "both"))
		{
			?><em class="fa-fw <?php echo($parent->icon); ?>" aria-hidden="true"></em> <?php
		}
		echo($parent->title);

		if($link_overlay_title)
		{
			?></a><?php
		}
		?>
	</div>

	<div class="nvmenu-overlay-data-items hidden">
		<ul class="pure-g">
			<?php
			$total = count($items);
			$count = 0;

			foreach($items as $item)
			{
				if(!$item->published)
				{
					continue;
				}
				$count++;

				$url          = $item->url;
				$subitems     = $CI->menuitem->LoadByMenuID($menu_id, $item->menu_item_id, Mainframe::user());
				$class        = "nvmenu-item pure-u-1 pure-u-md-1-2 pure-u-lg-1-3 pure-u-xl-1-4";
				$has_children = false;

				if(count($subitems) > 0 && $item->menu_item_id != $parent->menu_item_id)
				{
					$class .= " nvmenu-has-children";
					$has_children = true;
				}
				?>
				<li class="<?php echo($class); ?> <?php echo($count == 1 ? "first" : "")?> <?php echo($count == $total ? "last" : "")?> <?php echo($page->page_id == $item->page_id ? "active" : "")?>">
					<?php
					if($has_children)
					{
						?><a href="#" onclick="open_nvmenu<?php echo($module_instance_id); ?>(event); return false;" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nvmenu-link"><?php
					}
					else
					{
						?><a href="/<?php echo($url); ?>" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nvmenu-link"><?php
					}

					if($item->icon && ($show_icons == "submenu" || $show_icons == "both"))
					{
						?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
					}
					echo($item->title);
					?></a><span class="nvmenu-content-below hidden"><?php echo($item->description); ?></span><?php

					if($item->menu_item_id != $parent->menu_item_id)
					{
						// Add the current menu item as the first child of the submenu for accessibility reasons.
						if($duplicate_parent_links && count($subitems))
						{
							$subitems = array_merge(array($item), $subitems);
						}

						nvsubmenu($item, $subitems, $module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title);
					}
					?>
				</li>
				<?php
			}
			?>
		</ul>
	</div>
	<?php
}
