<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Menu Settings</legend>

			<div class="form-row mb-2">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_menu_id" class="<?php echo(LABEL_COL); ?>">Menu</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_menu_id" id="param_menu_id" ng-model="params.menu_id.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in menus" required>
						<option value="">Choose a Menu</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_show_icons" class="<?php echo(LABEL_COL); ?>">Show Icons</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_show_icons" id="param_show_icons" ng-model="params.show_icons.value" class="form-control custom-select" data-default="submenu" required>
						<option value="">Choose an Option</option>
						<option value="menu">Menu bar only</option>
						<option value="submenu">Submenu overlay only</option>
						<option value="both">Menu bar and submenu overlay</option>
					</select>
				</div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Submenu Overlay</legend>

			<div class="form-row mb-2">
				<label for="param_duplicate_parent_links" class="<?php echo(LABEL_COL); ?>">Duplicate Parent Links</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_duplicate_parent_links", "params.duplicate_parent_links.value", 1); ?></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_search" class="<?php echo(LABEL_COL); ?>">Include Search Box</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_search", "params.search.value", 1); ?></div>
			</div>

			<div class="form-row mb-2" ng-if="params.search.value == 1">
				<label for="param_search_action" class="<?php echo(LABEL_COL); ?>">Search Box Action</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_search_action" id="param_search_action" ng-model="params.search_action.value" class="form-control" data-default="/search" required /></div>
			</div>

			<div class="form-row mb-2" ng-if="params.search.value == 1">
				<label for="param_search_legend" class="<?php echo(LABEL_COL); ?>">Search Box Legend</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_search_legend" id="param_search_legend" ng-model="params.search_legend.value" class="form-control" data-default="Search Our Website" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_content_above" class="col-12">Content Above Menu</label>
				<div class="col-12"><textarea ckeditor name="param_content_above" id="param_content_above" ng-model="params.content_above.value" class="form-control"></textarea></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_content_below" class="col-12">Content Below Menu</label>
				<div class="col-12"><textarea ckeditor name="param_content_below" id="param_content_below" ng-model="params.content_below.value" class="form-control"></textarea></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Responsive Menu Settings</legend>

			<div class="form-row mb-2">
				<label for="param_more_text" class="<?php echo(LABEL_COL); ?>">Text For "More" Item</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_more_text" id="param_more_text" ng-model="params.more_text.value" class="form-control" data-default="<em class=&quot;fa fa-bars&quot;></em> More" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_menu_text" class="<?php echo(LABEL_COL); ?>">Text For Mobile Menu</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_menu_text" id="param_menu_text" ng-model="params.menu_text.value" class="form-control" data-default="<em class=&quot;fa fa-bars&quot;></em> Menu" required /></div>
			</div>
		</fieldset>
	</div>
</div>
