<div id="module_<?php echo($module_instance_id); ?>" class="module search-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>
	<div class="pure-g">
		<?php
		if($q)
		{
			?>
			<div class="pure-u-1 pure-u-sm-2-3">
				<p class="search-summary">Your search for "<?php echo($q); ?>" returned <?php echo(number_format($total, 0)); ?> results.</p>
			</div>
			<?php
		}
		else
		{
			?>
			<div class="pure-u-1 pure-u-sm-2-3">
				<p class="search-summary">Please enter a search term.</p>
			</div>
			<?php
		}
		?>
		<div class="pure-u-1 pure-u-sm-1-3 right">
			<form action="" method="get" class="pure-form">
				<input type="search" placeholder="<?php echo($search_legend); ?>" aria-label="<?php echo($search_legend); ?>" name="q<?php echo($module_instance_id); ?>" value="<?php echo(html_escape($this->input->get_post("q" . $module_instance_id))); ?>" autofocus />
				<button type="submit" class="pure-button pure-button-primary" title="<?php echo($search_legend); ?>"><em class="fas fa-fw fa-search" aria-hidden="true"></em><span class="hidden"><?php echo($search_legend); ?></span></button>
			</form>
		</div>
	</div>

	<?php
	if(count($results) > 0)
	{
		?>
		<div class="pure-g">
			<?php
			foreach($results as $result)
			{
				if($result->type == "page")
				{
					$p = new Page();
					$p->load($result->page_id);
					$c = new Category();
					$c->load($p->category_id);

					$s = new Site();
					if($p->site_id != $s->site_id)
					{
						$s->load($p->site_id);
					}

					$d = new Domain();
					if($s->domain_id != $d->domain_id)
					{
						$d->load($s->domain_id);
					}

					$p->url = "http" . (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] ? "s" : "") . "://" . $d->domain . "/" . $p->url;
					?>
					<div class="pure-u-1 pure-u-md-1-2 pure-u-lg-1-3">
						<article>
							<?php
							if($show_title)
							{
								?><<?php echo($heading_level); ?> class="search-title"><a href="<?php echo($p->url); ?>"><?php

								if($show_icons)
								{
									$icon = 'fa-file-alt';
									?><em class="far fa-fw <?php echo($icon); ?>" aria-hidden="true"></em> <?php
								}

								echo($p->title);

								?></a></<?php echo($heading_level); ?>><?php
							}

							if($show_category && $p->category_id)
							{
								?><p class="search-category"><?php echo($c->name); ?></p><?php
							}

							if($show_date)
							{
								?><time datetime="<?php echo(date("Y-m-d H:i:s", strtotime($p->created))); ?>"><?php echo(date("l, F jS, Y", strtotime($p->created))); ?></time><?php
							}

							if($show_text)
							{
								//Remove empty paragraphs (whitespace, non-breaking space HTML, and non-breaking space Unicode)
								$description = preg_replace('/(<p>(\s|&nbsp;|\x{00A0})*<\/p>)/', '', strip_tags(Mainframe::preview($p, false, false), "<p><div><br>"));
								$strlen1 = strlen($description);

								if($strlen1 > $character_limit && $character_limit > 0)
								{
									$description = truncate($description, $character_limit, array('ending' => "...", 'exact' => false, 'html' => true));
								}

								?><div><?php echo($description); ?></div><?php
							}
							?>
						</article>
					</div>
					<?php
				}
				else if($result->type == "document")
				{
					$doc = $result;

					$s = new Site();
					if($doc->site_id != $s->site_id)
					{
						$s->load($doc->site_id);
					}

					$d = new Domain();
					if($s->domain_id != $d->domain_id)
					{
						$d->load($s->domain_id);
					}

					$doc->url = "http" . (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] ? "s" : "") . "://" . $d->domain . "/document/" . $doc->url;
					?>
					<div class="pure-u-1 pure-u-md-1-2 pure-u-lg-1-3">
						<article>
							<?php
							if($show_title)
							{
								?><<?php echo($heading_level); ?> class="search-title"><a href="<?php echo($doc->url); ?>"><?php

								if($show_icons)
								{
									if(preg_match('/\.(jpe?g|png|gif|bmp|ico)/i', $doc->filename))
									{
										$icon = 'fa-image far';
									}
									else if(preg_match('/\.pdf?/i', $doc->filename))
									{
										$icon = 'fa-file-pdf far';
									}
									else if(preg_match('/\.(html|php|js|css)/i', $doc->filename))
									{
										$icon = 'fa-file-code far';
									}
									else if(preg_match('/\.(txt|log|md)/i', $doc->filename))
									{
										$icon = 'fa-file-alt far';
									}
									else if(preg_match('/\.(mp3|wav|ogg)/i', $doc->filename))
									{
										$icon = 'fa-file-audio far';
									}
									else if(preg_match('/\.(mp4|wmv|mov|ogv|webm)/i', $doc->filename))
									{
										$icon = 'fa-file-video far';
									}
									else if(preg_match('/\.(zip|gz|7z|tar|rar)/i', $doc->filename))
									{
										$icon = 'fa-file-archive far';
									}
									else if(preg_match('/\.docx?/i', $doc->filename))
									{
										$icon = 'fa-file-word far';
									}
									else if(preg_match('/\.xlsx?/i', $doc->filename))
									{
										$icon = 'fa-file-excel far';
									}
									else if(preg_match('/\.pptx??/i', $doc->filename))
									{
										$icon = 'fa-file-powerpoint far';
									}
									else
									{
										$icon = 'fa-file far';
									}

									?><em class="fa-fw <?php echo($icon); ?>" aria-hidden="true"></em> <?php
								}

								echo($doc->title);

								?></a></<?php echo($heading_level); ?>><?php
							}

							if($show_category)
							{
								?><p class="search-category"><?php echo($doc->category_name); ?></p><?php
							}

							if($show_date)
							{
								?><time datetime="<?php echo(date("Y-m-d H:i:s", strtotime($doc->created))); ?>"><?php echo(date("l, F jS, Y", strtotime($doc->created))); ?></time><?php
							}

							if($show_text)
							{
								//Remove empty paragraphs (whitespace, non-breaking space HTML, and non-breaking space Unicode)
								$description = preg_replace('/(<p>(\s|&nbsp;|\x{00A0})*<\/p>)/', '', $doc->description);
								$strlen1 = strlen($description);

								if($strlen1 > $character_limit && $character_limit > 0)
								{
									$description = truncate($description, $character_limit, array('ending' => "...", 'exact' => false, 'html' => true));
								}

								echo($description);
							}
							?>
						</article>
					</div>
					<?php
				}
				else if($result->type == "product")
				{
					$p = new Shop_product();
					$p->loadWithImages($result->product_id);
					$layout = new Shop_product_layout();
					$layout->load($p->product_layout_id);
					?>
					<div class="pure-u-1 pure-u-md-1-2 pure-u-lg-1-3">
						<?php $this->load->view("shop/" . str_replace("product_", "product_snapshot_", $layout->view_filename), array("product" => $p, "layout" => $layout, "show_category" => false)); ?>
					</div>
					<?php
				}
			}
			?>
		</div>
		<?php
	}

	if($next || $prev)
	{
		?>
		<div class="search-pagination">
			<?php
			if($prev)
			{
				$link = "/" . Mainframe::page()->url . ($q ? "?q=" . $q . "&p=" . $prev : "?p=" . $prev);
				?><a href="<?php echo($link); ?>" class="pure-button pure-button-primary" title="Previous <?php echo($per_page); ?> Results"><em class="fas fa-fw fa-chevron-left" aria-hidden="true"></em> Prev <?php echo($per_page); ?></a><?php
			}
			?> <a href="#" onclick="return false" class="pure-button pure-button-primary" title="Page <?php echo($page_number); ?> of <?php echo($page_count); ?>">Page <?php echo($page_number); ?> of <?php echo($page_count); ?></a> <?php
			if($next)
			{
				$link = "/" . Mainframe::page()->url . ($q ? "?q=" . $q . "&p=" . $next : "?p=" . $next);
				?><a href="<?php echo($link); ?>" class="pure-button pure-button-primary" title="Next <?php echo($per_page); ?> Results">Next <?php echo($per_page); ?> <em class="fas fa-fw fa-chevron-right" aria-hidden="true"></em></a><?php
			}
			?>
		</div>
		<?php
	}
	?>
</div>
