<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Slideshow Settings</legend>

			<div class="form-row mb-2">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_directory" class="<?php echo(LABEL_COL); ?>">Directory</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_directory" id="param_directory" ng-model="params.directory.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in image_dirs" required>
						<option value="">Choose a Directory</option>
					</select>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_mode" class="<?php echo(LABEL_COL); ?>">Slide Transitions</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_mode", "params.mode.value", "horizontal", ["horizontal" => "Horizontal", "vertical" => "Vertical", "fade" => "Fade"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_slideMargin" class="<?php echo(LABEL_COL); ?>">Margin between each slide</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_slideMargin" id="param_slideMargin" ng-model="params.slideMargin.value" class="form-control" data-default="0" min="0" step="1" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_speed" class="<?php echo(LABEL_COL); ?>">Slide transition duration (in ms)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_speed" id="param_speed" ng-model="params.speed.value" class="form-control" data-default="1000" min="0" step="250" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_startSlide" class="<?php echo(LABEL_COL); ?>">Starting slide index (zero-based)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_startSlide" id="param_startSlide" ng-model="params.startSlide.value" class="form-control" data-default="0" min="0" step="1" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_randomStart" class="<?php echo(LABEL_COL); ?>">Random Start</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_randomStart", "params.randomStart.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_slideSelector" class="<?php echo(LABEL_COL); ?>">Element to use as slides (ex. 'div.slide').</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_slideSelector" id="param_slideSelector" ng-model="params.slideSelector.value" class="form-control" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_infiniteLoop" class="<?php echo(LABEL_COL); ?>">Infinite Loop</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_infiniteLoop", "params.infiniteLoop.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_hideControlOnEnd" class="<?php echo(LABEL_COL); ?>">Hide Controls On End</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_hideControlOnEnd", "params.hideControlOnEnd.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_easing" class="<?php echo(LABEL_COL); ?>">Easing</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_easing" id="param_easing" ng-model="params.easing.value" class="form-control custom-select" required data-default="linear">
						<option value="">Choose Easing Effect</option>
						<option value="linear">Linear</option>
						<option value="ease">Ease</option>
						<option value="ease-in">Ease In</option>
						<option value="ease-out">Ease Out</option>
						<option value="ease-in-out">Ease In &amp; Out</option>
					</select>
				</div>
			</div>
			<div class="form-row mb-2">
				<label for="param_captions" class="<?php echo(LABEL_COL); ?>">Captions</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_captions", "params.captions.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_ticker" class="<?php echo(LABEL_COL); ?>">Ticker</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_ticker", "params.ticker.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_tickerHover" class="<?php echo(LABEL_COL); ?>">Ticker Hover</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_tickerHover", "params.tickerHover.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_adaptiveHeight" class="<?php echo(LABEL_COL); ?>">Adaptive Height</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_adaptiveHeight", "params.adaptiveHeight.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_adaptiveHeightSpeed" class="<?php echo(LABEL_COL); ?>">Adaptive Height Speed</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_adaptiveHeightSpeed" id="param_adaptiveHeightSpeed" ng-model="params.adaptiveHeightSpeed.value" class="form-control" data-default="500" min="0" step="250" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_video" class="<?php echo(LABEL_COL); ?>">Include Videos</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_video", "params.video.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_responsive" class="<?php echo(LABEL_COL); ?>">Responsive</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_responsive", "params.responsive.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_useCSS" class="<?php echo(LABEL_COL); ?>">Use CSS Transitions</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_useCSS", "params.useCSS.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_preloadImages" class="<?php echo(LABEL_COL); ?>">Preload Images</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_preloadImages", "params.preloadImages.value", "visible", ["visible" => "Visible Images", "all" => "All Images"]); ?>
				</div>
			</div>
			<div class="form-row mb-2">
				<label for="param_touchEnabled" class="<?php echo(LABEL_COL); ?>">Touch Enabled</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_touchEnabled", "params.touchEnabled.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_swipeThreshold" class="<?php echo(LABEL_COL); ?>">Swipe Threshold</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_swipeThreshold" id="param_swipeThreshold" ng-model="params.swipeThreshold.value" class="form-control" data-default="50" min="0" step="1" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_oneToOneTouch" class="<?php echo(LABEL_COL); ?>">One to One Touch</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_oneToOneTouch", "params.oneToOneTouch.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_preventDefaultSwipeX" class="<?php echo(LABEL_COL); ?>">Prevent Default Swipe X</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_preventDefaultSwipeX", "params.preventDefaultSwipeX.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_preventDefaultSwipeY" class="<?php echo(LABEL_COL); ?>">Prevent Default Swipe Y</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_preventDefaultSwipeY", "params.preventDefaultSwipeY.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_pager" class="<?php echo(LABEL_COL); ?>">Show Pager</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_pager", "params.pager.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_pagerType" class="<?php echo(LABEL_COL); ?>">Pager Type</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_pagerType", "params.pagerType.value", "full", ["full" => "Full", "short" => "Short"]); ?>
				</div>
			</div>
			<div class="form-row mb-2">
				<label for="param_pagerShortSeparator" class="<?php echo(LABEL_COL); ?>">Pager Short Separator</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_pagerShortSeparator" id="param_pagerShortSeparator" ng-model="params.pagerShortSeparator.value" class="form-control" data-default="/" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_pagerSelector" class="<?php echo(LABEL_COL); ?>">Pager Separator</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_pagerSelector" id="param_pagerSelector" ng-model="params.pagerSelector.value" class="form-control" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_pagerCustom" class="<?php echo(LABEL_COL); ?>">Pager Custom</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_pagerCustom" id="param_pagerCustom" ng-model="params.pagerCustom.value" class="form-control" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_buildPager" class="<?php echo(LABEL_COL); ?>">Build Pager</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_buildPager" id="param_buildPager" ng-model="params.buildPager.value" class="form-control" /></div>
			</div>
		</fieldset>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>More Settings</legend>

			<div class="form-row mb-2">
				<label for="param_controls" class="<?php echo(LABEL_COL); ?>">Show Prev/Next Controls</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_controls", "params.controls.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_nextText" class="<?php echo(LABEL_COL); ?>">Text for 'Next'</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_nextText" id="param_nextText" ng-model="params.nextText.value" class="form-control" data-default="Next" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_prevText" class="<?php echo(LABEL_COL); ?>">Text for 'Prev'</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_prevText" id="param_prevText" ng-model="params.prevText.value" class="form-control" data-default="Prev" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_nextSelector" class="<?php echo(LABEL_COL); ?>">Next Selector</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_nextSelector" id="param_nextSelector" ng-model="params.nextSelector.value" class="form-control" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_prevSelector" class="<?php echo(LABEL_COL); ?>">Prev Selector</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_prevSelector" id="param_prevSelector" ng-model="params.prevSelector.value" class="form-control" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoControls" class="<?php echo(LABEL_COL); ?>">Show Start/Stop Controls</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_autoControls", "params.autoControls.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_startText" class="<?php echo(LABEL_COL); ?>">Text for 'Start'</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_startText" id="param_startText" ng-model="params.startText.value" class="form-control" data-default="Start" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_stopText" class="<?php echo(LABEL_COL); ?>">Text for 'Stop'</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_stopText" id="param_stopText" ng-model="params.stopText.value" class="form-control" data-default="Stop" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoControlsCombine" class="<?php echo(LABEL_COL); ?>">Combine Start/Stop Controls</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_autoControlsCombine", "params.autoControlsCombine.value", 0); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoControlsSelector" class="<?php echo(LABEL_COL); ?>">Controls Selector</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_autoControlsSelector" id="param_autoControlsSelector" ng-model="params.autoControlsSelector.value" class="form-control" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_auto" class="<?php echo(LABEL_COL); ?>">Automatically Transition Slides</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_auto", "params.auto.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_pause" class="<?php echo(LABEL_COL); ?>">Pause</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_pause" id="param_pause" ng-model="params.pause.value" class="form-control" data-default="4000" min="0" step="250" /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoStart" class="<?php echo(LABEL_COL); ?>">Auto Start on Load</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_autoStart", "params.autoStart.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoDirection" class="<?php echo(LABEL_COL); ?>">Auto Slide Direction</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_autoDirection", "params.autoDirection.value", "next", ["prev" => "Previous", "next" => "Next"]); ?>
				</div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoHover" class="<?php echo(LABEL_COL); ?>">Pause on Mouse Over</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_autoHover", "params.autoHover.value", 1); ?></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_autoDelay" class="<?php echo(LABEL_COL); ?>">Delay</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_autoDelay" id="param_autoDelay" ng-model="params.autoDelay.value" class="form-control" data-default="0" min="0" step="250" required /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_minSlides" class="<?php echo(LABEL_COL); ?>">Minimum Visible Slides</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_minSlides" id="param_minSlides" ng-model="params.minSlides.value" class="form-control" data-default="1" min="1" step="1" required /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_maxSlides" class="<?php echo(LABEL_COL); ?>">Max Visible Slides</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_maxSlides" id="param_maxSlides" ng-model="params.maxSlides.value" class="form-control" data-default="1" min="1" step="1" required /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_moveSlides" class="<?php echo(LABEL_COL); ?>">Move By # Slides</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_moveSlides" id="param_moveSlides" ng-model="params.moveSlides.value" class="form-control" data-default="1" min="1" step="1" required /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_slideWidth" class="<?php echo(LABEL_COL); ?>">Slide Width</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_slideWidth" id="param_slideWidth" ng-model="params.slideWidth.value" class="form-control" data-default="1200" min="1" step="1" required /></div>
			</div>
			<div class="form-row mb-2">
				<label for="param_slideHeight" class="<?php echo(LABEL_COL); ?>">Slide Height (only for thumbnails)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_slideHeight" id="param_slideHeight" ng-model="params.slideHeight.value" class="form-control" data-default="400" min="1" step="1" required /></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Link Settings</legend>

			<div class="form-row mb-2">
				<label for="param_lightbox" class="<?php echo(LABEL_COL); ?>">Use Lightbox</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_lightbox", "params.lightbox.value", 0); ?></div>
			</div>

			<div ng-if="params.lightbox.value == 1">
				<div class="form-row mb-2">
					<label for="param_lightbox_theme" class="<?php echo(LABEL_COL); ?>">Lightbox Theme</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php angularMultipleChoice("param_lightbox_theme", "params.lightbox_theme.value", "theme3", ["theme1" => "1", "theme2" => "2", "theme3" => "3", "theme4" => "4", "theme5" => "5"]); ?>
					</div>
				</div>

				<div class="form-row mb-2">
					<label for="param_lightbox_width" class="<?php echo(LABEL_COL); ?>">Lightbox Width</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_lightbox_width" id="param_lightbox_width" ng-model="params.lightbox_width.value" class="form-control" data-default="90%" /></div>
				</div>

				<div class="form-row mb-2">
					<label for="param_lightbox_height" class="<?php echo(LABEL_COL); ?>">Lightbox Height</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_lightbox_height" id="param_lightbox_height" ng-model="params.lightbox_height.value" class="form-control" data-default="90%" /></div>
				</div>
			</div>

			<div ng-if="params.lightbox.value != 1">
				<div class="form-row mb-2">
					<label for="param_link" class="<?php echo(LABEL_COL); ?>">Default Link</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_link" id="param_link" ng-model="params.link.value" class="form-control" data-default="" /></div>
				</div>

				<div class="form-row mb-2">
					<label for="param_links" class="<?php echo(LABEL_COL); ?>">Slide Specific Links</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_links" id="param_links" ng-model="params.links.value" class="form-control" min="0" max="20" step="1" data-default="0" required /></div>
				</div>
			</div>
		</fieldset>
	</div>
</div>

<div class="row" ng-if="params.lightbox.value != 1">
	<div class="<?php echo(THREE_COL); ?>" ng-repeat="x in getArray(params.links.value) track by $index">
		<fieldset ng-init="img_index = 'image' + $index; link_index = 'link' + $index">
			<legend>Slide {{$index + 1}} Settings</legend>

			<div class="form-row mb-2">
				<label for="param_{{img_index}}" class="<?php echo(LABEL_COL); ?>">Filename</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{img_index}}" id="param_{{img_index}}" ng-model="params[img_index].value" class="form-control" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{link_index}}" class="<?php echo(LABEL_COL); ?>">Link</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{link_index}}" id="param_{{link_index}}" ng-model="params[link_index].value" class="form-control" required /></div>
			</div>
		</fieldset>
	</div>
</div>
