<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Module Settings</legend>

			<div class="form-row mb-2">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="Our Team" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_number_of_members" class="<?php echo(LABEL_COL); ?>">Number of Members</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_number_of_members" id="param_number_of_members" ng-model="params.number_of_members.value" class="form-control" min="1" step="1" data-default="1" ng-change="init_wysiwyg($event)" ng-disabled="module_form.$dirty" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_circle_size" class="<?php echo(LABEL_COL); ?>">Max Circle Diameter</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_circle_size" id="param_circle_size" ng-model="params.circle_size.value" class="form-control" min="100" step="1" data-default="250" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_column_size" class="<?php echo(LABEL_COL); ?>">Size Of Each Block</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_column_size" id="param_column_size" ng-model="params.column_size.value" class="form-control custom-select" data-default="1-1" required>
						<option value="">Choose a Size</option>
						<option value="1-1">100% (one column)</option>
						<option value="1-2">1&frasl;2 (one half)</option>
						<option value="1-3">1&frasl;3 (one third)</option>
						<option value="2-3">2&frasl;3 (two thirds)</option>
						<option value="1-4">1&frasl;4 (one quarter)</option>
						<option value="1-2">2&frasl;4 (one half)</option>
						<option value="3-4">3&frasl;4 (three quarters)</option>
						<option value="1-5">1&frasl;5 (one fifth)</option>
						<option value="2-5">2&frasl;5 (two fifths)</option>
						<option value="3-5">3&frasl;5 (three fifths)</option>
						<option value="4-5">4&frasl;5 (four fifths)</option>
						<option value="1-6">1&frasl;6 (one sixth)</option>
						<option value="1-3">2&frasl;6 (one third)</option>
						<option value="1-2">3&frasl;6 (one half)</option>
						<option value="2-3">4&frasl;6 (two thirds)</option>
						<option value="5-6">5&frasl;6 (five sixths)</option>
						<option value="2-24">1&frasl;12 (one twelfth)</option>
						<option value="1-6">2&frasl;12 (one sixth)</option>
						<option value="1-4">3&frasl;12 (one quarter)</option>
						<option value="1-3">4&frasl;12 (one third)</option>
						<option value="5-6">5&frasl;12 (five sixths)</option>
						<option value="1-2">6&frasl;12 (one half)</option>
						<option value="10-24">5&frasl;12 (five twelfths)</option>
						<option value="14-24">7&frasl;12 (seven twelfths)</option>
						<option value="2-3">8&frasl;12 (two thirds)</option>
						<option value="3-4">9&frasl;12 (three quarters)</option>
						<option value="5-6">10&frasl;12 (five sixths)</option>
						<option value="22-24">11&frasl;12 (eleven twelfths)</option>
					</select>
				</div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Page Settings</legend>

			<div class="form-row mb-2">
				<label for="param_top_text" class="col-12">Top Text</label>
				<div class="col-12"><textarea ckeditor-basic name="param_top_text" id="param_top_text" ng-model="params.top_text.value" class="form-control" data-default="<p>Get to know our crew, they're your team too.</p>"></textarea></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_bottom_text" class="col-12">Bottom Text</label>
				<div class="col-12"><textarea ckeditor-basic name="param_bottom_text" id="param_bottom_text" ng-model="params.bottom_text.value" class="form-control" data-default="<p>Keep in touch with our dream team by following them on their social media pages.</p>"></textarea></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(THREE_COL); ?>" ng-repeat="n in getArray(params.number_of_members.value) track by $index">
		<fieldset ng-init="name_index = 'name' + ($index+1); link_index = 'link' + ($index+1); title_index = 'title' + ($index+1); photo_upload_index = 'photo_upload' + ($index+1); photo_path_index = 'photo_path' + ($index+1); facebook_index = 'facebook' + ($index+1); twitter_index = 'twitter' + ($index+1); gplus_index = 'gplus' + ($index+1)">
			<legend>Team Member {{$index + 1}}</legend>

			<div class="form-row mb-2">
				<label for="param_{{name_index}}" class="<?php echo(LABEL_COL); ?>">Name</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{name_index}}" id="param_{{name_index}}" ng-model="params[name_index].value" class="form-control" required /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{title_index}}" class="<?php echo(LABEL_COL); ?>">Title</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{title_index}}" id="param_{{title_index}}" ng-model="params[title_index].value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{link_index}}" class="<?php echo(LABEL_COL); ?>">Page Link</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{link_index}}" id="param_{{link_index}}" ng-model="params[link_index].value" class="form-control" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{facebook_index}}" class="<?php echo(LABEL_COL); ?>">Facebook Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-facebook-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="param_{{facebook_index}}" id="param_{{facebook_index}}" ng-model="params[facebook_index].value" class="form-control" placeholder="https://facebook.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{twitter_index}}" class="<?php echo(LABEL_COL); ?>">Twitter Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-twitter-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="param_{{twitter_index}}" id="param_{{twitter_index}}" ng-model="params[twitter_index].value" class="form-control" placeholder="https://twitter.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{gplus_index}}" class="<?php echo(LABEL_COL); ?>">Google Plus Profile</label>
				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fab fa-fw fa-lg fa-google-plus-square" aria-hidden="true"></em></span>
					</div>
					<input type="url" name="param_{{gplus_index}}" id="param_{{gplus_index}}" ng-model="params[gplus_index].value" class="form-control" placeholder="https://plus.google.com" />
				</div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{photo_path_index}}" class="<?php echo(LABEL_COL); ?>">Photo Path</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{photo_path_index}}" id="param_{{photo_path_index}}" ng-model="params[photo_path_index].value" class="form-control" placeholder="Type a path or upload a file below" /></div>
			</div>

			<div class="form-row mb-2">
				<label for="param_{{photo_upload_index}}" class="<?php echo(LABEL_COL); ?>">Upload Photo</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<input type="file" id="param_{{photo_upload_index}}" data-index="{{$index + 1}}" onchange="FileSelectHandler(this)" />
					<span class="uploading{{$index+1}} hidden"><em class="fas fa-spinner fa-pulse" aria-hidden="true"></em></span>
				</div>
			</div>

			<div ng-if="params[photo_path_index].value != '' && params[photo_path_index].value != null" class="photo-frame" style="background-image: url({{params[photo_path_index].value}})"></div>
		</fieldset>
	</div>
</div>

<script>
FileSelectHandler = function(e)
{
	// fetch FileList object
	var files = e.files;
	var index = jQuery(e).attr("data-index");

	// process all File objects
	for (var i = 0, f; f = files[i]; i++)
	{
		ParseFile(f, index);
	}
};

ParseFile = function(file, index)
{
	var oFReader1 = new FileReader();
	oFReader1.readAsDataURL(file);

	oFReader1.onload = function (oFREvent)
    {
    	jQuery(".uploading" + index).removeClass("hidden");

    	var formData = new FormData();
		formData.append("image", file);

		jQuery.ajax({
		    url: "/admin/upload_image",
		    type: "POST",
		    data: formData,
		    processData: false,
		    contentType: false,
		    success:function(data, textStatus, jqXHR)
		    {
		    	jQuery("#param_photo_path" + index).val(data["src"]).change();
		        jQuery(".uploading" + index).addClass("hidden");
		    },
		    error: function(jqXHR, textStatus, errorThrown)
		    {
		    	error("Upload Error", jqXHR.responseText, true, null);
		    	jQuery(".uploading" + index).addClass("hidden");
		    }
		});
    };
};
</script>
