<div class="cart">
	<h1>Shopping Cart</h1>

	<script></script>
	<noscript><h3 class="error center">You need JavaScript enabled in order to place an order.</h3></noscript>

	<?php
	$cart_total = 0;

	if(count($cart_items) > 0)
	{
		?>
		<div class="shop_cart_items">
			<table width="100%" border="0" class="shop_cart_item">
				<tr><th class="shop_cart_column_name">Product</th><th class="shop_cart_column_quantity">Quantity</th><th class="shop_cart_column_price">Price</th><th class="shop_cart_column_total">Total</th></tr>
			</table>

			<?php
			foreach($cart_items as $item)
			{
				$product = new Shop_Product();
				$product->LoadWithImages($item->product_id);
				$product_url = $product->url;
				$options = unserialize($item->product_options);
				$deposit = ($product->deposit_price > 0);
				?>
				<form name="" id="" method="post" action="<?php echo($cart_url); ?>" class="pure-form pure-form-aligned">
					<?php csrf(); ?>
					<table width="100%" border="0" class="shop_cart_item">
						<?php FeralHidden("task", "update"); ?>
						<?php FeralHidden("cart_id", $item->cart_id); ?>

						<tr style="visibility: hidden; height: 0; line-height: 0;"><th class="shop_cart_column_name">Product</th><th class="shop_cart_column_quantity">Quantity</th><th class="shop_cart_column_price">Price</th><th class="shop_cart_column_total">Total</th></tr>
						<tr>
							<td class="shop_cart_column_name">
								<a href="/<?php echo($product_url); ?>"><?php echo($item->product_name . ($item->product_variant_id ? ' (' . $item->variant . ')' : '')); ?></a>
							</td>
							<td class="shop_cart_column_quantity shop_cart_column_buttons">
								<input type="number" name="quantity" id="quantity<?php echo($item->cart_id); ?>" value="<?php echo($item->quantity); ?>" min="0" max="9999" class="quantity" required />

								<button type="submit" name="update" value="1" class="pure-button pure-button-secondary" title="Update Quantity"><em class="fas fa-fw fa-sync" aria-hidden="true"></em></button>
								<button type="submit" name="remove" value="1" class="pure-button pure-button-secondary" title="Remove From Cart"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></button>
							</td>
							<td class="shop_cart_column_price"><?php echo("$" . number_format($item->price, 2) . ($deposit ? " (Deposit)" : "")); ?></td>
							<td class="shop_cart_column_total"><?php echo("$" . number_format(($item->quantity * $item->price), 2)); ?></td>
						</tr>

						<?php
						if(is_array($options) && count($options) > 0)
						{
							foreach($options as $option)
							{
								if($option->option_type == "checkbox")
								{
									$option_label = $option->option_label;
								}
								else
								{
									$option_label = $option->option_label . ": " . $option->option_value;
								}

								// Radios and select lists which have price overrides need to set $option->price_change manually.
								switch($option->option_type)
								{
									case "radio":
									case "select":
									{
										$option_values = explode("\n", $option->option_values);

										foreach($option_values as $option_value)
										{
											$values = explode("|", $option_value);

											if($values[0] == $option->option_value)
											{
												if(count($values) < 2)
												{
													continue;
												}
												// $option_label = $values[0];
												$option->price_change = number_format(($values[2] ? $values[2] : 0), 2);
											}
										}

										break;
									}
									default:
									{
										// Do nothing, $option->price_change already holds the right value.
									}
								}

								if($deposit)
								{
									$option->price_change = 0;
								}
								?>
								<tr>
									<td class="shop_cart_column_name"><?php echo($option_label); ?></td>
									<td class="shop_cart_column_quantity shop_cart_column_buttons">&nbsp;</td>
									<td class="shop_cart_column_price"><?php echo(($option->price_change > 0 ? "$" . number_format($option->price_change, 2) : "&nbsp;")); ?></td>
									<td class="shop_cart_column_total"><?php echo(($option->price_change > 0 ? "$" . number_format(($item->quantity * $option->price_change), 2) : "&nbsp;")); ?></td>
								</tr>
								<?php
								$cart_total += ($item->quantity * $option->price_change);
							}
						}
						?>
					</table>
				</form>
				<?php
				$cart_total += ($item->quantity * $item->price);
			}
			?>
			<table width="100%" border="0" class="shop_cart_item">
				<tr style="visibility: hidden;"><th class="shop_cart_column_name">Product</th><th class="shop_cart_column_quantity">Quantity</th><th class="shop_cart_column_price">Price</th><th class="shop_cart_column_total">Total</th></tr>
				<tr>
					<th colspan="3" class="right">Subtotal:</th>
					<td class="shop_cart_column_total">$<?php echo(number_format($cart_total, 2)); ?></td>
				</tr>
				<?php
				if(count($taxes) > 0)
				{
					$taxes_total = 0;
					$cart_total_before_taxes = $cart_total;

					foreach($taxes as $tax)
					{
						$tax_amount = $tax->tax_percentage * $cart_total_before_taxes;
						$taxes_total += $tax_amount;
						$tax_display = $tax->tax_name . " (" . $tax->tax_province . " " . ($tax->tax_percentage * 100) . "%)";
						?>
						<tr>
							<th colspan="3" class="right"><?php echo($tax_display); ?></th>
							<td class="shop_cart_column_total"><?php echo("$" . number_format($tax_amount, 2)); ?></td>
						</tr>
						<?php
						$cart_total += $tax_amount;
					}
				}
				?>
				<tr>
					<th colspan="3" class="right">Cart Total (<?php echo((class_exists("Shop") ? Shop::currency() : "CAD")); ?>):</th>
					<td class="shop_cart_column_total" id="shop_cart_total">$<?php echo(number_format($cart_total, 2)); ?></td>
				</tr>
			</table>
			<p class="right">Shipping costs and applicable taxes will be updated at the checkout.</p>

			<div class="shop_cart_buttons">
				<a class="pure-button pure-button-secondary" href="<?php echo($checkout_url); ?>"><em class="fas fa-gift" aria-hidden="true"></em> Checkout</a>
			</div>
		</div>
		<?php
	}
	else
	{
		?><p>Your cart is empty.</p><?php
	}

	if(count($related_products) > 0)
	{
		$currencies = Shop::get_currencies();
		$this->load->model("shop/shop_product");
		?>
		<div class="padded">
			<h3>You Might Also Be Interested In These Related Products</h3>

			<div class="pure-g shop_products shop_related_products">
				<?php
				//shuffle($related_products);
				//$related_products = array_slice($related_products, 0, 5);

				foreach($related_products as $related_product)
				{
					$layout = new Shop_Product_Layout();
					$layout->Load($related_product->product_layout_id);

					?>
					<div class="pure-u-1-3">
						<?php $this->load->view("shop/" . str_replace("product_", "product_snapshot_", $layout->view_filename), array("product" => $related_product, "layout" => $layout, "show_category" => false, "show_usd" => true)); ?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
	?>
</div>
