<?php
echo form_open_multipart("shop_admin/category_save", array("id" => "category_form", "class" => "nvForm"));
echo form_hidden("category_id", $category->category_id);
csrf();

FeralHidden("datasource_category_id", $category->datasource_category_id);
FeralHidden("category_image_id", $category->category_image_id);
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Category</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/shop_admin/categories" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<?php
		if(count($sites) > 1)
		{
			?>
			<div class="form-row mb-2">
				<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("site_id", ($category->site_id ? $category->site_id : Mainframe::active_site_id()), "form-control custom-select");

					foreach($sites as $site)
					{
						$wgt->AddOption($site->site_id, $site->name);
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<?php
		}
		else
		{
			echo form_hidden("site_id", ($category->site_id ? $category->site_id : Mainframe::active_site_id()));
		}
		?>

		<div class="form-row mb-2">
			<label for="parent_category_id" class="<?php echo(LABEL_COL); ?>">Parent Category</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("parent_category_id", $category->parent_category_id, "form-control custom-select");
				$wgt->AddOption("", "Top Level");

				usort($categories, "shop_sort_categories");

				foreach($categories as $cat)
				{
					$c = new Shop_Category();
					$c->load($cat->category_id);
					$label = str_replace("Home / ", "", strip_tags(str_replace("</li>", " > ", $c->GetBreadCrumbs())));
					$label = preg_replace('/ > $/', '', $label); // remove trailing >

					if(!$label)
					{
						// This will happen if a parent category is not published or for whatever other reason there is no route.
						continue;
					}

					$wgt->AddOption($cat->category_id, $label);
				}
				$wgt->Create();
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="category_name" class="<?php echo(LABEL_COL); ?>">Category Name</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "category_name",
				              "id"          => "category_name",
				              "value"       => $category->category_name,
				              "placeholder" => 'Category Name',
				              "required"	=> "required",
				              "onblur"		=> "updateURL(this, 'url', null, " . ($category->category_id ? 'false' : 'true') . ");",
				              "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "url",
				              "id"          => "url",
				              "value"       => $category->url,
				              "placeholder" => "The URL will display in the address bar of the user's web browser.",
				              "title"		=> "Please enter a URL using only letters, numbers, dashes, underscores, or forward slashes.  Do not include '.html' in your URL.",
				              "pattern"		=> "[A-Za-z0-9/\-_]*",
				              "onkeyup"		=> "jQuery('#url_preview').html(this.value)",
				              "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label class="<?php echo(LABEL_COL); ?>"></label>
			<div class="<?php echo(FIELD_COL); ?>">
				<div class="alert alert-info"><a href="<?php echo(LIVE_SITE); ?>/shop/<?php echo($category->url); ?>" target="_blank"><?php echo(LIVE_SITE); ?>/shop/<span id="url_preview"><?php echo($category->url); ?></span></a></div>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="page_title" class="<?php echo(LABEL_COL); ?>">Page Title</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "page_title",
				              "id"          => "page_title",
				              "value"       => $category->page_title,
				              "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="meta_description" class="<?php echo(LABEL_COL); ?>">Meta Description</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "meta_description",
				              "id"          => "meta_description",
				              "value"       => $category->meta_description,
				              "placeholder" => 'Meta Description',
				              "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="category_layout_id" class="<?php echo(LABEL_COL); ?>">Layout</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("category_layout_id", $category->category_layout_id, "form-control custom-select");

				foreach($layouts as $layout)
				{
					$wgt->AddOption($layout->category_layout_id, $layout->layout_name);
				}
				$wgt->Create();
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="default_product_layout_id" class="<?php echo(LABEL_COL); ?>">Default Product Layout</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("default_product_layout_id", $category->default_product_layout_id, "form-control custom-select");

				foreach($product_layouts as $layout)
				{
					$wgt->AddOption($layout->product_layout_id, $layout->layout_name);
				}
				$wgt->Create();
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="not_authorized_page_id" class="<?php echo(LABEL_COL); ?>">Not Authorized Page</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("not_authorized_page_id", $category->not_authorized_page_id, "form-control custom-select");
				$wgt->AddOption("", "N/A");

				foreach($pages as $p)
				{
					$wgt->AddOption($p->page_id, $p->title);
				}
				$wgt->Create();
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="sort" class="<?php echo(LABEL_COL); ?>">Sort Order</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "sort",
				              "id"          => "sort",
				              "value"       => ($category->sort ? $category->sort : 1),
				              "type" 		=> 'number',
				              "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="published" class="<?php echo(LABEL_COL); ?>">Published</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php yesNo("published", (isset($category->category_id) && $category->category_id > 0 ? $category->published : "1")); ?>
			</div>
		</div>

		<div class="form-row mb-2">
			<label for="category_image" class="<?php echo(LABEL_COL); ?>">Upload Image</label>

			<div class="<?php echo(FIELD_COL); ?>"><input type="file" name="category_image" id="category_image" /></div>
		</div>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<h2>Which Shopper Groups Can Access This Category?</h2>

		<?php
		if(isset($shopper_groups))
		{
			if(count($shopper_groups) == 0)
			{
				?><div class="alert alert-danger">No shopper groups defined yet.</div><?php
			}
			foreach($shopper_groups as $shopper_group)
			{
				FeralCheckbox("shopper_group_" . $shopper_group->shopper_group_id, $shopper_group->active);
				echo(" <label for='shopper_group_" . $shopper_group->shopper_group_id . "_checkbox'>" . $shopper_group->group_name . "</label><br />");
			}
		}
		?>
	</div>

	<div class="col-12">
		<div class="form-row mb-2">
			<label for="category_description" class="col-12">Description</label>
			<div class="col-12"><?php FeralTextArea("category_description", $category->category_description, "form-control"); ?></div>
		</div>
	</div>
</div>
<?php
echo form_close();
full_wysiwyg("category_description");
