<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Shop Categories</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/shop_admin/category?id=0" class="btn btn-primary"><em class="fas fa-tags" aria-hidden="true"></em> Add Category</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"ajax": "/ajax/get_shop_categories",
			"pageLength": 50,
			"order": [[2,'desc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "category_name", "title": "Category", "width": "30%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/shop_admin/category?id=' + row["category_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "category_path_string", "title": "Category Path", "width": "50%", "className": "click", "searchable": true},
		        { "data": "published", "title": "Published", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	if(data == "1")
	                    {
	                    	return "Yes";
	                    }
	                    else
	                    {
	                    	return "No";
	                    }
			        }},
		        { "data": "category_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function() { window.location=\'/shop_admin/category_delete?id=' + data + '\'; }); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/shop_admin/category?id={id}");
			}
		});
	});
</script>
