<div class="cart">
	<h1>Checkout</h1>
	<h2>Shopping Cart</h2>

	<script></script>
	<noscript><h3 class="error center">You need JavaScript enabled in order to place an order.</h3></noscript>

	<?php
	$edit = ($task != "confirm");

	if($edit)
	{
		$next_task = "confirm";
	}
	else
	{
		$next_task = "process";
	}

	if(isset($checkout_errors) && is_array($checkout_errors))
	{
		foreach($checkout_errors as $error)
		{
			?><div class="error center"><?php echo($error); ?></div><?php
		}
	}
	$cart_total = 0;

	if(count($cart_items) > 0)
	{
		?>
		<div class="shop_cart_items" id="shop_cart_items">
			<table width="100%" border="0" class="shop_cart_item">
				<tr><th class="shop_cart_column_name">Product</th><th class="shop_cart_column_quantity">Quantity</th><th class="shop_cart_column_price">Price</th><th class="shop_cart_column_total">Total</th></tr>

				<?php

				foreach($cart_items as $item)
				{
					$product = new Shop_Product();
					$product->LoadWithImages($item->product_id);
					$product_url = $product->url;
					$options = unserialize($item->product_options);
					$deposit = ($product->deposit_price > 0);
					?>
					<tr>
						<td class="shop_cart_column_name"><a href="/<?php echo($product_url); ?>"><?php echo($item->product_name . ($item->product_variant_id ? ' (' . $item->variant . ')' : '')); ?></a></td>
						<td class="shop_cart_column_quantity"><?php echo($item->quantity); ?></td>
						<td class="shop_cart_column_price"><?php echo("$" . number_format($item->price, 2) . ($deposit ? " (Deposit)" : "")); ?></td>
						<td class="shop_cart_column_total"><?php echo("$" . number_format(($item->quantity * $item->price), 2)); ?></td>
					</tr>

					<?php
					if(is_array($options) && count($options) > 0)
					{
						foreach($options as $option)
						{
							if($option->option_type == "checkbox")
							{
								$option_label = $option->option_label;
							}
							else
							{
								$option_label = $option->option_label . ": " . $option->option_value;
							}

							// Radios and select lists which have price overrides need to set $option->price_change manually.
							switch($option->option_type)
							{
								case "radio":
								case "select":
								{
									$option_values = explode("\n", $option->option_values);

									foreach($option_values as $option_value)
									{
										$values = explode("|", $option_value);

										if($values[0] == $option->option_value)
										{
											if(count($values) < 2)
											{
												continue;
											}
											// $option_label = $values[0];
											$option->price_change = number_format(($values[2] ? $values[2] : 0), 2);
										}
									}

									break;
								}
								default:
								{
									// Do nothing, $option->price_change already holds the right value.
								}
							}

							if($deposit)
							{
								$option->price_change = 0;
							}
							?>
							<tr>
								<td class="shop_cart_column_name"><?php echo($option_label); ?></td>
								<td class="shop_cart_column_quantity shop_cart_column_buttons">&nbsp;</td>
								<td class="shop_cart_column_price"><?php echo(($option->price_change > 0 ? "$" . number_format($option->price_change, 2) : "&nbsp;")); ?></td>
								<td class="shop_cart_column_total"><?php echo(($option->price_change > 0 ? "$" . number_format(($item->quantity * $option->price_change), 2) : "&nbsp;")); ?></td>
							</tr>
							<?php
							$cart_total += ($item->quantity * $option->price_change);
						}
					}

					$cart_total += ($item->quantity * $item->price);
				}
				?>
				<tr><td colspan="4">&nbsp;</td></tr>
				<tr id="shop_cart_subtotal_row">
					<th colspan="3" class="right">Subtotal:</th>
					<td class="shop_cart_column_total">$<?php echo(number_format($cart_total, 2)); ?></td>
				</tr>
				<tr id="shop_cart_shipping_row">
					<th colspan="3" class="right">Shipping:</th>
					<td class="shop_cart_column_total" id="shop_cart_shipping">$<?php echo(number_format((isset($payment_vars["shipping_total"]) ? $payment_vars["shipping_total"] : 0), 2)); ?></td>
				</tr>
				<?php

				$taxes_total = 0;

				if(count($taxes) > 0)
				{
					$cart_total_before_taxes = $cart_total;

					foreach($taxes as $tax)
					{
						$tax_amount = $tax->tax_percentage * $cart_total_before_taxes;
						$taxes_total += $tax_amount;
						$tax_display = $tax->tax_name . " (" . $tax->tax_province . " " . ($tax->tax_percentage * 100) . "%)";
						?>
						<tr class="shop_cart_tax_row">
							<th colspan="3" class="right"><?php echo($tax_display); ?></th>
							<td class="shop_cart_column_total"><?php echo("$" . number_format($tax_amount, 2)); ?></td>
						</tr>
						<?php
						//$cart_total += $tax_amount;
					}
				}
				?>
				<tr>
					<th colspan="3" class="right">Cart Total (<?php echo((class_exists("Shop") ? Shop::currency() : "CAD")); ?>):</th>
					<td class="shop_cart_column_total shop_cart_total" id="shop_cart_total">$<?php echo(number_format($cart_total, 2)); ?></td>
				</tr>
				<tr><td colspan="4">&nbsp;</td></tr>
			</table>

			<p class="right"><a class="pure-button pure-button-secondary" href="<?php echo($cart_url); ?>"><em class="fas fa-shopping-cart" aria-hidden="true"></em> Modify Cart</a></p>
		</div>
		<?php
	}
	else
	{
		?><p>Your cart is empty.</p></div><?php
	}

	$gateway_data = array();
	$gateway_data["cart_items"] 	= $cart_items;
	$gateway_data["payment_vars"] 	= $payment_vars;
	$gateway_data["shipping_vars"] 	= $shipping_vars;

	if(!isset($user->user_id) || $user->user_id <= 0)
	{
		?>
		<h2>Create an Account (Optional)</h2>
		<p>You are currently checking out as a guest.  If you <a href="/register?redirect=<?php echo(rawurlencode("/shop/checkout")); ?>">create an account</a> or <a href="/user-login?redirect=<?php echo(rawurlencode("/shop/checkout")); ?>">login to your existing account</a> you will be able to view order status and maintain an order history.
		<b>Creating an account is entirely optional.</b></p>
		<?php
	}

	if($edit)
	{
		$col_class = "pure-u-1 pure-form-aligned";
	}
	else
	{
		$col_class = "pure-u-1-2 pure-form-aligned";
	}

	if($edit)
	{
		?>
		<form name="shop_cart_billing_shipping" id="shop_cart_billing_shipping" class="pure-form pure-form-aligned" method="post" action="<?php echo($checkout_url); ?>" onsubmit="shop_order_submit();">
			<?php csrf(); ?>
			<input type="hidden" name="task" id="task" value="<?php echo($next_task); ?>" />
			<input type="hidden" name="shop_cart_total_unformatted" id="shop_cart_total_unformatted" value="<?php echo($cart_total); ?>" />
			<input type="hidden" name="shop_cart_tax_unformatted" id="shop_cart_tax_unformatted" value="<?php echo($taxes_total); ?>" />
			<input type="hidden" name="shop_cart_shipping_unformatted" id="shop_cart_shipping_unformatted" value="0.00" />
		<?php
	}
	?>
	<div class="pure-g">
		<div class="<?php echo($col_class); ?>">
			<div class="padded">
				<h2>Billing Information</h2>

				<?php
				if($edit)
				{
					?><fieldset><legend>Method of Payment</legend><?php
					$qualified = 0;

					foreach($payment_gateways as $gateway)
					{
						$c = $gateway->filename;
						$this->load->model("payment/" . $c);
						$g = new $c();

						if($g->qualifies($gateway_data))
						{
							$qualified++;
							?><div><input type="radio" class="payment_gateway_radio" name="payment_gateway_id" id="payment_gateway<?php echo($gateway->payment_gateway_id); ?>" value="<?php echo($gateway->payment_gateway_id); ?>" required /> <label for="payment_gateway<?php echo($gateway->payment_gateway_id); ?>" class="payment_gateway_label"><?php echo($gateway->gateway_name); ?></label></div><?php
						}
					}

					// If only one payment gateway is shown, hide it as a choice.
					if($qualified == 1)
					{
						?>
						<script>
						jQuery(".payment_gateway_radio").attr("type", "hidden");
						jQuery(".payment_gateway_label").hide();
						</script>
						<?php
					}
					?></fieldset><?php
				}
				else
				{
					//show billing summary
					?>
					<div class="pure-control-group">
						<label>Order Total:</label>
						$<?php echo(number_format($payment_vars["order_total"], 2)); ?>
					</div>

					<div class="pure-control-group">
						<label>Payment Type:</label>
						<?php echo($payment_vars["payment_gateway"]->gateway_name); ?>
					</div>

					<?php
					if(file_exists(APPLICATION_PATH . "/views/shop/payment/" . $payment_vars["payment_gateway"]->filename . "_summary.php"))
					{
						$summary_data = array("payment_vars" => $payment_vars);
						$this->load->view("shop/payment/" . $payment_vars["payment_gateway"]->filename . "_summary", $payment_vars);
					}
				}
				?>
				<div id="payment_gateway"></div>
			</div>
		</div>

		<div class="<?php echo($col_class); ?>">
			<div class="padded">
				<h2>Shipping Information</h2>

				<?php
				if($edit)
				{
					?>
					<div class="pure-g">
						<div class="pure-u-1-2">
							<div class="pure-control-group">
								<label for="shipping_name">Name</label>
								<input type="text" name="shipping_name" id="shipping_name" value="<?php echo((isset($shipping_vars["shipping_name"]) ? $shipping_vars["shipping_name"] : $user->fname . " " . $user->lname)); ?>" required />
							</div>

							<div class="pure-control-group">
								<label for="shipping_phone">Phone Number</label>
								<input type="tel" name="shipping_phone" id="shipping_phone" value="<?php echo((isset($shipping_vars["shipping_phone"]) ? $shipping_vars["shipping_phone"] : $user->phone)); ?>" required />
							</div>

							<div class="pure-control-group">
								<label for="shipping_email">Email Address</label>
								<input type="email" name="shipping_email" id="shipping_email" value="<?php echo((isset($shipping_vars["shipping_email"]) ? $shipping_vars["shipping_email"] : $user->email)); ?>" required />
							</div>

							<div class="pure-control-group">
								<label for="shipping_postalcode">Postal Code</label>
								<input type="text" name="shipping_postalcode" id="shipping_postalcode" value="<?php echo((isset($shipping_vars["shipping_postalcode"]) ? $shipping_vars["shipping_postalcode"] : $user->shipping_postalcode)); ?>" onchange="postalcode_lookup();" required />
							</div>
						</div>

						<div class="pure-u-1-2">
							<div class="pure-control-group">
								<label for="shipping_address">Address</label>
								<input type="text" name="shipping_address" id="shipping_address" value="<?php echo((isset($shipping_vars["shipping_address"]) ? $shipping_vars["shipping_address"] : $user->shipping_address)); ?>" required />
							</div>

							<div class="pure-control-group">
								<label for="shipping_city" class="shop-spinner">City</label>
								<input type="text" name="shipping_city" id="shipping_city" value="<?php echo((isset($shipping_vars["shipping_city"]) ? $shipping_vars["shipping_city"] : $user->shipping_city)); ?>" onchange="update_shipping_gateway();" required />
							</div>

							<div class="pure-control-group">
								<label for="shipping_province" class="shop-spinner">Province</label>

								<?php
								$wgt = new FeralBasicSelectWidget("shipping_province", (isset($shipping_vars["shipping_province"]) ? $shipping_vars["shipping_province"] : ($user->shipping_province ? $user->shipping_province : "ON")));
								$wgt->AddOption("", "----- Canada -----");
								$wgt->AddOption("AB", "Alberta");
								$wgt->AddOption("BC", "British Columbia");
								$wgt->AddOption("MB", "Manitoba");
								$wgt->AddOption("NB", "New Brunswick");
								$wgt->AddOption("NL", "Newfoundland and Labrador");
								$wgt->AddOption("NT", "Northwest Territories");
								$wgt->AddOption("NS", "Nova Scotia");
								$wgt->AddOption("NU", "Nunavut");
								$wgt->AddOption("ON", "Ontario");
								$wgt->AddOption("PE", "Prince Edward Island");
								$wgt->AddOption("QC", "Quebec");
								$wgt->AddOption("SK", "Saskatchewan");
								$wgt->AddOption("YT", "Yukon");

								$wgt->AddOption("", "----- United States -----");
								$wgt->AddOption('AL', "Alabama");
								$wgt->AddOption('AK', "Alaska");
								$wgt->AddOption('AZ', "Arizona");
								$wgt->AddOption('AR', "Arkansas");
								$wgt->AddOption('CA', "California");
								$wgt->AddOption('CO', "Colorado");
								$wgt->AddOption('CT', "Connecticut");
								$wgt->AddOption('DE', "Delaware");
								$wgt->AddOption('DC', "District Of Columbia");
								$wgt->AddOption('FL', "Florida");
								$wgt->AddOption('GA', "Georgia");
								$wgt->AddOption('HI', "Hawaii");
								$wgt->AddOption('ID', "Idaho");
								$wgt->AddOption('IL', "Illinois");
								$wgt->AddOption('IN', "Indiana");
								$wgt->AddOption('IA', "Iowa");
								$wgt->AddOption('KS', "Kansas");
								$wgt->AddOption('KY', "Kentucky");
								$wgt->AddOption('LA', "Louisiana");
								$wgt->AddOption('ME', "Maine");
								$wgt->AddOption('MD', "Maryland");
								$wgt->AddOption('MA', "Massachusetts");
								$wgt->AddOption('MI', "Michigan");
								$wgt->AddOption('MN', "Minnesota");
								$wgt->AddOption('MS', "Mississippi");
								$wgt->AddOption('MO', "Missouri");
								$wgt->AddOption('MT', "Montana");
								$wgt->AddOption('NE', "Nebraska");
								$wgt->AddOption('NV', "Nevada");
								$wgt->AddOption('NH', "New Hampshire");
								$wgt->AddOption('NJ', "New Jersey");
								$wgt->AddOption('NM', "New Mexico");
								$wgt->AddOption('NY', "New York");
								$wgt->AddOption('NC', "North Carolina");
								$wgt->AddOption('ND', "North Dakota");
								$wgt->AddOption('OH', "Ohio");
								$wgt->AddOption('OK', "Oklahoma");
								$wgt->AddOption('OR', "Oregon");
								$wgt->AddOption('PA', "Pennsylvania");
								$wgt->AddOption('RI', "Rhode Island");
								$wgt->AddOption('SC', "South Carolina");
								$wgt->AddOption('SD', "South Dakota");
								$wgt->AddOption('TN', "Tennessee");
								$wgt->AddOption('TX', "Texas");
								$wgt->AddOption('UT', "Utah");
								$wgt->AddOption('VT', "Vermont");
								$wgt->AddOption('VA', "Virginia");
								$wgt->AddOption('WA', "Washington");
								$wgt->AddOption('WV', "West Virginia");
								$wgt->AddOption('WI', "Wisconsin");
								$wgt->AddOption('WY', "Wyoming");

								$wgt->SetAttribute("onchange", "if(this.selectedIndex <= 13) { document.getElementById('shipping_country').selectedIndex = 0; } else { document.getElementById('shipping_country').selectedIndex = 1; } update_shipping_gateway();");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>

							<div class="pure-control-group">
								<label for="shipping_country" class="shop-spinner">Country</label>
								<?php
								$wgt = new FeralBasicSelectWidget("shipping_country", (isset($shipping_vars["shipping_country"]) ? $shipping_vars["shipping_country"] : ($user->shipping_country ? $user->shipping_country : "CA")));
								$wgt->SetAttribute("onchange", "update_shipping_gateway();");
								$wgt->SetAttribute("required", "required");
								$wgt->AddOption("CA", "Canada");
								$wgt->AddOption("US", "United States");
								$wgt->Create();
								?>
							</div>
						</div>
					</div>
					<div class="clear"></div>

					<fieldset><legend>Shipping Method</legend><?php
					$qualifies = 0;

					foreach($shipping_gateways as $gateway)
					{
						$c = $gateway->filename;
						$this->load->model("shipping/" . $c);
						$g = new $c();

						if($g->qualifies($gateway_data))
						{
							$qualifies++;
							?><div><input type="radio" class="shipping_gateway_radio" name="shipping_gateway_id" id="shipping_gateway<?php echo($gateway->shipping_gateway_id); ?>" value="<?php echo($gateway->shipping_gateway_id); ?>" required /> <label for="shipping_gateway<?php echo($gateway->shipping_gateway_id); ?>" class="shipping_gateway_label"><?php echo($gateway->gateway_name); ?></label></div><?php
						}


						// If only one shipping gateway is shown, hide it as a choice.
						if($qualified == 1)
						{
							?>
							<script>
							jQuery(".shipping_gateway_radio").attr("type", "hidden");
							jQuery(".shipping_gateway_label").hide();
							</script>
							<?php
						}
					}
					?></fieldset><?php
				}
				else
				{
					//show shipping summary

					FeralHidden("shipping_province", (isset($shipping_vars["shipping_province"]) ? $shipping_vars["shipping_province"] : "ON"));
					FeralHidden("shipping_country", (isset($shipping_vars["shipping_country"]) ? $shipping_vars["shipping_country"] : "CA"));
					?>
					<script>
					jQuery(window).on("load", function()
					{
						shop_update_shipping_cost(<?php echo(number_format((isset($payment_vars["shipping_total"]) ? $payment_vars["shipping_total"] : 0), 2)); ?>);
					});
					</script>

					<div class="pure-control-group">
						<label>Shipping Method:</label>
						<?php echo((isset($shipping_vars["shipping_gateway_service"]) ? $shipping_vars["shipping_gateway_service"] : $shipping_vars["shipping_gateway"]->gateway_name)); ?>
					</div>

					<div class="pure-control-group">
						<label><?php echo($shipping_vars["shipping_gateway"]->filename == "pickup" ? "Ordered By:" : "Shipping To:"); ?></label>
						<?php echo($shipping_vars["shipping_name"]); ?>
					</div>
					<div class="pure-control-group">
						<label></label>
						<?php echo($shipping_vars["shipping_address"]); ?>
					</div>
					<div class="pure-control-group">
						<label></label>
						<?php echo($shipping_vars["shipping_city"] . ", " . $shipping_vars["shipping_province"] . "&nbsp;&nbsp;" . $shipping_vars["shipping_postalcode"]); ?>
					</div>
					<div class="pure-control-group">
						<label></label>
						<?php echo($shipping_vars["shipping_country"]); ?>
					</div>

					<div class="pure-control-group">
						<label>Phone:</label>
						<?php echo($shipping_vars["shipping_phone"]); ?>
					</div>

					<div class="pure-control-group">
						<label>Email:</label>
						<?php echo($shipping_vars["shipping_email"]); ?>
					</div>
					<?php
				}
				?>
				<div id="shipping_gateway"></div>
			</div>
		</div>

		<?php
		if(!$edit)
		{
			?>
			<div class="pure-u-1">
				<div class="padded center">
					<a class="pure-button pure-button-secondary" href="/shop/checkout"><em class="fas fa-pencil-alt" aria-hidden="true"></em> Edit Billing or Shipping Information</a>
				</div>
			</div>
			<?php
		}
		?>
	</div>

	<?php
	if($edit)
	{
			?>
			<h2>Continue</h2>
			<p>Your order will be confirmed on the next screen.</p>
			<p class="right"><button type="submit" class="pure-button pure-button-secondary" id="shop_continue"><em class="fas fa-arrow-right" aria-hidden="true"></em> Continue</button></p>
		</form>

		<?php
	}
	else
	{
		?>
		<form name="shop_cart_billing_shipping" id="shop_cart_billing_shipping" class="pure-form pure-form-aligned" method="post" action="<?php echo($checkout_url); ?>" onsubmit="shop_order_submit();">
			<?php csrf(); ?>
			<input type="hidden" name="task" id="task" value="<?php echo($next_task); ?>" />
			<input type="hidden" name="shop_cart_total_unformatted" id="shop_cart_total_unformatted" value="<?php echo($cart_total); ?>" />
			<input type="hidden" name="shop_cart_tax_unformatted" id="shop_cart_tax_unformatted" value="<?php echo($taxes_total); ?>" />
			<input type="hidden" name="shop_cart_shipping_unformatted" id="shop_cart_shipping_unformatted" value="0.00" />

			<h2>Confirm Order</h2>
			<p class="confirm-order">
				<input type="checkbox" id="confirm-order" name="confirm-order" value="0" title="Please check this box to indicate that you have read this paragraph." required />
				<label for="confirm-order">I agree to pay <span class="shop_cart_total">$<?php echo(number_format($cart_total, 2)); ?></span> for the above listed item(s). I understand that clicking "Submit Order" below will process my payment immediately and any refunds will be subject to our refund policy. Any deposits paid on items are non refundable.</label>
			</p>
			<p class="right"><button type="submit" class="pure-button pure-button-secondary" id="shop-submit-order"><em class="fas fa-thumbs-up" aria-hidden="true"></em> Submit Order</button></p>
		</form>
		<?php
	}

	if($edit)
	{
		foreach($payment_gateways as $gateway)
		{
			$gateway_data["my_gateway"] = $gateway;
			?>
			<div class="payment_gateway" id="payment_gateway<?php echo($gateway->payment_gateway_id); ?>form">
				<?php $this->load->view("shop/payment/" . $gateway->filename, $gateway_data); ?>
			</div>
			<?php
		}

		/*foreach($shipping_gateways as $gateway)
		{
			$gateway_data["my_gateway"] = $gateway;
			?>
			<div class="shipping_gateway" id="shipping_gateway<?php echo($gateway->shipping_gateway_id); ?>form">
				<h3><?php echo($gateway->gateway_name); ?></h3>
				<?php $this->load->view("shop/shipping/" . $gateway->filename, $gateway_data); ?>
			</div>
			<?php
		}*/

		?>


		<script>
		var shop_active_shipping_gateway = 0;

		jQuery(window).on("load", function()
		{
			jQuery('.payment_gateway_radio').click(function()
			{
				show_payment_gateway(jQuery(this).val());
			});

			jQuery('.shipping_gateway_radio').click(function()
			{
				jQuery("#shop_continue").prop("disabled", true);
				jQuery("#shop_continue").attr("title", "You must choose a shipping method in order to continue.");

				shop_active_shipping_gateway = jQuery(this).val();

				update_shipping_gateway();
				shop_update_taxes();
			});

			<?php
			foreach($payment_gateways as $gateway)
			{
				?>
				jQuery("#payment_gateway<?php echo($gateway->payment_gateway_id); ?>").prop("checked", false);
				<?php
			}
			foreach($shipping_gateways as $gateway)
			{
				?>
				jQuery("#shipping_gateway<?php echo($gateway->shipping_gateway_id); ?>").prop("checked", false);
				<?php
			}

			if(isset($payment_vars["payment_gateway_id"]))
			{
				?>jQuery('#payment_gateway<?php echo($payment_vars["payment_gateway_id"]); ?>').click();<?php
			}
			else if(count($payment_gateways) == 1)
			{
				?>jQuery('.payment_gateway_radio').eq(0).click();<?php
			}

			if(isset($shipping_vars["shipping_gateway_id"]))
			{
				?>jQuery('#shipping_gateway<?php echo($shipping_vars["shipping_gateway_id"]); ?>').click();<?php
			}
			else if(isset($shipping_gateways) && count($shipping_gateways) >= 1)
			{
				?>jQuery('.shipping_gateway_radio').eq(0).click();<?php
			}
			?>
		});
		</script>
		<?php
	}
	?>
	<div class="clear"></div>
</div>
